/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BinopExpr;
import org.aspectj.compiler.base.ast.BooleanLiteralExpr;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.IfStmt;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.base.cst.BlockScope;
import org.aspectj.compiler.base.cst.Scope;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.AdvicePlan;
import org.aspectj.compiler.crosscuts.joinpoints.AdvicePlanner;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlannerMaker;

public abstract class AdviceDec
extends CodeDec
implements JpPlannerMaker {
    private MethodDec methodDec;
    private boolean joinPointFlagsSet = false;
    private boolean needsStaticEnclosingJoinPoint;
    private boolean needsStaticJoinPoint;
    private boolean needsDynamicJoinPoint;
    protected FormalDec thisDynamicJoinPointFormal = null;
    protected FormalDec thisStaticJoinPointFormal = null;
    protected FormalDec thisStaticEnclosingJoinPointFormal = null;
    protected Pcd pcd;

    public String getKind() {
        return "advice";
    }

    public AspectDec getAspectDec() {
        return (AspectDec)this.getDeclaringType().getTypeDec();
    }

    public FormalDec getExtraFormal() {
        return null;
    }

    protected boolean isAfterAdvice() {
        return false;
    }

    protected boolean reverseSortOrder(AdviceDec a1, AdviceDec a2) {
        return a1.isAfterAdvice() || a2.isAfterAdvice();
    }

    public boolean dominates(AdviceDec otherAdvice) {
        AspectDec otherAspectDec;
        AspectDec myAspectDec = this.getAspectDec();
        if (myAspectDec == (otherAspectDec = otherAdvice.getAspectDec())) {
            if (this.reverseSortOrder(this, otherAdvice)) {
                return this.getBeginLine() > otherAdvice.getBeginLine();
            }
            return this.getBeginLine() < otherAdvice.getBeginLine();
        }
        return myAspectDec.dominates(otherAspectDec);
    }

    public JpPlanner makePlanner(PlanData planData) {
        if (planData.inAspect.isAbstract()) {
            return JpPlanner.NO_PLANNER;
        }
        JpPlanner planner = this.getPcd().makePlanner(planData);
        planner = planData.inAspect.findPerClause().makeInnerPlanner(planData).and(planner);
        return new AdvicePlanner(planData.inAspect, this, planner);
    }

    public void wrapJoinPoint(JoinPoint joinPoint, AdvicePlan plan) {
        joinPoint.setStmts(this.wrapStmts(joinPoint.getStmts(), plan));
    }

    protected Stmts wrapStmts(Stmts stmts, AdvicePlan plan) {
        this.showError("didn't implement code to concretize this advice");
        return null;
    }

    protected final Formals makeFormals() {
        Formals newFormals = this.getAST().makeFormals();
        Formals oldFormals = this.getFormals();
        int i = 0;
        while (i < oldFormals.size()) {
            oldFormals.get(i).clearParent();
            newFormals.add(oldFormals.get(i));
            ++i;
        }
        if (this.getExtraFormal() != null) {
            this.getExtraFormal().clearParent();
            newFormals.add(this.getExtraFormal());
        }
        return newFormals;
    }

    public final Type getExtraArgType() {
        if (this.getExtraFormal() == null) {
            return null;
        }
        return this.getExtraFormal().getType();
    }

    public MethodDec makeConcreteMethod() {
        if (this.methodDec == null) {
            this.methodDec = this.getMethodDec();
        }
        if (this.methodDec == null) {
            return null;
        }
        this.methodDec.setBody(this.makeMethodBody());
        this.finishMethodDec(this.methodDec);
        return this.methodDec;
    }

    protected CodeBody makeMethodBody() {
        return this.body;
    }

    protected void finishMethodDec(MethodDec methodDec) {
        if (this.modifiers.isStrict()) {
            methodDec.getModifiers().setStrict(true);
        }
    }

    int getDepth(AspectDec ad) {
        Type superType = ad.getSuperClassType();
        if (superType.isAspect()) {
            return 1 + this.getDepth((AspectDec)superType.getTypeDec());
        }
        return 0;
    }

    String makeUniqueAspectString() {
        int depth = this.getDepth(this.getAspectDec());
        if (depth == 0) {
            return "";
        }
        return Integer.toString(depth, 36);
    }

    String makeUniqueAdviceString() {
        String kind = this.getAdviceKind();
        Decs body = (Decs)this.getParent();
        int position = 0;
        int N = body.size();
        int i = 0;
        while (i < N) {
            AdviceDec ad;
            Dec dec = body.get(i);
            if (dec == this) break;
            if (dec instanceof AdviceDec && (ad = (AdviceDec)dec).getAdviceKind().equals(kind)) {
                ++position;
            }
            ++i;
        }
        return kind + Integer.toString(position, 36);
    }

    String makeUniqueName() {
        return this.makeUniqueAdviceString() + "$ajc" + this.makeUniqueAspectString();
    }

    public synchronized MethodDec getMethodDec() {
        if (this.methodDec != null) {
            return this.methodDec;
        }
        AST ast = this.getAST();
        String name = this.makeUniqueName();
        Modifiers modifiers = ast.makeModifiers(this.getModifiers().getValue());
        modifiers.setPublic(true);
        modifiers.setFinal(true);
        Formals formals = this.makeFormals();
        this.addJoinPointFormals(formals);
        this.methodDec = ast.makeMethod(modifiers, this.getResultType(), name, formals, null);
        if (this._throws != null) {
            this.methodDec.setThrows((TypeDs)this._throws.copy());
        }
        this.methodDec.setAllEnclosingTypes(this.getAspectDec().getType());
        return this.methodDec;
    }

    public Expr makeCall(Expr parent, Exprs baseExprs) {
        Exprs args = (Exprs)baseExprs.copy();
        if (parent == null) {
            parent = this.getAST().makeTypeExpr(this.getAspectDec().getType());
        }
        CallExpr ret = this.getAST().makeCall(this.getMethodDec().getMethod(), parent, args);
        return ret;
    }

    private void setJoinPointFlags() {
        if (!this.joinPointFlagsSet) {
            this.joinPointFlagsSet = true;
            DynamicJoinPointChecker jpChecker = new DynamicJoinPointChecker(this.getCompiler());
            jpChecker.checkAndFix(this.getBody());
            this.needsDynamicJoinPoint = jpChecker.needsDynamicJoinPoint();
            this.needsStaticJoinPoint = jpChecker.needsStaticJoinPoint();
            this.needsStaticEnclosingJoinPoint = jpChecker.needsStaticEnclosingJoinPoint();
        }
    }

    public boolean needsStaticEnclosingJoinPointFormal() {
        this.setJoinPointFlags();
        return this.needsStaticEnclosingJoinPoint;
    }

    public boolean needsStaticJoinPointFormal() {
        this.setJoinPointFlags();
        return this.needsStaticJoinPoint;
    }

    public boolean needsDynamicJoinPointFormal() {
        this.setJoinPointFlags();
        return this.needsDynamicJoinPoint;
    }

    public boolean needsCallSiteContext() {
        return this.needsDynamicJoinPointFormal() || this.needsStaticJoinPointFormal() || this.needsStaticEnclosingJoinPointFormal();
    }

    public void addJoinPointFormals(Formals formals) {
        if (this.needsStaticEnclosingJoinPointFormal()) {
            formals.add(this.thisStaticEnclosingJoinPointFormal);
        }
        if (this.needsStaticJoinPointFormal()) {
            formals.add(this.thisStaticJoinPointFormal);
        }
        if (this.needsDynamicJoinPointFormal()) {
            formals.add(this.thisDynamicJoinPointFormal);
        }
    }

    protected FormalDec makeJoinPointFormal(String name) {
        return this.getAST().makeFormal(this.getTypeManager().getJoinPointType(), name);
    }

    protected FormalDec makeJoinPointStaticPartFormal(String name) {
        return this.getAST().makeFormal(this.getTypeManager().getJoinPointStaticPartType(), name);
    }

    protected void setupFlowWalker(FlowCheckerPass w) {
        if (this.thisDynamicJoinPointFormal == null || this.thisStaticJoinPointFormal == null || this.thisStaticEnclosingJoinPointFormal == null) {
            throw new RuntimeException("join point formals not created yet");
        }
        w.setVars(w.getVars().addAssigned(this.thisDynamicJoinPointFormal).addAssigned(this.thisStaticJoinPointFormal).addAssigned(this.thisStaticEnclosingJoinPointFormal));
        super.setupFlowWalker(w);
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        return this.makeConcreteMethod();
    }

    protected BlockScope makeBodyScope(Scope parent) {
        return new BlockScope(this.getCompiler(), parent);
    }

    public void preScope(ScopeWalker walker) {
        super.preScope(walker);
        if (this.thisDynamicJoinPointFormal == null) {
            this.thisDynamicJoinPointFormal = this.makeJoinPointFormal("thisJoinPoint");
        }
        if (this.thisStaticJoinPointFormal == null) {
            this.thisStaticJoinPointFormal = this.makeJoinPointStaticPartFormal("thisJoinPointStaticPart");
        }
        if (this.thisStaticEnclosingJoinPointFormal == null) {
            this.thisStaticEnclosingJoinPointFormal = this.makeJoinPointStaticPartFormal("thisEnclosingJoinPointStaticPart");
        }
        walker.process(this.thisDynamicJoinPointFormal);
        walker.process(this.thisStaticJoinPointFormal);
        walker.process(this.thisStaticEnclosingJoinPointFormal);
    }

    public void checkSpec() {
        if (this.isStatic()) {
            this.getCompiler().warnVersion("0.8beta1", this, "no static modifier on advice");
        }
        int i = 0;
        while (i < this.formals.size()) {
            if (!this.formals.get((int)i).isBound) {
                this.formals.get(i).showError("not bound in this PCD");
            }
            ++i;
        }
        this.getBody().checkReturnType(this.getReturnType());
        this.getMethodDec();
    }

    public String getId() {
        return this.getAdviceKind();
    }

    public TypeD getResultTypeD() {
        return this.getReturnType().makeTypeD();
    }

    public Type getReturnType() {
        return this.getTypeManager().voidType;
    }

    public String toShortString() {
        String modString = this.getModifiers().toShortString();
        if (modString.length() > 0) {
            modString = modString + " ";
        }
        return modString + this.getAdviceKind() + this.getFormals().toShortString();
    }

    protected abstract String getAdviceKind();

    public void unparse(CodeWriter writer) {
    }

    public Pcd getPcd() {
        return this.pcd;
    }

    public void setPcd(Pcd _pcd) {
        if (_pcd != null) {
            _pcd.setParent(this);
        }
        this.pcd = _pcd;
    }

    public AdviceDec(SourceLocation location, Modifiers _modifiers, Formals _formals, TypeDs __throws, Pcd _pcd, CodeBody _body) {
        super(location, _modifiers, _formals, __throws, _body);
        this.setPcd(_pcd);
    }

    protected AdviceDec(SourceLocation source) {
        super(source);
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.formals;
            }
            case 2: {
                return this._throws;
            }
            case 3: {
                return this.pcd;
            }
            case 4: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "formals";
            }
            case 2: {
                return "throws";
            }
            case 3: {
                return "pcd";
            }
            case 4: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setFormals((Formals)child);
                return;
            }
            case 2: {
                this.setThrows((TypeDs)child);
                return;
            }
            case 3: {
                this.setPcd((Pcd)child);
                return;
            }
            case 4: {
                this.setBody((CodeBody)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 5;
    }

    public String getDefaultDisplayName() {
        return "AdviceDec()";
    }

    class DynamicJoinPointChecker
    extends Walker {
        boolean needsDynamic = false;
        boolean needsStatic = false;
        boolean needsStaticEnclosing = false;
        boolean needsFakeStatic = false;
        boolean makeFakeStatics = false;
        boolean inBlockThatCantRun = false;

        public boolean needsDynamicJoinPoint() {
            return this.needsDynamic;
        }

        public boolean needsStaticJoinPoint() {
            return this.needsStatic;
        }

        public boolean needsStaticEnclosingJoinPoint() {
            return this.needsStaticEnclosing;
        }

        DynamicJoinPointChecker(JavaCompiler compiler) {
            super(compiler);
        }

        public void checkAndFix(ASTObject body) {
            this.process(body);
            if (this.needsFakeStatic && !this.needsDynamic) {
                if (!this.getCompiler().getOptions().noMetaJoinPointOptimization) {
                    this.makeFakeStatics = true;
                    this.needsStatic = true;
                    this.process(body);
                } else {
                    this.needsDynamic = true;
                }
            }
        }

        boolean isStaticEnclosingJoinPoint(VarExpr varExpr) {
            return varExpr.getVarDec() == AdviceDec.this.thisStaticEnclosingJoinPointFormal;
        }

        boolean isStaticJoinPoint(VarExpr varExpr) {
            return varExpr.getVarDec() == AdviceDec.this.thisStaticJoinPointFormal;
        }

        boolean isDynamicJoinPoint(VarExpr varExpr) {
            return varExpr.getVarDec() == AdviceDec.this.thisDynamicJoinPointFormal;
        }

        void checkNoBang(VarExpr varExpr) {
            if (varExpr.isLhs()) {
                varExpr.showError("not allowed to set thisJoinPoint");
            }
        }

        boolean isStaticPartCall(CallExpr callExpr) {
            Expr expr = callExpr.getExpr();
            if (expr != null && expr instanceof VarExpr && this.isDynamicJoinPoint((VarExpr)expr)) {
                return callExpr.getMethod().getId().equals("getStaticPart");
            }
            return false;
        }

        boolean canTreatAsStatic(Method method) {
            String id = method.getId();
            return id.equals("toString") || id.equals("toShortString") || id.equals("toLongString") || id.equals("getKind") || id.equals("getSignature") || id.equals("getSourceLocation") || id.equals("getStaticPart");
        }

        boolean canTreatAsStatic(VarExpr varExpr) {
            ASTObject parent = varExpr.getParent();
            if (parent instanceof CallExpr) {
                Method calledMethod = ((CallExpr)parent).getMethod();
                return this.canTreatAsStatic(calledMethod);
            }
            if (parent instanceof BinopExpr) {
                BinopExpr binop = (BinopExpr)parent;
                return binop.getType().isEquivalent(this.getTypeManager().getStringType());
            }
            return false;
        }

        boolean isFinalBoolean(Expr expr) {
            return expr instanceof BooleanLiteralExpr;
        }

        boolean getFinalBooleanValue(Expr expr) {
            return ((BooleanLiteralExpr)expr).getBooleanValue();
        }

        protected Expr makeNullJoinPoint() {
            AST ast = this.getAST();
            return ast.makeParen(ast.forceCast(this.getTypeManager().getJoinPointType(), ast.makeNull()));
        }

        public ASTObject process(ASTObject node) {
            if (node instanceof IfStmt) {
                IfStmt ifStmt = (IfStmt)node;
                if (!this.inBlockThatCantRun && this.isFinalBoolean(ifStmt.getTest())) {
                    ifStmt.setTest((Expr)this.process(ifStmt.getTest()));
                    this.inBlockThatCantRun = !this.getFinalBooleanValue(ifStmt.getTest());
                    ifStmt.setThen((Stmt)this.process(ifStmt.getThen()));
                    boolean bl = this.inBlockThatCantRun = !this.inBlockThatCantRun;
                    if (ifStmt.getElse() != null) {
                        ifStmt.setElse((Stmt)this.process(ifStmt.getElse()));
                    }
                    this.inBlockThatCantRun = false;
                    return ifStmt;
                }
                return super.process(ifStmt);
            }
            if (node instanceof CallExpr) {
                CallExpr callExpr = (CallExpr)node;
                if (this.isStaticPartCall(callExpr)) {
                    this.needsFakeStatic = true;
                    if (this.makeFakeStatics) {
                        return AdviceDec.this.getAST().makeVar(AdviceDec.this.thisStaticJoinPointFormal);
                    }
                }
            } else if (node instanceof VarExpr) {
                VarExpr varExpr = (VarExpr)node;
                if (this.isStaticEnclosingJoinPoint(varExpr)) {
                    this.needsStaticEnclosing = true;
                    this.checkNoBang(varExpr);
                } else if (this.isStaticJoinPoint(varExpr)) {
                    this.needsStatic = true;
                    this.checkNoBang(varExpr);
                } else if (this.isDynamicJoinPoint(varExpr)) {
                    this.checkNoBang(varExpr);
                    if (this.inBlockThatCantRun) {
                        return this.makeNullJoinPoint();
                    }
                    if (this.canTreatAsStatic(varExpr)) {
                        this.needsFakeStatic = true;
                        if (this.makeFakeStatics) {
                            varExpr.setVarDec(AdviceDec.this.thisStaticJoinPointFormal);
                            varExpr.setType(null);
                            varExpr.getType();
                        }
                    } else {
                        this.needsDynamic = true;
                    }
                }
                return node;
            }
            return super.process(node);
        }
    }
}

