/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.LabeledStmt;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ReturnStmt;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.AnonymousMethodExpr;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.joinpoints.AdvicePlan;
import org.aspectj.compiler.crosscuts.joinpoints.ConstructorExecutionJp;
import org.aspectj.compiler.crosscuts.joinpoints.ExceptionHandlerJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;

public class AfterReturningAdviceDec
extends AdviceDec {
    private static final String CONSTRUCTOR_EXECUTION_BINDING_CHANGE = "return value will bind to null, use 'this' pointcut to bind executing object\n    behavior change to fix compiler bug in 1.0.3 and earlier";
    private static final String VOID_RETURN_CHANGE = "will not match this joinpoint, use Object return type in advice if match desired\n    behavior change to fix compiler bug in 1.0.3 and earlier";
    protected FormalDec extraFormal;

    protected String getAdviceKind() {
        return "afterReturning";
    }

    protected boolean isAfterAdvice() {
        return true;
    }

    protected Stmts wrapStmts(Stmts stmts, AdvicePlan plan) {
        JoinPoint jp = plan.getJoinPoint();
        FormalDec formal = this.getExtraFormal();
        if (jp instanceof ExceptionHandlerJp) {
            this.showWarning("can't apply after returning advice to exception handler join points (compiler limitation)");
            jp.getSourceLocation().showWarning("trying to apply above after returning advice to execution of this exception handler");
            return stmts;
        }
        if (jp.getResultType().isVoid() && formal != null && !formal.getType().isObject()) {
            jp.showWarning(this, VOID_RETURN_CHANGE);
            return stmts;
        }
        if (jp instanceof ConstructorExecutionJp && formal != null && formal.getType().isObject()) {
            jp.showWarning(this, CONSTRUCTOR_EXECUTION_BINDING_CHANGE);
        }
        ReturnFixerWalker walker = new ReturnFixerWalker(this.getCompiler(), plan);
        Stmts ret = walker.removeReturns(stmts);
        return ret;
    }

    protected void setupFlowWalker(FlowCheckerPass w) {
        if (this.getExtraFormal() != null) {
            w.setVars(w.getVars().addAssigned(this.getExtraFormal()));
        }
        super.setupFlowWalker(w);
    }

    public FormalDec getExtraFormal() {
        return this.extraFormal;
    }

    public void setExtraFormal(FormalDec _extraFormal) {
        if (_extraFormal != null) {
            _extraFormal.setParent(this);
        }
        this.extraFormal = _extraFormal;
    }

    public AfterReturningAdviceDec(SourceLocation location, Modifiers _modifiers, Formals _formals, FormalDec _extraFormal, TypeDs __throws, Pcd _pcd, CodeBody _body) {
        super(location, _modifiers, _formals, __throws, _pcd, _body);
        this.setExtraFormal(_extraFormal);
    }

    protected AfterReturningAdviceDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        AfterReturningAdviceDec ret = new AfterReturningAdviceDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.formals != null) {
            ret.setFormals((Formals)walker.process(this.formals));
        }
        if (this.extraFormal != null) {
            ret.setExtraFormal((FormalDec)walker.process(this.extraFormal));
        }
        if (this._throws != null) {
            ret.setThrows((TypeDs)walker.process(this._throws));
        }
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        if (this.body != null) {
            ret.setBody((CodeBody)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.formals;
            }
            case 2: {
                return this.extraFormal;
            }
            case 3: {
                return this._throws;
            }
            case 4: {
                return this.pcd;
            }
            case 5: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "formals";
            }
            case 2: {
                return "extraFormal";
            }
            case 3: {
                return "throws";
            }
            case 4: {
                return "pcd";
            }
            case 5: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setFormals((Formals)child);
                return;
            }
            case 2: {
                this.setExtraFormal((FormalDec)child);
                return;
            }
            case 3: {
                this.setThrows((TypeDs)child);
                return;
            }
            case 4: {
                this.setPcd((Pcd)child);
                return;
            }
            case 5: {
                this.setBody((CodeBody)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 6;
    }

    public String getDefaultDisplayName() {
        return "AfterReturningAdviceDec()";
    }

    static class ReturnFixerWalker
    extends Walker {
        AdvicePlan plan;
        VarDec thisResultVar;
        String label;
        boolean seenVoidReturn = false;
        boolean seenAnyReturns = false;

        public ReturnFixerWalker(JavaCompiler compiler, AdvicePlan plan) {
            super(compiler);
            this.plan = plan;
        }

        public Stmts removeReturns(Stmts stmts) {
            ReturnStmt returnStmt;
            Expr thisResultExpr;
            AST ast = this.getAST();
            Type resultType = this.plan.getJoinPoint().getResultType();
            if (resultType.isVoid()) {
                this.thisResultVar = null;
                thisResultExpr = ast.makeNull();
                returnStmt = ast.makeReturn();
            } else {
                this.thisResultVar = ast.makeVarDec(resultType, "_thisResult", resultType.getNullExpr());
                thisResultExpr = ast.makeVar(this.thisResultVar);
                returnStmt = ast.makeReturn(ast.makeVar(this.thisResultVar));
            }
            this.label = this.getWorld().genLabel();
            Stmts ret = (Stmts)this.process(stmts);
            LabeledStmt body = ast.makeLabeled(this.label, ast.makeIf(ast.makeLiteral(true), ret.getSingleStmt()));
            ret = ast.makeStmts(body, this.plan.makeCall(thisResultExpr), returnStmt);
            if (!resultType.isVoid()) {
                ret.add(0, this.thisResultVar);
            }
            return ret;
        }

        public Stmt wrapReturn(ReturnStmt returnStmt) {
            AST ast = this.getAST();
            Expr returnExpr = returnStmt.getExpr();
            if (returnExpr == null) {
                return ast.makeBreak(this.label);
            }
            return ast.makeBlock(ast.makeSet(this.thisResultVar, returnExpr), ast.makeBreak(this.label));
        }

        public ASTObject process(ASTObject object) {
            if (object instanceof TypeDec) {
                return object;
            }
            if (object instanceof AnonymousMethodExpr) {
                return object;
            }
            if (object instanceof ReturnStmt) {
                return this.wrapReturn((ReturnStmt)object);
            }
            return super.process(object);
        }
    }
}

