/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.ExceptionFinder;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.ThrowStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.joinpoints.AdvicePlan;

public class AfterThrowingAdviceDec
extends AdviceDec {
    private static int excIndex = 0;
    protected FormalDec extraFormal;

    protected String getAdviceKind() {
        return "afterThrowing";
    }

    protected boolean isAfterAdvice() {
        return true;
    }

    protected Stmts wrapStmts(Stmts stmts, AdvicePlan plan) {
        return this.wrapAfterThrowingCall(plan, stmts);
    }

    Stmt makeSingleRethrow(VarDec formal, Type excType, boolean needTest) {
        AST ast = this.getAST();
        Expr castExpr = ast.makeCast(excType, ast.makeVar(formal));
        ThrowStmt rethrow = ast.makeThrow(castExpr);
        if (needTest) {
            return ast.makeIf(ast.makeInstanceof(ast.makeVar(formal), excType), rethrow);
        }
        return rethrow;
    }

    Stmts makeRethrows(VarDec formal, Set exceptions) {
        Stmts stmts = this.getAST().makeStmts();
        exceptions = Type.filterSubTypes(formal.getType(), exceptions);
        if ((exceptions = Type.filterTopTypes(exceptions)).size() == 1) {
            Type checkType = (Type)exceptions.iterator().next();
            stmts.add(this.makeSingleRethrow(formal, checkType, false));
            return stmts;
        }
        Iterator iter = exceptions.iterator();
        while (iter.hasNext()) {
            Type checkType = (Type)iter.next();
            stmts.add(this.makeSingleRethrow(formal, checkType, iter.hasNext()));
        }
        return stmts;
    }

    private CatchClause makeCatchClause(Type catchType, AdvicePlan plan, int index, Set exceptions) {
        AST ast = this.getAST();
        String newName = "ajcexc$" + excIndex++;
        FormalDec newFormal = ast.makeFormal(catchType, newName);
        Stmt doCall = plan.makeCall(ast.makeVar(newFormal));
        Stmts rethrows = this.makeRethrows(newFormal, exceptions);
        rethrows.add(0, doCall);
        return ast.makeCatch(newFormal, ast.makeBlock(rethrows));
    }

    boolean isUncheckedException(Type baseType) {
        return baseType.isSubtypeOf(this.getTypeManager().getRuntimeExceptionType()) || baseType.isSubtypeOf(this.getTypeManager().getErrorType());
    }

    boolean canThrow(Set types, Type baseType) {
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            Type checkType = (Type)iter.next();
            if ((checkType == null || !checkType.isSubtypeOf(baseType)) && !baseType.isSubtypeOf(checkType)) continue;
            return true;
        }
        return false;
    }

    public Stmts wrapAfterThrowingCall(AdvicePlan plan, Stmts baseStmts) {
        FormalDec formal = ((AfterThrowingAdviceDec)plan.getAdviceDec()).getExtraFormal();
        Set exceptions = ExceptionFinder.getPossibleExceptions(baseStmts, true);
        exceptions.add(this.getTypeManager().getRuntimeExceptionType());
        exceptions.add(this.getTypeManager().getErrorType());
        Type catchType = formal != null ? formal.getType() : this.getTypeManager().getThrowableType();
        if (!this.canThrow(exceptions, catchType)) {
            return baseStmts;
        }
        int index = 0;
        CatchClause catches = this.makeCatchClause(catchType, plan, index, exceptions);
        AST ast = this.getAST();
        return ast.makeStmts(ast.makeTryCatch(ast.makeBlock(baseStmts), catches));
    }

    protected void setupFlowWalker(FlowCheckerPass w) {
        if (this.getExtraFormal() != null) {
            w.setVars(w.getVars().addAssigned(this.getExtraFormal()));
        }
        super.setupFlowWalker(w);
    }

    public FormalDec getExtraFormal() {
        return this.extraFormal;
    }

    public void setExtraFormal(FormalDec _extraFormal) {
        if (_extraFormal != null) {
            _extraFormal.setParent(this);
        }
        this.extraFormal = _extraFormal;
    }

    public AfterThrowingAdviceDec(SourceLocation location, Modifiers _modifiers, Formals _formals, FormalDec _extraFormal, TypeDs __throws, Pcd _pcd, CodeBody _body) {
        super(location, _modifiers, _formals, __throws, _pcd, _body);
        this.setExtraFormal(_extraFormal);
    }

    protected AfterThrowingAdviceDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        AfterThrowingAdviceDec ret = new AfterThrowingAdviceDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.formals != null) {
            ret.setFormals((Formals)walker.process(this.formals));
        }
        if (this.extraFormal != null) {
            ret.setExtraFormal((FormalDec)walker.process(this.extraFormal));
        }
        if (this._throws != null) {
            ret.setThrows((TypeDs)walker.process(this._throws));
        }
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        if (this.body != null) {
            ret.setBody((CodeBody)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.formals;
            }
            case 2: {
                return this.extraFormal;
            }
            case 3: {
                return this._throws;
            }
            case 4: {
                return this.pcd;
            }
            case 5: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "formals";
            }
            case 2: {
                return "extraFormal";
            }
            case 3: {
                return "throws";
            }
            case 4: {
                return "pcd";
            }
            case 5: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setFormals((Formals)child);
                return;
            }
            case 2: {
                this.setExtraFormal((FormalDec)child);
                return;
            }
            case 3: {
                this.setThrows((TypeDs)child);
                return;
            }
            case 4: {
                this.setPcd((Pcd)child);
                return;
            }
            case 5: {
                this.setBody((CodeBody)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 6;
    }

    public String getDefaultDisplayName() {
        return "AfterThrowingAdviceDec()";
    }
}

