/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Iterator;
import java.util.Map;
import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ExprMaker;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.crosscuts.MixinImplementationPass;

public class AnonymousMethodExpr
extends Expr {
    protected Exprs args;
    protected MethodDec methodDec;

    protected Type discoverType() {
        return this.methodDec.getResultType();
    }

    public void grabContext() {
        ExprMaker em = new ExprMaker(this.getCompiler());
        em.process(this.methodDec);
        Map inParams = em.getInParams();
        Exprs args = this.getArgs();
        Formals formals = this.methodDec.getFormals();
        Iterator i = inParams.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            VarDec varDec = (VarDec)entry.getKey();
            varDec.getModifiers().setFinal(true);
            args.add(this.getAST().makeVar(varDec));
            FormalDec formalDec = (FormalDec)entry.getValue();
            formals.add(formalDec);
        }
    }

    public ASTObject postMove(MovingWalker walker) {
        this.grabContext();
        return this;
    }

    public void fixAST(ASTFixerPass fixer) {
        this.args = (Exprs)fixer.process(this.args);
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        if (this.inStaticContext()) {
            this.methodDec.getModifiers().setStatic(true);
        } else {
            this.methodDec.getModifiers().setStatic(false);
        }
        TypeDec inTypeDec = this.getBytecodeTypeDec();
        if (this.methodDec.isStatic() && inTypeDec.isInner()) {
            inTypeDec = inTypeDec.getOutermostTypeDec();
        }
        Decs body = inTypeDec.getBody();
        this.methodDec.getModifiers().setPrivate(true);
        body.add(this.getMethodDec());
        this.getMethodDec().setAllEnclosingTypes(inTypeDec.getType());
        Expr thisExpr = this.methodDec.isStatic() ? this.getAST().makeTypeExpr(inTypeDec.getType()) : this.getAST().makeThis(inTypeDec.getType());
        return this.getAST().makeCall(this.getMethodDec(), thisExpr, this.args);
    }

    public void implementMixin(MixinImplementationPass fixer) {
    }

    public void unparse(CodeWriter writer) {
        writer.write("DecInExpr[");
        writer.write(this.args);
        writer.write(" -> ");
        writer.write(this.methodDec);
        writer.write("]");
    }

    public Exprs getArgs() {
        return this.args;
    }

    public void setArgs(Exprs _args) {
        if (_args != null) {
            _args.setParent(this);
        }
        this.args = _args;
    }

    public MethodDec getMethodDec() {
        return this.methodDec;
    }

    public void setMethodDec(MethodDec _methodDec) {
        if (_methodDec != null) {
            _methodDec.setParent(this);
        }
        this.methodDec = _methodDec;
    }

    public AnonymousMethodExpr(SourceLocation location, Exprs _args, MethodDec _methodDec) {
        super(location);
        this.setArgs(_args);
        this.setMethodDec(_methodDec);
    }

    protected AnonymousMethodExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        AnonymousMethodExpr ret = new AnonymousMethodExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.args != null) {
            ret.setArgs((Exprs)walker.process(this.args));
        }
        if (this.methodDec != null) {
            ret.setMethodDec((MethodDec)walker.process(this.methodDec));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.args;
            }
            case 1: {
                return this.methodDec;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "args";
            }
            case 1: {
                return "methodDec";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setArgs((Exprs)child);
                return;
            }
            case 1: {
                this.setMethodDec((MethodDec)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "AnonymousMethodExpr()";
    }
}

