/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.FormalsPattern;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class ArgsPcd
extends Pcd {
    protected FormalsPattern argTypeNames;

    public String toShortString() {
        return "args(" + this.getArgTypeNames().toShortString() + ")";
    }

    public boolean allowsNameBinding() {
        return true;
    }

    public void checkStatic() {
        this.showNonStaticError();
    }

    public JpPlanner makePlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                return FuzzyBoolean.MAYBE;
            }

            public JpPlan makePlan(JoinPoint jp) {
                Exprs argsExprs = jp.makeArgsExprs();
                if (argsExprs == null) {
                    return JpPlan.NO_PLAN;
                }
                return ArgsPcd.this.getArgTypeNames().makePlan(argsExprs, jp);
            }
        };
    }

    public FormalsPattern getArgTypeNames() {
        return this.argTypeNames;
    }

    public void setArgTypeNames(FormalsPattern _argTypeNames) {
        if (_argTypeNames != null) {
            _argTypeNames.setParent(this);
        }
        this.argTypeNames = _argTypeNames;
    }

    public ArgsPcd(SourceLocation location, FormalsPattern _argTypeNames) {
        super(location);
        this.setArgTypeNames(_argTypeNames);
    }

    protected ArgsPcd(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ArgsPcd ret = new ArgsPcd(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.argTypeNames != null) {
            ret.setArgTypeNames((FormalsPattern)walker.process(this.argTypeNames));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.argTypeNames;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "argTypeNames";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setArgTypeNames((FormalsPattern)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "ArgsPcd()";
    }
}

