/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CatchClauses;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.NewInstanceExpr;
import org.aspectj.compiler.base.ast.QualifiedThisExpr;
import org.aspectj.compiler.base.ast.ReturnStmt;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.ThrowStmt;
import org.aspectj.compiler.base.ast.TryCatchStmt;
import org.aspectj.compiler.base.ast.TryStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.AnonymousMethodExpr;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.ProceedExpr;
import org.aspectj.compiler.crosscuts.joinpoints.AdviceExecutionJp;
import org.aspectj.compiler.crosscuts.joinpoints.AdvicePlan;
import org.aspectj.compiler.crosscuts.joinpoints.ExceptionHandlerJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;

public class AroundAdviceDec
extends AdviceDec {
    Collection returnStmts = new ArrayList();
    Collection proceedExprs = new ArrayList();
    private boolean containsInners = false;
    private boolean isTargetOfAnyAroundAdvice = false;
    public List joinPoints1 = new ArrayList();
    public List joinPoints2 = new ArrayList();
    private boolean ensuredIsWoven = false;
    private boolean ensuringIsWoven = false;
    private FormalDec closureFormal = null;
    private boolean fixedProceedCalls = false;
    static int closureNumber = 1;
    static int aroundNumber = 1;
    protected TypeD resultTypeD;

    private boolean shouldInline() {
        return !this.containsInners && !this.isTargetOfAnyAroundAdvice && !this.getOptions().alwaysMakeAroundClosures;
    }

    public MethodDec getMethodDec() {
        MethodDec md = super.getMethodDec();
        md.setThrows(this.getAST().makeTypeDs(this.getTypeManager().getThrowableType().makeTypeD()));
        return md;
    }

    protected String getAdviceKind() {
        return "around";
    }

    void implementPlans(List jps) {
        Iterator i = jps.iterator();
        while (i.hasNext()) {
            JoinPoint joinPoint = (JoinPoint)i.next();
            joinPoint.implementPlans();
        }
    }

    private boolean ensureBodyIsWoven(AdvicePlan plan) {
        if (this.ensuredIsWoven) {
            return true;
        }
        if (this.ensuringIsWoven) {
            this.isTargetOfAnyAroundAdvice = true;
            return false;
        }
        this.ensuringIsWoven = true;
        this.implementPlans(this.joinPoints1);
        this.implementPlans(this.joinPoints2);
        this.ensuringIsWoven = false;
        this.ensuredIsWoven = true;
        return true;
    }

    protected Stmts wrapStmts(Stmts stmts, AdvicePlan plan) {
        AdviceDec ad;
        if (this.shouldInline()) {
            this.ensureBodyIsWoven(plan);
        }
        if (!this.checkPlan(plan)) {
            return stmts;
        }
        JoinPoint jp = plan.getJoinPoint();
        if (jp instanceof AdviceExecutionJp && (ad = (AdviceDec)jp.getTargetDec()) instanceof AroundAdviceDec) {
            AroundAdviceDec aad = (AroundAdviceDec)ad;
            aad.isTargetOfAnyAroundAdvice = true;
            aad.fixProceedCalls();
        }
        if (jp instanceof ExceptionHandlerJp) {
            this.showWarning("can't apply around advice to exception handler join points (compiler limitation)");
            jp.getSourceLocation().showWarning("trying to apply above around advice to execution of this exception handler");
            return stmts;
        }
        if (this.shouldInline()) {
            return this.wrapStmtsInline(stmts, plan);
        }
        return this.wrapStmtsWithClosure(stmts, plan);
    }

    private Stmts wrapStmtsWithClosure(Stmts stmts, AdvicePlan plan) {
        Stmts retStmts;
        JoinPoint jp = plan.getJoinPoint();
        TypeDec parentTypeDec = stmts.getBytecodeTypeDec();
        if (parentTypeDec instanceof InterfaceDec) {
            this.showWarning("can't apply around advice which contains inner types to interface methods (compiler limitation)");
            jp.getTargetNode().showWarning("trying to apply to this location");
            return stmts;
        }
        AST ast = this.getAST();
        Modifiers m = ast.makeModifiers(1);
        FormalDec argsFormal = ast.makeFinalFormal(this.getTypeManager().getObjectType().getArrayType(), "_args");
        ClosureWalker closureWalker = new ClosureWalker(this.getCompiler(), stmts, this.makeProceedMap(plan), argsFormal);
        Constructor superConstructor = this.getTypeManager().getAroundClosureType().getConstructor(stmts, ast.makeExprs(), false);
        ConstructorDec constructorDec = ast.makeConstructor(ast.makeModifiers(0), closureWalker.getConstructorFormals(), ast.makeTypeDs(), ast.makeConstructorCall(true, ast.makeExprs(), superConstructor), closureWalker.getFieldInitStmts());
        MethodDec methodDec = ast.makeMethod(m, this.getTypeManager().getObjectType(), "run", ast.makeFormals(argsFormal), closureWalker.getRunBody());
        String closureName = this.genClosureName();
        ClassDec classDec = ast.makeClass(ast.makeModifiers(2), closureName, this.getTypeManager().getAroundClosureType().makeTypeD(), ast.makeTypeDs());
        if (plan.getJoinPoint().isStaticContext()) {
            classDec.getModifiers().setStatic(true);
        }
        constructorDec.setExplicitlyNonSynthetic();
        classDec.addToBody(constructorDec);
        methodDec.setAllEnclosingTypes(classDec.getType());
        classDec.getBody().add(methodDec);
        Iterator i = closureWalker.getFields().iterator();
        while (i.hasNext()) {
            FieldDec fd = (FieldDec)i.next();
            classDec.getBody().add(fd);
        }
        parentTypeDec.getBody().add(classDec);
        classDec.setEnclosingTypeDec(parentTypeDec);
        classDec.getNameType().addToTypeGraph();
        classDec.getNameType().buildSignatures();
        NewInstanceExpr newExpr = ast.makeNew(classDec.getType(), closureWalker.getConstructorArgs());
        if (!plan.getJoinPoint().isStaticContext()) {
            classDec.setIsInner(true);
            newExpr.setEnclosingInstanceExpr(ast.makeQualifiedThis(parentTypeDec.getType()));
        }
        this.getMethodDec();
        Exprs args = plan.makeCallExprs(newExpr);
        Expr ret = ast.makeCall(this.getMethodDec().getMethod(), plan.getInstance(), args);
        if (plan.getJoinPoint().getResultType().isVoid()) {
            retStmts = ast.makeStmts(ast.makeStmt(ret));
        } else {
            ret = plan.getJoinPoint().getResultType().fromObject(ret);
            retStmts = ast.makeStmts(ast.makeReturn(ret));
        }
        retStmts = this.wrapCatchThrowable(retStmts, new HashSet(jp.getPossibleCheckedExceptions()));
        Expr test = plan.getDynamicTest();
        if (test == null) {
            return retStmts;
        }
        return ast.makeStmts(ast.makeIf(test, ast.makeBlock(retStmts), ast.makeBlock(closureWalker.makeDispatchCall())));
    }

    private Stmts wrapCatchThrowable(Stmts s, Set checkedExcs) {
        AST ast = this.getAST();
        checkedExcs = new HashSet<NameType>(checkedExcs);
        CatchClauses clauses = new CatchClauses(ast.getSourceLocation());
        checkedExcs.add(this.getTypeManager().getErrorType());
        checkedExcs.add(this.getTypeManager().getRuntimeExceptionType());
        checkedExcs = Type.filterTopTypes(checkedExcs);
        Iterator i = checkedExcs.iterator();
        while (i.hasNext()) {
            Type excType = (Type)i.next();
            FormalDec formal = ast.makeFinalFormal(excType, "ajc$exc");
            BlockStmt body = ast.makeBlock(ast.makeThrow(ast.makeVar(formal)));
            clauses.add(ast.makeCatch(formal, body));
        }
        clauses.add(ast.makeCatch(ast.makeFinalFormal(this.getTypeManager().getThrowableType(), "ajc$ignore"), ast.makeBlock(ast.makeThrow(this.getTypeManager().getErrorType(), "can't throw"))));
        TryCatchStmt tryStmt = new TryCatchStmt(ast.getSourceLocation(), ast.makeBlock(s), clauses);
        return ast.makeStmts(tryStmt);
    }

    public FormalDec getExtraFormal() {
        if (this.closureFormal == null) {
            this.closureFormal = this.makeExtraFormal();
        }
        return this.closureFormal;
    }

    private FormalDec makeExtraFormal() {
        return this.getAST().makeFinalFormal(this.getTypeManager().getAroundClosureType(), "ajc$closure");
    }

    private boolean containsProceed(ASTObject node) {
        return new Walker(this.getCompiler()){
            private boolean hasProceed = false;

            public boolean hasProceed(ASTObject node1) {
                this.process(node1);
                return this.hasProceed;
            }

            public ASTObject process(ASTObject object) {
                if (this.hasProceed) {
                    return object;
                }
                if (object instanceof ProceedExpr) {
                    this.hasProceed = true;
                    return object;
                }
                if (object instanceof TypeDec || object instanceof MethodDec) {
                    return object;
                }
                return super.process(object);
            }
        }.hasProceed(node);
    }

    private Map makeProceedMap(AdvicePlan plan) {
        JoinPoint jp = plan.getJoinPoint();
        Formals formals = this.getFormals();
        HashMap<Object, Integer> proceedMap = new HashMap<Object, Integer>();
        int i = 0;
        int N = formals.size();
        while (i < N) {
            VarExpr var;
            FormalDec formal = formals.get(i);
            Expr value = (Expr)plan.bindings.get(formal);
            if (value instanceof VarExpr) {
                var = (VarExpr)value;
                proceedMap.put(var.getVarDec(), new Integer(i));
            } else if (value instanceof ThisExpr) {
                Type toType = jp.getBytecodeType();
                proceedMap.put("this", new Integer(i));
            } else if (value instanceof NewInstanceExpr) {
                var = (VarExpr)((NewInstanceExpr)value).getArgs().get(0);
                proceedMap.put(var.getVarDec(), new Integer(i));
            }
            ++i;
        }
        return proceedMap;
    }

    private boolean isProceedChangable(Expr expr) {
        return expr instanceof VarExpr || expr instanceof ThisExpr || expr instanceof NewInstanceExpr;
    }

    private void fixProceedCalls() {
        if (this.fixedProceedCalls) {
            return;
        }
        this.fixedProceedCalls = true;
        ClosureProceedFixer fixer = new ClosureProceedFixer(this.getCompiler(), this.getBody().getStmts());
        this.getBody().walk(fixer);
    }

    protected CodeBody makeMethodBody() {
        this.fixProceedCalls();
        return this.getBody();
    }

    private String genClosureName() {
        return "Closure" + closureNumber++;
    }

    String genDispatchName(CodeDec codeDec) {
        return this.getAST().makeGeneratedName("dispatch" + closureNumber++ + "_" + codeDec.getName());
    }

    private String genAroundName(CodeDec codeDec) {
        return this.getAST().makeGeneratedName("around" + aroundNumber++ + "_" + codeDec.getName());
    }

    private Stmts wrapStmtsInline(Stmts stmts, AdvicePlan plan) {
        Stmts retStmts;
        AST ast = this.getAST();
        JoinPoint jp = plan.getJoinPoint();
        FormalDec argsFormal = ast.makeFinalFormal(this.getTypeManager().getObjectType().getArrayType(), "_args");
        InlineWalker inlineWalker = new InlineWalker(this.getCompiler(), stmts, this.makeProceedMap(plan), plan.makeCallExprs(ast.makeNull()), plan.getInstance());
        Exprs args = inlineWalker.aroundMethodArgs;
        CallExpr callAroundMethod = ast.makeCall(inlineWalker.makeInlineAroundMethod().getMethod(), jp.makeThisExprOrType(), args);
        callAroundMethod.setSourceLocation(jp.getTargetNode().getSourceLocation());
        Expr ret = callAroundMethod;
        if (plan.getJoinPoint().getResultType().isVoid()) {
            retStmts = ast.makeStmts(ast.makeStmt(ret));
        } else {
            ret = plan.getJoinPoint().getResultType().fromObject(ret);
            retStmts = ast.makeStmts(ast.makeReturn(ret));
        }
        Expr test = plan.getDynamicTest();
        if (test != null) {
            retStmts = ast.makeStmts(ast.makeIf(test, ast.makeBlock(retStmts), ast.makeBlock(inlineWalker.makeDispatchCall())));
        }
        if (this.getOptions().XOcodeSize) {
            inlineWalker.inlineSoleCallExpr(jp);
            if (!callAroundMethod.tryToInline(jp.getBytecodeType())) {
                jp.showWarning(this, "couldn't inline sole call expr");
            }
        }
        return retStmts;
    }

    boolean checkType(JoinPoint jp, Expr expr, Type type, String kind) {
        if (expr.getType().isReferenceType()) {
            type = type.getRefType();
        }
        if (!expr.getType().isCoercableTo(type)) {
            jp.showError(expr, expr.getType().getString() + " is not coercable to expected " + kind + " type " + type.getString());
            return false;
        }
        return true;
    }

    boolean checkImmutableReference(VarDec varDec, Expr expr) {
        if (!varDec.isFinal()) {
            varDec.showError("cflow-exposed state must be final (compiler limitation)");
            return false;
        }
        if (!(expr instanceof VarExpr) || ((VarExpr)expr).getVarDec() != varDec) {
            expr.showError("must be a simple reference to " + varDec.toShortString() + " (compiler limitation)");
            return false;
        }
        return true;
    }

    public boolean checkPlan(AdvicePlan plan) {
        JoinPoint jp = plan.getJoinPoint();
        Type resultType = this.resultTypeD.getType();
        Type pointResultType = jp.getResultType();
        if (resultType.isEquivalent(this.getTypeManager().anyType)) {
            this.showError("returns * is not allowed (use returns Object instead)");
            return false;
        }
        if (!resultType.isEquivalent(this.getTypeManager().getObjectType())) {
            if (resultType.isEquivalent(this.getTypeManager().voidType)) {
                if (!pointResultType.isEquivalent(this.getTypeManager().voidType)) {
                    jp.showError(this, "doesn't return void");
                    return false;
                }
            } else if (!resultType.isAssignableFrom(pointResultType)) {
                jp.showError(this, "returns " + pointResultType.toShortString());
                return false;
            }
        }
        Iterator i = this.proceedExprs.iterator();
        while (i.hasNext()) {
            ProceedExpr proceedExpr = (ProceedExpr)i.next();
            Exprs proceedArgs = proceedExpr.getArgs();
            int j = 0;
            int N = this.formals.size();
            while (j < N) {
                FormalDec formal = this.formals.get(j);
                Expr value = (Expr)plan.bindings.get(formal);
                if (!this.isProceedChangable(value) && !this.checkImmutableReference(formal, proceedArgs.get(j))) {
                    return false;
                }
                if (!this.checkType(jp, proceedArgs.get(j), value.getType(), "arg")) {
                    return false;
                }
                ++j;
            }
        }
        if (resultType.isVoid()) {
            return true;
        }
        Iterator i2 = this.returnStmts.iterator();
        while (i2.hasNext()) {
            ReturnStmt returnStmt = (ReturnStmt)i2.next();
            if (this.checkType(jp, returnStmt.getExpr(), pointResultType, "return")) continue;
            return false;
        }
        return true;
    }

    public Type getReturnType() {
        Type resultType = this.resultTypeD == null ? this.getTypeManager().voidType : this.resultTypeD.getType();
        return resultType;
    }

    public void preScope(ScopeWalker walker) {
        if (!walker.walkBodies()) {
            new Walker(this.getCompiler()){
                private boolean inCodeOrType = false;

                public ASTObject process(ASTObject o) {
                    if (!this.inCodeOrType && (o instanceof TypeDec || o instanceof CodeDec)) {
                        this.inCodeOrType = true;
                        o.walk(this);
                        this.inCodeOrType = false;
                    } else {
                        o.walk(this);
                    }
                    if (o instanceof CallExpr) {
                        CallExpr callExpr = (CallExpr)o;
                        if (callExpr.getId().equals("proceed")) {
                            ProceedExpr ret = new ProceedExpr(callExpr.getSourceLocation(), callExpr.getArgs(), AroundAdviceDec.this);
                            AroundAdviceDec.this.addProceedExpr(ret);
                            return ret;
                        }
                    } else {
                        if (o instanceof TryStmt) {
                            TryStmt tryStmt = (TryStmt)o;
                            tryStmt.setIsOptional(true);
                            return o;
                        }
                        if (o instanceof TypeDec) {
                            AroundAdviceDec.this.containsInners = true;
                        } else if (!this.inCodeOrType && o instanceof ReturnStmt) {
                            AroundAdviceDec.this.returnStmts.add(o);
                        }
                    }
                    return o;
                }
            }.process(this.getBody());
        }
        super.preScope(walker);
    }

    public void checkSpec() {
        super.checkSpec();
        this.checkAllProceedExprs();
    }

    private void checkAllProceedExprs() {
        Iterator i = this.proceedExprs.iterator();
        while (i.hasNext()) {
            boolean valid = this.checkProceedExpr((ProceedExpr)i.next());
            if (valid) continue;
            i.remove();
        }
    }

    private boolean checkProceedExpr(ProceedExpr expr) {
        Formals formals = this.getFormals();
        Exprs args = expr.getArgs();
        int nFormals = formals.size();
        int nArgs = args.size();
        if (nArgs != nFormals) {
            expr.showError("expected " + nFormals + " args, found " + nArgs);
            return false;
        }
        int i = 0;
        while (i < nFormals) {
            FormalDec formal = formals.get(i);
            Expr arg = args.get(i);
            if (!arg.getType().isMethodConvertableTo(formal.getType())) {
                arg.showTypeError(arg.getType(), formal.getType());
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addProceedExpr(ProceedExpr expr) {
        this.proceedExprs.add(expr);
    }

    public TypeD getResultTypeD() {
        return this.resultTypeD;
    }

    public void setResultTypeD(TypeD _resultTypeD) {
        if (_resultTypeD != null) {
            _resultTypeD.setParent(this);
        }
        this.resultTypeD = _resultTypeD;
    }

    public AroundAdviceDec(SourceLocation location, Modifiers _modifiers, TypeD _resultTypeD, Formals _formals, TypeDs __throws, Pcd _pcd, CodeBody _body) {
        super(location, _modifiers, _formals, __throws, _pcd, _body);
        this.setResultTypeD(_resultTypeD);
    }

    protected AroundAdviceDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        AroundAdviceDec ret = new AroundAdviceDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.resultTypeD != null) {
            ret.setResultTypeD((TypeD)walker.process(this.resultTypeD));
        }
        if (this.formals != null) {
            ret.setFormals((Formals)walker.process(this.formals));
        }
        if (this._throws != null) {
            ret.setThrows((TypeDs)walker.process(this._throws));
        }
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        if (this.body != null) {
            ret.setBody((CodeBody)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.resultTypeD;
            }
            case 2: {
                return this.formals;
            }
            case 3: {
                return this._throws;
            }
            case 4: {
                return this.pcd;
            }
            case 5: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "resultTypeD";
            }
            case 2: {
                return "formals";
            }
            case 3: {
                return "throws";
            }
            case 4: {
                return "pcd";
            }
            case 5: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setResultTypeD((TypeD)child);
                return;
            }
            case 2: {
                this.setFormals((Formals)child);
                return;
            }
            case 3: {
                this.setThrows((TypeDs)child);
                return;
            }
            case 4: {
                this.setPcd((Pcd)child);
                return;
            }
            case 5: {
                this.setBody((CodeBody)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 6;
    }

    public String getDefaultDisplayName() {
        return "AroundAdviceDec()";
    }

    class InlineWalker
    extends DispatchWalker {
        private FormalDec aroundThisFormal = null;
        private Exprs baseArgs;
        private Expr baseThis;
        Exprs aroundMethodArgs = this.getAST().makeExprs();
        private Formals aroundMethodFormals = this.getAST().makeFormals();
        private MethodDec aroundMethodDec;

        Expr makeArgRef(Type type, int index) {
            AST ast = this.getAST();
            return ast.makeVar(AroundAdviceDec.this.getFormals().get(index));
        }

        Expr makeFreeRef(VarDec dec) {
            AST ast = this.getAST();
            FormalDec formal = ast.makeFinalFormal(dec.getType(), dec.getName());
            this.aroundMethodFormals.add(formal);
            this.aroundMethodArgs.add(ast.makeVar(dec));
            return ast.makeVar(formal);
        }

        InlineWalker(JavaCompiler compiler, Stmts stmts, Map proceedMap, Exprs baseArgs, Expr baseThis) {
            super(compiler, proceedMap);
            this.baseArgs = baseArgs;
            this.baseThis = baseThis;
            this.setup(stmts);
        }

        public void setup(Stmts stmts) {
            AST ast = this.getAST();
            this.enclosingCodeDec = stmts.getEnclosingCodeDec();
            Formals formals = AroundAdviceDec.this.getMethodDec().getFormals();
            int i = 0;
            int N = formals.size();
            while (i < N) {
                FormalDec baseFormal = formals.get(i);
                FormalDec formal = ast.makeFormal(baseFormal.getType(), baseFormal.getName(), baseFormal.isFinal());
                this.aroundMethodFormals.add(formal);
                this.aroundMethodArgs.add(this.baseArgs.get(i));
                ++i;
            }
            this.aroundThisFormal = ast.makeFinalFormal(AroundAdviceDec.this.getBytecodeType(), "this_");
            this.aroundMethodFormals.add(this.aroundThisFormal);
            this.aroundMethodArgs.add(this.baseThis);
            this.setupBodyStmts(stmts);
        }

        public MethodDec makeInlineAroundMethod() {
            if (this.aroundMethodDec != null) {
                return this.aroundMethodDec;
            }
            AST ast = this.getAST();
            InlineProceedFixer fixer = new InlineProceedFixer(this.getCompiler());
            Stmts stmts = (Stmts)fixer.process(AroundAdviceDec.this.getBody().getStmts());
            this.aroundMethodDec = ast.makeMethod(ast.makeModifiers(0x10 | (this.enclosingCodeDec.isStatic() ? 8 : 0)), AroundAdviceDec.this.getResultType(), AroundAdviceDec.this.genAroundName(this.enclosingCodeDec), this.aroundMethodFormals, ast.makeBlock(stmts));
            this.enclosingCodeDec.getBytecodeTypeDec().addToBody(this.aroundMethodDec);
            this.aroundMethodDec.setLexicalType(AroundAdviceDec.this.getLexicalType());
            return this.aroundMethodDec;
        }

        public void inlineSoleCallExpr(JoinPoint jp) {
            if (this.soleCallExpr == null || this.hasMultipleCallSites) {
                if (this.hasMultipleCallSites) {
                    jp.showWarning(AroundAdviceDec.this, "couldn't inline sole call expr (multiple calls)");
                }
                return;
            }
            if (!this.soleCallExpr.tryToInline(jp.getBytecodeType())) {
                jp.showWarning(AroundAdviceDec.this, "couldn't inline sole call expr");
            }
        }

        class InlineProceedFixer
        extends CopyWalker {
            public Expr moveThisExpr(ThisExpr thisExpr, Type thisType) {
                return this.getAST().makeVar(InlineWalker.this.aroundThisFormal);
            }

            public InlineProceedFixer(JavaCompiler compiler) {
                super(compiler);
            }

            public ASTObject remapProceed(ProceedExpr proceedExpr) {
                AST ast = this.getAST();
                Exprs args = ast.makeExprs();
                Exprs baseArgs = InlineWalker.this.methodArgs;
                int i = 0;
                int N = baseArgs.size();
                while (i < N) {
                    args.add(this.remap(InlineWalker.this.methodFormals.get(i).getType(), baseArgs.get(i), proceedExpr.getArgs()));
                    ++i;
                }
                Expr thisExpr = this.remap(InlineWalker.this.enclosingCodeDec.getDeclaringType(), InlineWalker.this.makeThisRef(), proceedExpr.getArgs());
                Expr ret = InlineWalker.this.makeDispatchCallExpr(thisExpr, args);
                if (AroundAdviceDec.this.getResultType().isObject()) {
                    ret = ret.getType().makeObject(ret);
                }
                return ret;
            }

            protected Expr handleFreeVar(VarExpr var) {
                VarDec dec = var.getVarDec();
                Formals formals = AroundAdviceDec.this.getMethodDec().getFormals();
                int index = formals.indexOf(dec);
                if (index != -1) {
                    return this.getAST().makeVar(InlineWalker.this.aroundMethodFormals.get(index));
                }
                this.getCompiler().internalError("unbound free: " + var);
                return var;
            }

            private Expr remap(Type expectedType, Expr expr, Exprs proceedArgs) {
                if (expr instanceof VarExpr) {
                    VarDec dec = ((VarExpr)expr).getVarDec();
                    int index = AroundAdviceDec.this.getFormals().indexOf(dec);
                    if (index != -1) {
                        Expr proceedArg = proceedArgs.get(index);
                        return expectedType.fromObject(proceedArg);
                    }
                }
                return (Expr)CopyWalker.copy(expr);
            }

            public ASTObject process(ASTObject object) {
                ASTObject original = object;
                if ((object = super.process(object)) instanceof ProceedExpr) {
                    return this.remapProceed((ProceedExpr)object);
                }
                return object;
            }
        }
    }

    class ClosureWalker
    extends DispatchWalker {
        private Exprs constructorArgs = this.getAST().makeExprs();
        private Formals constructorFormals = this.getAST().makeFormals();
        private List fields = new ArrayList();
        private Stmts fieldInitStmts = this.getAST().makeStmts();
        private FormalDec argsFormal;

        Exprs getConstructorArgs() {
            return this.constructorArgs;
        }

        Formals getConstructorFormals() {
            return this.constructorFormals;
        }

        Stmts getFieldInitStmts() {
            return this.fieldInitStmts;
        }

        List getFields() {
            return this.fields;
        }

        BlockStmt getRunBody() {
            AST ast = this.getAST();
            MethodDec dec = this.makeDispatchMethod();
            Expr thisExpr = this.makeThisRef();
            CallExpr callExpr = ast.makeCall(dec, thisExpr, this.methodArgs);
            Type returnType = this.enclosingCodeDec.getResultType();
            if (returnType.isVoid()) {
                return ast.makeBlock(ast.makeStmt(callExpr), ast.makeReturn(ast.makeNull()));
            }
            return ast.makeBlock(ast.makeReturn(returnType.makeObject(callExpr)));
        }

        Expr makeArgRef(Type type, int index) {
            AST ast = this.getAST();
            return type.fromObject(ast.makeArrayRef(ast.makeVar(this.argsFormal), index));
        }

        Expr makeFreeRef(VarDec dec) {
            return this.getAST().makeGet(this.genField(dec));
        }

        ClosureWalker(JavaCompiler compiler, Stmts stmts, Map proceedMap, FormalDec argsFormal) {
            super(compiler, proceedMap);
            this.argsFormal = argsFormal;
            this.setup(stmts);
        }

        private FieldDec genField(VarDec dec) {
            AST ast = this.getAST();
            Type type = dec.getType();
            String name = dec.getName();
            FieldDec fieldDec = ast.makeField(ast.makeModifiers(2), type, name);
            FormalDec formalDec = ast.makeFinalFormal(type, name);
            Stmt stmt = ast.makeStmt(ast.makeSet(fieldDec, (Expr)ast.makeVar(formalDec)));
            this.constructorArgs.add(ast.makeVar(dec));
            this.fields.add(fieldDec);
            this.constructorFormals.add(formalDec);
            this.fieldInitStmts.add(stmt);
            return fieldDec;
        }
    }

    class ReturnAndThrowFixer
    extends Walker {
        private boolean seenReturn = false;

        public ReturnAndThrowFixer(JavaCompiler compiler) {
            super(compiler);
        }

        public boolean hasSeenReturn() {
            return this.seenReturn;
        }

        public final ASTObject process(ASTObject object) {
            if (object instanceof TypeDec) {
                return object;
            }
            if (object instanceof AnonymousMethodExpr) {
                return object;
            }
            if (object instanceof ReturnStmt) {
                ReturnStmt returnStmt = (ReturnStmt)object;
                this.seenReturn = true;
                if (returnStmt.getExpr() == null) {
                    returnStmt.setExpr(this.getAST().makeNull());
                }
            } else if (object instanceof ThrowStmt) {
                this.seenReturn = true;
            }
            return super.process(object);
        }
    }

    abstract class DispatchWalker
    extends MovingWalker {
        private boolean seenReturn = false;
        private Map varMap = new HashMap();
        protected Exprs methodArgs = this.getAST().makeExprs();
        private Exprs baseMethodArgs = this.getAST().makeExprs();
        protected Formals methodFormals = this.getAST().makeFormals();
        protected MethodDec dispatchMethodDec;
        protected Stmts newBodyStmts;
        private Map proceedMap;
        protected CodeDec enclosingCodeDec;
        CallExpr soleCallExpr = null;
        boolean hasMultipleCallSites = false;

        public final Expr makeDispatchCallExpr(Expr thisExpr, Exprs args) {
            AST ast = this.getAST();
            MethodDec dec = this.makeDispatchMethod();
            CallExpr ret = ast.makeCall(dec, thisExpr, args);
            if (this.soleCallExpr == null && !this.hasMultipleCallSites) {
                this.soleCallExpr = ret;
            } else {
                this.soleCallExpr = null;
                this.hasMultipleCallSites = true;
            }
            return ret;
        }

        public Stmts makeDispatchCall() {
            AST ast = this.getAST();
            Expr thisExpr = this.enclosingCodeDec.isStatic() ? ast.makeTypeExpr(this.enclosingCodeDec.getBytecodeType()) : ast.makeQualifiedThis(this.enclosingCodeDec.getBytecodeType());
            Expr callExpr = this.makeDispatchCallExpr(thisExpr, this.baseMethodArgs);
            Type returnType = this.enclosingCodeDec.getResultType();
            if (returnType.isVoid()) {
                return ast.makeStmts(ast.makeStmt(callExpr));
            }
            return ast.makeStmts(ast.makeReturn(callExpr));
        }

        MethodDec makeDispatchMethod() {
            if (this.dispatchMethodDec != null) {
                return this.dispatchMethodDec;
            }
            AST ast = this.getAST();
            Stmts body = this.newBodyStmts;
            Type returnType = this.enclosingCodeDec.getResultType();
            if (returnType.isVoid()) {
                returnType = this.getTypeManager().getObjectType();
                if (body.size() == 0) {
                    body.add(ast.makeReturn(ast.makeNull()));
                } else if (!(body.get(body.size() - 1) instanceof ReturnStmt) && !(body.get(body.size() - 1) instanceof ThrowStmt)) {
                    body = ast.makeStmts(ast.makeIf(ast.makeLiteral(true), ast.makeBlock(body)), ast.makeReturn(ast.makeNull()));
                }
            }
            this.dispatchMethodDec = ast.makeMethod(ast.makeModifiers(0x10 | (this.enclosingCodeDec.isStatic() ? 8 : 0)), returnType, AroundAdviceDec.this.genDispatchName(this.enclosingCodeDec), this.methodFormals, ast.makeBlock(body));
            this.enclosingCodeDec.getBytecodeTypeDec().addToBody(this.dispatchMethodDec);
            return this.dispatchMethodDec;
        }

        public Expr moveThisExpr(ThisExpr thisExpr, Type thisType) {
            if (thisExpr instanceof QualifiedThisExpr) {
                return thisExpr;
            }
            return this.getAST().makeQualifiedThis(thisExpr.getType());
        }

        protected Expr makeThisRef() {
            if (this.proceedMap.containsKey("this")) {
                return this.makeArgRef(this.enclosingCodeDec.getBytecodeType(), (Integer)this.proceedMap.get("this"));
            }
            AST ast = this.getAST();
            if (this.enclosingCodeDec.isStatic()) {
                return ast.makeTypeExpr(this.enclosingCodeDec.getBytecodeType());
            }
            return ast.makeQualifiedThis(this.enclosingCodeDec.getBytecodeType());
        }

        protected Expr handleFreeVar(VarExpr var) {
            VarDec dec = var.getVarDec();
            FormalDec formal = (FormalDec)this.varMap.get(dec);
            if (formal == null) {
                formal = this.genFormal(dec);
            }
            return this.getAST().makeVar(formal);
        }

        DispatchWalker(JavaCompiler compiler, Map proceedMap) {
            super(compiler);
            this.proceedMap = proceedMap;
        }

        abstract Expr makeArgRef(Type var1, int var2);

        abstract Expr makeFreeRef(VarDec var1);

        private FormalDec genFormal(VarDec dec) {
            AST ast = this.getAST();
            Type type = dec.getType();
            String name = dec.getName();
            FormalDec formalDec = ast.makeFormal(type, name, dec.isFinal());
            Expr e = this.proceedMap.containsKey(dec) ? this.makeArgRef(dec.getType(), (Integer)this.proceedMap.get(dec)) : this.makeFreeRef(dec);
            this.baseMethodArgs.add(ast.makeVar(dec));
            this.methodArgs.add(e);
            this.methodFormals.add(formalDec);
            this.varMap.put(dec, formalDec);
            return formalDec;
        }

        public void setup(Stmts stmts) {
            AST ast = this.getAST();
            this.enclosingCodeDec = stmts.getEnclosingCodeDec();
            this.setupBodyStmts(stmts);
        }

        protected final void setupBodyStmts(Stmts stmts) {
            this.newBodyStmts = (Stmts)this.process(stmts);
            ReturnAndThrowFixer fixer = new ReturnAndThrowFixer(this.getCompiler());
            this.newBodyStmts = (Stmts)fixer.process(stmts);
            this.seenReturn = fixer.hasSeenReturn();
        }
    }

    class ClosureProceedFixer
    extends MovingWalker {
        Stmts stmts;

        public ClosureProceedFixer(JavaCompiler compiler, Stmts stmts) {
            super(compiler);
            this.stmts = stmts;
        }

        public ASTObject remapProceed(CodeDec enclosingCodeDec, ProceedExpr proceedExpr) {
            AST ast = this.getAST();
            Exprs args = ast.makeExprs();
            Exprs proceedArgs = proceedExpr.getArgs();
            int i = 0;
            int len = proceedArgs.size();
            while (i < len) {
                Expr proceedArg = proceedArgs.get(i);
                args.add(proceedArg.getType().makeObject(proceedArg));
                ++i;
            }
            Expr expr = AroundAdviceDec.this.getReturnType().fromObject(ast.makeCall((Expr)ast.makeVar(AroundAdviceDec.this.getExtraFormal()), "run", ast.makeExprs(ast.makeArray(this.getTypeManager().getObjectType(), args))));
            return expr;
        }

        public CodeDec fixCodeDecExceptions(CodeDec codeDec) {
            codeDec = (CodeDec)super.process(codeDec);
            Stmts stmts = codeDec.getBody().getStmts();
            Set excTypes = codeDec.getPossibleCheckedExceptions();
            if (stmts.size() > 0) {
                codeDec.getBody().setStmts(AroundAdviceDec.this.wrapCatchThrowable(stmts, excTypes));
            }
            return codeDec;
        }

        public ASTObject process(ASTObject object) {
            ASTObject original = object;
            if (object instanceof CodeDec) {
                return this.fixCodeDecExceptions((CodeDec)object);
            }
            if ((object = super.process(object)) instanceof ProceedExpr) {
                return this.remapProceed(original.getEnclosingCodeDec(), (ProceedExpr)object);
            }
            return object;
        }
    }
}

