/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.IntroducedDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedSuperDec;
import org.aspectj.compiler.crosscuts.ast.PerClause;
import org.aspectj.compiler.crosscuts.ast.PerSingleton;
import org.aspectj.compiler.crosscuts.ast.PerThisOrTarget;
import org.aspectj.compiler.crosscuts.ast.ShowErrorDec;
import org.aspectj.compiler.crosscuts.ast.SoftThrowableDec;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlannerMaker;

public class AspectDec
extends ClassDec {
    List introductions = new LinkedList();
    private Map extraPlanners = new HashMap();
    protected List myJpPlannerMakers = null;
    protected GenTypeName dominates;
    protected PerClause perClause;

    public String getKind() {
        return "aspect";
    }

    public Type getSuperClassType() {
        return super.getSuperClassType();
    }

    public PerClause findPerClause() {
        return this.getPerClause();
    }

    public AspectDec getParentAspect() {
        Type superType = this.getSuperClassType();
        if (superType.isAspect()) {
            return (AspectDec)((NameType)superType).getTypeDec();
        }
        return null;
    }

    public void checkSpec() {
        super.checkSpec();
        if (this.getType().isSubtypeOf(this.getTypeManager().getSerializableType()) && !this.getOptions().XserializableAspects) {
            this.showError("aspects may not implement java.io.Serializable");
        }
        if (this.getType().isSubtypeOf(this.getTypeManager().getCloneableType())) {
            this.showError("aspects may not implement java.lang.Cloneable");
        }
        if (this.isInnerType() && !this.isStatic()) {
            this.showError("inner aspects must be static");
        }
    }

    protected boolean explicitDominates(AspectDec otherAspect) {
        if (this.dominates == null) {
            if (this.getParentAspect() != null) {
                return this.getParentAspect().explicitDominates(otherAspect);
            }
            return false;
        }
        return this.dominates.matches(otherAspect.getType());
    }

    public boolean dominates(AspectDec otherAspect) {
        if (otherAspect == this) {
            return false;
        }
        if (this.explicitDominates(otherAspect)) {
            return true;
        }
        if (otherAspect.explicitDominates(this)) {
            return false;
        }
        return this.getType().isStrictSubtypeOf(otherAspect.getType());
    }

    public boolean hasAdvicesOrIntroductions() {
        return true;
    }

    protected void maybeShowWarning(Dec dec) {
    }

    public List getIntroductions() {
        return this.introductions;
    }

    public void addDec(Dec dec) {
        if (dec instanceof AdviceDec) {
            return;
        }
        if (dec instanceof IntroducedDec) {
            this.introductions.add(dec);
        } else {
            if (dec instanceof ShowErrorDec) {
                return;
            }
            if (dec instanceof SoftThrowableDec) {
                return;
            }
            if (dec instanceof IntroducedSuperDec) {
                this.introductions.add(dec);
            } else {
                super.addDec(dec);
            }
        }
    }

    public void postIntroductionFinish() {
        super.postIntroductionFinish();
        if (this.perClause == null) {
            if (this.getParentAspect() == null) {
                this.setPerClause(new PerSingleton(this.getSourceLocation()));
            } else {
                this.setPerClause((PerClause)this.getParentAspect().getPerClause().copy());
            }
        }
        if (this.getParentAspect() != null && !this.getParentAspect().isAbstract()) {
            this.superClass.showError("can only extend abstract aspects, not " + this.getParentAspect().getType().getString());
            return;
        }
        if (!this.isAbstract()) {
            this.getPerClause().setupAspect();
        }
    }

    public Map getExtraPlanners() {
        return this.extraPlanners;
    }

    protected void walkExtendsAndImplements(ScopeWalker walker) {
        if (this.perClause instanceof PerThisOrTarget) {
            this.getModifiers().setPublic(true);
        }
        if (this.dominates != null) {
            walker.process(this.dominates);
        }
        super.walkExtendsAndImplements(walker);
    }

    protected void walkBody(ScopeWalker walker) {
        if (this.perClause != null) {
            walker.process(this.perClause);
        }
        super.walkBody(walker);
    }

    public void addConstructorDec(ConstructorDec constructorDec) {
        if (constructorDec.getFormals().size() != 0) {
            constructorDec.showError("only 0-argument constructors allowed in an aspect");
            return;
        }
        super.addConstructorDec(constructorDec);
    }

    public List getJpPlannerMakers() {
        if (this.myJpPlannerMakers != null) {
            return this.myJpPlannerMakers;
        }
        LinkedList<Dec> ret = new LinkedList<Dec>();
        int N = this.getBody().size();
        int i = 0;
        while (i < N) {
            Dec dec = this.getBody().get(i);
            if (dec instanceof JpPlannerMaker) {
                ret.add(dec);
            }
            ++i;
        }
        AspectDec parentAspect = this.getParentAspect();
        if (parentAspect != null) {
            if (!parentAspect.isAbstract()) {
                this.showError("only abstract aspects can be extended, " + parentAspect.toShortString() + " is not abstract");
            }
            ret.addAll(parentAspect.getJpPlannerMakers());
        }
        this.myJpPlannerMakers = ret;
        return ret;
    }

    public boolean isInner() {
        return false;
    }

    public GenTypeName getDominates() {
        return this.dominates;
    }

    public void setDominates(GenTypeName _dominates) {
        if (_dominates != null) {
            _dominates.setParent(this);
        }
        this.dominates = _dominates;
    }

    public PerClause getPerClause() {
        return this.perClause;
    }

    public void setPerClause(PerClause _perClause) {
        if (_perClause != null) {
            _perClause.setParent(this);
        }
        this.perClause = _perClause;
    }

    public AspectDec(SourceLocation location, Modifiers _modifiers, String _id, TypeD _superClass, TypeDs _superInterfaces, GenTypeName _dominates, PerClause _perClause, Decs _body) {
        super(location, _modifiers, _id, _superClass, _superInterfaces, _body);
        this.setDominates(_dominates);
        this.setPerClause(_perClause);
    }

    protected AspectDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        AspectDec ret = new AspectDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        ret.id = this.id;
        if (this.superClass != null) {
            ret.setSuperClass((TypeD)walker.process(this.superClass));
        }
        if (this.superInterfaces != null) {
            ret.setSuperInterfaces((TypeDs)walker.process(this.superInterfaces));
        }
        if (this.dominates != null) {
            ret.setDominates((GenTypeName)walker.process(this.dominates));
        }
        if (this.perClause != null) {
            ret.setPerClause((PerClause)walker.process(this.perClause));
        }
        if (this.body != null) {
            ret.setBody((Decs)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.superClass;
            }
            case 2: {
                return this.superInterfaces;
            }
            case 3: {
                return this.dominates;
            }
            case 4: {
                return this.perClause;
            }
            case 5: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "superClass";
            }
            case 2: {
                return "superInterfaces";
            }
            case 3: {
                return "dominates";
            }
            case 4: {
                return "perClause";
            }
            case 5: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setSuperClass((TypeD)child);
                return;
            }
            case 2: {
                this.setSuperInterfaces((TypeDs)child);
                return;
            }
            case 3: {
                this.setDominates((GenTypeName)child);
                return;
            }
            case 4: {
                this.setPerClause((PerClause)child);
                return;
            }
            case 5: {
                this.setBody((Decs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 6;
    }

    public String getDefaultDisplayName() {
        return "AspectDec(id: " + this.id + ")";
    }
}

