/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.CodePattern;
import org.aspectj.compiler.crosscuts.ast.FormalsPattern;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.NameTypeDsPattern;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.util.FuzzyBoolean;

public class ConstructorPattern
extends CodePattern {
    protected FormalsPattern formalsPattern;
    protected NameTypeDsPattern throwsPattern;

    public String toShortString() {
        String mods = this.modifiers.toShortString();
        if (mods.length() > 0) {
            mods = mods + " ";
        }
        mods = mods + this.makeDeclaringTypeString() + "new" + this.formalsPattern.toShortString();
        if (this.throwsPattern != null) {
            mods = mods + " throws ...";
        }
        return mods;
    }

    public String getLookupId() {
        return "new";
    }

    protected boolean isStaticMatch(SemanticObject so) {
        return true;
    }

    public FuzzyBoolean matches(JoinPoint jp) {
        if (!(jp.getTargetSO() instanceof Constructor)) {
            return FuzzyBoolean.NO;
        }
        Constructor m = (Constructor)jp.getTargetSO();
        if (!this.formalsPattern.matches(m.getFormals())) {
            return FuzzyBoolean.NO;
        }
        if (this.throwsPattern != null && !this.throwsPattern.matches(m.getThrows())) {
            return FuzzyBoolean.NO;
        }
        return super.matches(jp);
    }

    public FormalsPattern getFormalsPattern() {
        return this.formalsPattern;
    }

    public void setFormalsPattern(FormalsPattern _formalsPattern) {
        if (_formalsPattern != null) {
            _formalsPattern.setParent(this);
        }
        this.formalsPattern = _formalsPattern;
    }

    public NameTypeDsPattern getThrowsPattern() {
        return this.throwsPattern;
    }

    public void setThrowsPattern(NameTypeDsPattern _throwsPattern) {
        if (_throwsPattern != null) {
            _throwsPattern.setParent(this);
        }
        this.throwsPattern = _throwsPattern;
    }

    public ConstructorPattern(SourceLocation location, Modifiers _modifiers, GenTypeName _declaringTypeName, FormalsPattern _formalsPattern, NameTypeDsPattern _throwsPattern) {
        super(location, _modifiers, _declaringTypeName);
        this.setFormalsPattern(_formalsPattern);
        this.setThrowsPattern(_throwsPattern);
    }

    protected ConstructorPattern(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ConstructorPattern ret = new ConstructorPattern(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.declaringTypeName != null) {
            ret.setDeclaringTypeName((GenTypeName)walker.process(this.declaringTypeName));
        }
        if (this.formalsPattern != null) {
            ret.setFormalsPattern((FormalsPattern)walker.process(this.formalsPattern));
        }
        if (this.throwsPattern != null) {
            ret.setThrowsPattern((NameTypeDsPattern)walker.process(this.throwsPattern));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 2: {
                return this.formalsPattern;
            }
            case 3: {
                return this.throwsPattern;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 2: {
                return "formalsPattern";
            }
            case 3: {
                return "throwsPattern";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 2: {
                this.setFormalsPattern((FormalsPattern)child);
                return;
            }
            case 3: {
                this.setThrowsPattern((NameTypeDsPattern)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 4;
    }

    public String getDefaultDisplayName() {
        return "ConstructorPattern()";
    }
}

