/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Iterator;
import java.util.LinkedList;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.EllipsesFakeTypeName;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.GenTypeNames;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;

public class FormalsPattern
extends ASTObject {
    protected GenTypeNames names;

    private boolean isEllipses(GenTypeName name) {
        return name instanceof EllipsesFakeTypeName;
    }

    public JpPlan finishPlan(JpPlan plan, ASTObject nodes, JoinPoint point, int namesIndex, int formalsIndex) {
        if (namesIndex >= this.names.size()) {
            if (formalsIndex >= nodes.getChildCount()) {
                return plan;
            }
            return JpPlan.NO_PLAN;
        }
        GenTypeName name = this.names.get(namesIndex);
        if (this.isEllipses(name)) {
            LinkedList<JpPlan> plans = new LinkedList<JpPlan>();
            while (formalsIndex <= nodes.getChildCount()) {
                JpPlan tmp = this.finishPlan(plan, nodes, point, namesIndex + 1, formalsIndex);
                if (tmp.isPossible()) {
                    plans.add(tmp);
                }
                ++formalsIndex;
            }
            JpPlan ret = JpPlan.NO_PLAN;
            Iterator i = plans.iterator();
            while (i.hasNext()) {
                JpPlan p = (JpPlan)i.next();
                ret = ret.or(p);
            }
            return ret;
        }
        if (formalsIndex >= nodes.getChildCount()) {
            return JpPlan.NO_PLAN;
        }
        JpPlan paramPlan = name.makePlan(point, (Expr)nodes.getChildAt(formalsIndex));
        if (paramPlan.isPossible()) {
            JpPlan nextPlan = this.finishPlan(plan, nodes, point, namesIndex + 1, formalsIndex + 1);
            return nextPlan.and(paramPlan);
        }
        return JpPlan.NO_PLAN;
    }

    public JpPlan finishPlan(JpPlan plan, Exprs exprs, JoinPoint point) {
        return this.finishPlan(plan, exprs, point, 0, 0);
    }

    public JpPlan makePlan(Exprs exprs, JoinPoint jp) {
        return this.finishPlan(JpPlan.ANY_PLAN, exprs, jp);
    }

    public boolean matches(Formals formals) {
        return this.matches(formals, 0, 0);
    }

    public Type extractType(ASTObject node) {
        if (node instanceof FormalDec) {
            return ((FormalDec)node).getType();
        }
        if (node instanceof Expr) {
            return ((Expr)node).getType();
        }
        return null;
    }

    public boolean matches(ASTObject nodes, int namesIndex, int formalsIndex) {
        if (namesIndex >= this.names.size()) {
            return formalsIndex >= nodes.getChildCount();
        }
        GenTypeName name = this.names.get(namesIndex);
        if (this.isEllipses(name)) {
            while (formalsIndex <= nodes.getChildCount()) {
                if (this.matches(nodes, namesIndex + 1, formalsIndex)) {
                    return true;
                }
                ++formalsIndex;
            }
            return false;
        }
        if (formalsIndex >= nodes.getChildCount()) {
            return false;
        }
        if (name.matches(this.extractType(nodes.getChildAt(formalsIndex)))) {
            return this.matches(nodes, namesIndex + 1, formalsIndex + 1);
        }
        return false;
    }

    public String toShortString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int N = this.names.size();
        int i = 0;
        while (i <= N) {
            if (i < N) {
                buf.append(this.names.get(i).toShortString());
            }
            if (i < N - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public GenTypeNames getNames() {
        return this.names;
    }

    public void setNames(GenTypeNames _names) {
        if (_names != null) {
            _names.setParent(this);
        }
        this.names = _names;
    }

    public FormalsPattern(SourceLocation location, GenTypeNames _names) {
        super(location);
        this.setNames(_names);
    }

    protected FormalsPattern(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        FormalsPattern ret = new FormalsPattern(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.names != null) {
            ret.setNames((GenTypeNames)walker.process(this.names));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.names;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "names";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setNames((GenTypeNames)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "FormalsPattern()";
    }
}

