/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.LinkedList;
import java.util.List;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.bcg.ClassfileBuilder;
import org.aspectj.compiler.base.cst.Scope;
import org.aspectj.compiler.crosscuts.AspectJCompiler;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.joinpoints.TypeDecPlanner;

public class IntroducedDec
extends Dec
implements TypeDecPlanner {
    private List introducedDecs = new LinkedList();
    Scope myLexicalScope = null;
    protected GenTypeName targets;
    protected Dec dec;

    public Modifiers getModifiers() {
        return this.dec.getModifiers();
    }

    public void walkScope(ScopeWalker walker) {
        walker.process(this.targets);
        boolean saveWalkBodies = walker.walkBodies();
        walker.setWalkBodies(false);
        walker.process(this.dec);
        walker.setWalkBodies(saveWalkBodies);
        this.myLexicalScope = walker.getScope();
        this.dec.setParent(this);
        this.getWorld().addTypeDecPlanner(this);
    }

    public boolean isStatic() {
        return true;
    }

    public String getUniqueIdString(Type onType) {
        String ret = null;
        if (this.isPrivate()) {
            ret = this.getLexicalType().getPrivateCookieType().getPrettyString();
        } else if (this.isProtected()) {
            this.showError("protected introduction not allowed");
            ret = "";
        } else {
            ret = this.isPublic() ? "" : this.getLexicalType().getPackageName();
        }
        if (onType.isInterface() && this.dec instanceof FieldDec) {
            ret = ret + "_" + onType.getPrettyString();
        }
        return ret;
    }

    public void plan(TypeDec typeDec, int phase) {
        if (phase != 2) {
            return;
        }
        Type toType = typeDec.getType();
        if (!this.getTargets().matches(toType)) {
            return;
        }
        Dec newDec = (Dec)CopyWalker.rawCopy(this.dec, toType);
        newDec.setSourceLocation(this.getAST().getSourceLocation());
        newDec.setLanguageVisible();
        if (this.isPublic()) {
            newDec.setExplicitlyNonSynthetic();
        }
        newDec.setDeclaringType(toType);
        newDec.setLexicalType(this.getLexicalType());
        newDec.setFromLexicalScope(this.myLexicalScope);
        if (!this.isPublic() || newDec instanceof FieldDec && typeDec instanceof InterfaceDec) {
            String newId = this.getAST().makeGeneratedName(newDec.getBytecodeId() + '_' + this.getUniqueIdString(typeDec.getType()));
            newDec.setBytecodeId(newId);
        }
        typeDec.addIntroducedDec(newDec);
        typeDec.addExtraWithinType(this.getLexicalType());
        ((AspectJCompiler)this.getCompiler()).getCorrespondences().addPointsTo(this, typeDec);
        this.getCompiler().showMessage("    introduced " + newDec.toShortString() + " on " + typeDec.getType().toShortString());
    }

    public String getKind() {
        return "introduction";
    }

    public String getId() {
        return this.dec.getId();
    }

    public String toShortString() {
        return this.targets.toShortString() + "." + this.dec.getId();
    }

    protected void cgMember(ClassfileBuilder maker) {
    }

    public GenTypeName getTargets() {
        return this.targets;
    }

    public void setTargets(GenTypeName _targets) {
        if (_targets != null) {
            _targets.setParent(this);
        }
        this.targets = _targets;
    }

    public Dec getDec() {
        return this.dec;
    }

    public void setDec(Dec _dec) {
        this.dec = _dec;
    }

    public IntroducedDec(SourceLocation location, GenTypeName _targets, Dec _dec) {
        super(location);
        this.setTargets(_targets);
        this.setDec(_dec);
    }

    protected IntroducedDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        IntroducedDec ret = new IntroducedDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.targets != null) {
            ret.setTargets((GenTypeName)walker.process(this.targets));
        }
        ret.dec = this.dec;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.targets;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "targets";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTargets((GenTypeName)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "IntroducedDec(dec: " + this.dec + ")";
    }
}

