/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.crosscuts.AspectJCompiler;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.joinpoints.TypeDecPlanner;

public class IntroducedSuperDec
extends Dec
implements TypeDecPlanner {
    protected GenTypeName targets;
    protected TypeDs typeDs;
    protected boolean isImplements;

    public Modifiers getModifiers() {
        return this.getAST().makeModifiers(0);
    }

    public void walkScope(ScopeWalker walker) {
        super.walkScope(walker);
        this.getWorld().addTypeDecPlanner(this);
    }

    protected void addSuperType(Type toType, Type newSuperType) {
        if (toType.isSubtypeOf(newSuperType)) {
            return;
        }
        if (toType.isInterface()) {
            this.addSuperTypeToInterfaceDec((InterfaceDec)toType.getTypeDec(), newSuperType);
        } else if (toType.isClass()) {
            this.addSuperTypeToClassDec((ClassDec)toType.getTypeDec(), newSuperType);
        } else {
            this.showWarning("can't apply to a " + toType.getTypeDec().getClass().getName());
        }
    }

    boolean checkExistingSubtypes(Type thisType, Type newSuperType) {
        if (thisType.isSubtypeOf(newSuperType)) {
            return true;
        }
        if (newSuperType.isSubtypeOf(thisType)) {
            this.showError("circular inheritance: " + newSuperType.toShortString() + " is a subtype of " + thisType.toShortString());
            return true;
        }
        return false;
    }

    protected void addSuperTypeToInterfaceDec(InterfaceDec typeDec, Type newSuperType) {
        if (!newSuperType.isInterface()) {
            this.showError("interface can't extend a class");
            return;
        }
        if (this.checkExistingSubtypes(typeDec.getType(), newSuperType)) {
            return;
        }
        typeDec.addSuperInterfaceType(newSuperType);
        typeDec.getType().addDirectSuperType(newSuperType);
    }

    protected void addSuperTypeToClassDec(ClassDec typeDec, Type newSuperType) {
        if (this.checkExistingSubtypes(typeDec.getType(), newSuperType)) {
            return;
        }
        if (newSuperType.isInterface()) {
            typeDec.addSuperInterfaceType(newSuperType);
            typeDec.getType().addDirectSuperType(newSuperType);
        } else if (newSuperType.isClass()) {
            Type oldParent = typeDec.getSuperClassType();
            if (oldParent == null) {
                return;
            }
            if (newSuperType.isSubtypeOf(oldParent)) {
                typeDec.setSuperClass(newSuperType.makeTypeD());
                typeDec.getType().addDirectSuperType(newSuperType);
            } else {
                this.showError("introduced superclass must extend old superclass: " + oldParent.getPrettyString());
            }
        } else {
            this.showError("classes can't extend " + newSuperType.getTypeDec().getClass().getName());
        }
    }

    public void plan(TypeDec typeDec, int phase) {
        if (phase != 1) {
            return;
        }
        if (!this.getTargets().matches(typeDec.getType())) {
            return;
        }
        int N = this.typeDs.size();
        int i = 0;
        while (i < N) {
            TypeD name = this.typeDs.get(i);
            this.getCompiler().showMessage("    introducing " + name.toShortString() + " on " + typeDec.toShortString());
            this.addSuperType(typeDec.getType(), name.getType());
            ++i;
        }
        ((AspectJCompiler)this.getCompiler()).getCorrespondences().addPointsTo(this, typeDec);
    }

    public String getKind() {
        return "declare parents";
    }

    public String getId() {
        return this.targets.toShortString();
    }

    public String toShortString() {
        return "declare parents: " + this.targets.toShortString();
    }

    public GenTypeName getTargets() {
        return this.targets;
    }

    public void setTargets(GenTypeName _targets) {
        if (_targets != null) {
            _targets.setParent(this);
        }
        this.targets = _targets;
    }

    public TypeDs getTypeDs() {
        return this.typeDs;
    }

    public void setTypeDs(TypeDs _typeDs) {
        if (_typeDs != null) {
            _typeDs.setParent(this);
        }
        this.typeDs = _typeDs;
    }

    public boolean getIsImplements() {
        return this.isImplements;
    }

    public void setIsImplements(boolean _isImplements) {
        this.isImplements = _isImplements;
    }

    public IntroducedSuperDec(SourceLocation location, GenTypeName _targets, TypeDs _typeDs, boolean _isImplements) {
        super(location);
        this.setTargets(_targets);
        this.setTypeDs(_typeDs);
        this.setIsImplements(_isImplements);
    }

    protected IntroducedSuperDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        IntroducedSuperDec ret = new IntroducedSuperDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.targets != null) {
            ret.setTargets((GenTypeName)walker.process(this.targets));
        }
        if (this.typeDs != null) {
            ret.setTypeDs((TypeDs)walker.process(this.typeDs));
        }
        ret.isImplements = this.isImplements;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.targets;
            }
            case 1: {
                return this.typeDs;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "targets";
            }
            case 1: {
                return "typeDs";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTargets((GenTypeName)child);
                return;
            }
            case 1: {
                this.setTypeDs((TypeDs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "IntroducedSuperDec(isImplements: " + this.isImplements + ")";
    }
}

