/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.DecPattern;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.util.FuzzyBoolean;

public abstract class KindedPcd
extends Pcd {
    protected DecPattern pattern;

    public void checkStatic() {
    }

    public String toShortString() {
        return this.getKind() + "(" + this.getPattern().toShortString() + ")";
    }

    public abstract String getKind();

    public abstract int getJpKind();

    public JpPlanner makePlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                if (jp.getTypeCode() != KindedPcd.this.getJpKind()) {
                    return FuzzyBoolean.NO;
                }
                return KindedPcd.this.getPattern().matches(jp);
            }
        };
    }

    public DecPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(DecPattern _pattern) {
        if (_pattern != null) {
            _pattern.setParent(this);
        }
        this.pattern = _pattern;
    }

    public KindedPcd(SourceLocation location, DecPattern _pattern) {
        super(location);
        this.setPattern(_pattern);
    }

    protected KindedPcd(SourceLocation source) {
        super(source);
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.pattern;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "pattern";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setPattern((DecPattern)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "KindedPcd()";
    }
}

