/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.CodePattern;
import org.aspectj.compiler.crosscuts.ast.FormalsPattern;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.NamePattern;
import org.aspectj.compiler.crosscuts.ast.NameTypeDsPattern;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.util.FuzzyBoolean;

public class MethodPattern
extends CodePattern {
    protected GenTypeName returnTypeName;
    protected NamePattern id;
    protected FormalsPattern formalsPattern;
    protected NameTypeDsPattern throwsPattern;

    public String toShortString() {
        String mods = this.modifiers.toShortString();
        if (mods.length() > 0) {
            mods = mods + " ";
        }
        mods = mods + this.returnTypeName.toShortString() + " ";
        String ret = mods + this.makeDeclaringTypeString() + this.id.toShortString() + this.formalsPattern.toShortString();
        if (this.throwsPattern != null) {
            ret = ret + " throws ...";
        }
        return ret;
    }

    public void checkSpec() {
        if (this.id.getSimpleName() != null && this.id.getSimpleName().equals("new")) {
            this.showError("constructor patterns don't have a return type");
        }
    }

    public String getLookupId() {
        return this.id.getLookupString();
    }

    public FuzzyBoolean matches(JoinPoint jp) {
        if (!(jp.getTargetSO() instanceof Method)) {
            return FuzzyBoolean.NO;
        }
        Method m = (Method)jp.getTargetSO();
        if (!this.id.matches(m.getName())) {
            return FuzzyBoolean.NO;
        }
        if (!this.returnTypeName.matches(m.getReturnType())) {
            return FuzzyBoolean.NO;
        }
        if (!this.formalsPattern.matches(m.getFormals())) {
            return FuzzyBoolean.NO;
        }
        if (this.throwsPattern != null && !this.throwsPattern.matches(m.getThrows())) {
            return FuzzyBoolean.NO;
        }
        return super.matches(jp);
    }

    public GenTypeName getReturnTypeName() {
        return this.returnTypeName;
    }

    public void setReturnTypeName(GenTypeName _returnTypeName) {
        if (_returnTypeName != null) {
            _returnTypeName.setParent(this);
        }
        this.returnTypeName = _returnTypeName;
    }

    public NamePattern getId() {
        return this.id;
    }

    public void setId(NamePattern _id) {
        this.id = _id;
    }

    public FormalsPattern getFormalsPattern() {
        return this.formalsPattern;
    }

    public void setFormalsPattern(FormalsPattern _formalsPattern) {
        if (_formalsPattern != null) {
            _formalsPattern.setParent(this);
        }
        this.formalsPattern = _formalsPattern;
    }

    public NameTypeDsPattern getThrowsPattern() {
        return this.throwsPattern;
    }

    public void setThrowsPattern(NameTypeDsPattern _throwsPattern) {
        if (_throwsPattern != null) {
            _throwsPattern.setParent(this);
        }
        this.throwsPattern = _throwsPattern;
    }

    public MethodPattern(SourceLocation location, Modifiers _modifiers, GenTypeName _declaringTypeName, GenTypeName _returnTypeName, NamePattern _id, FormalsPattern _formalsPattern, NameTypeDsPattern _throwsPattern) {
        super(location, _modifiers, _declaringTypeName);
        this.setReturnTypeName(_returnTypeName);
        this.setId(_id);
        this.setFormalsPattern(_formalsPattern);
        this.setThrowsPattern(_throwsPattern);
    }

    protected MethodPattern(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        MethodPattern ret = new MethodPattern(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.declaringTypeName != null) {
            ret.setDeclaringTypeName((GenTypeName)walker.process(this.declaringTypeName));
        }
        if (this.returnTypeName != null) {
            ret.setReturnTypeName((GenTypeName)walker.process(this.returnTypeName));
        }
        ret.id = this.id;
        if (this.formalsPattern != null) {
            ret.setFormalsPattern((FormalsPattern)walker.process(this.formalsPattern));
        }
        if (this.throwsPattern != null) {
            ret.setThrowsPattern((NameTypeDsPattern)walker.process(this.throwsPattern));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 2: {
                return this.returnTypeName;
            }
            case 3: {
                return this.formalsPattern;
            }
            case 4: {
                return this.throwsPattern;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 2: {
                return "returnTypeName";
            }
            case 3: {
                return "formalsPattern";
            }
            case 4: {
                return "throwsPattern";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 2: {
                this.setReturnTypeName((GenTypeName)child);
                return;
            }
            case 3: {
                this.setFormalsPattern((FormalsPattern)child);
                return;
            }
            case 4: {
                this.setThrowsPattern((NameTypeDsPattern)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 5;
    }

    public String getDefaultDisplayName() {
        return "MethodPattern(id: " + this.id + ")";
    }
}

