/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.crosscuts.AspectJCompiler;
import org.aspectj.compiler.crosscuts.ast.FormalsPattern;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.GenTypeNames;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;
import org.aspectj.compiler.crosscuts.ast.PointcutSO;
import org.aspectj.compiler.crosscuts.ast.VarTypeName;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.WrappedJpPlanner;

public class NamePcd
extends Pcd {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new TreeMap());
    protected TypeD parentName;
    protected String id;
    protected FormalsPattern formals;
    protected PointcutSO pointcut;

    public String toShortString() {
        String ret = this.id + this.formals.toShortString();
        if (this.parentName != null) {
            ret = this.parentName.toShortString() + '.' + ret;
        }
        return ret;
    }

    public void checkStatic() {
        this.getPointcut().getPcd().checkStatic();
    }

    public PointcutDec getPointcutDec() {
        return this.getPointcut().getPointcutDec();
    }

    public boolean allowsNameBinding() {
        return true;
    }

    public JpPlanner makePlanner(PlanData planData) {
        if (planData.isPlanning(this)) {
            this.showError("recursive pointcut reference not allowed");
            return JpPlanner.NO_PLANNER;
        }
        PointcutSO innerPointcut = this.concretizePointcut(planData.getNameBindingType());
        if (innerPointcut.isAbstract()) {
            planData.getPlanMaker().showError("references an abstract pointcut -- see below");
            innerPointcut.getCorrespondingDec().showError("can't use abstract pointcut where concrete is required");
        }
        JpPlanner planner = innerPointcut.getPcd().makePlanner(planData.makeInner(this));
        final Map remapFormals = this.makeFormalsRemap(innerPointcut);
        return new WrappedJpPlanner(planner){

            public JpPlan makePlan(JoinPoint jp) {
                JpPlan plan = super.makePlan(jp);
                if (plan == JpPlan.NEVER_PLAN || plan == JpPlan.NO_PLAN) {
                    return plan;
                }
                plan.moveBindings(remapFormals);
                return plan;
            }
        };
    }

    Map makeFormalsRemap(PointcutSO pointcut) {
        GenTypeNames params = this.getFormals().getNames();
        Formals decFormals = pointcut.getFormals();
        int N = params.size();
        if (decFormals.size() != N) {
            this.getFormals().showError("arguments don't match pointcut signature: " + pointcut.getFormals().toShortString());
            return EMPTY_MAP;
        }
        HashMap<FormalDec, FormalDec> remap = new HashMap<FormalDec, FormalDec>();
        int i = 0;
        while (i < N) {
            FormalDec formal = decFormals.get(i);
            GenTypeName param = params.get(i);
            if (param.matchesInstance(formal.getType()).maybeFalse()) {
                param.showError("doesn't match " + formal.getType().getString());
                break;
            }
            if (param instanceof VarTypeName) {
                FormalDec paramFormal = ((VarTypeName)param).getFormalDec();
                remap.put(formal, paramFormal);
            }
            ++i;
        }
        return remap;
    }

    public ASTObject postScope(ScopeWalker walker) {
        if (!walker.walkBodies()) {
            return this;
        }
        if (this.pointcut != null) {
            return this;
        }
        this.bindPointcut();
        return super.postScope(walker);
    }

    /*
     * Unable to fully structure code
     */
    private PointcutSO findPointcut() {
        if (this.isStaticReference()) {
            ret = this.parentName.getType().getPointcut(this.id, this, true);
            if (ret.isAbstract()) {
                this.showError("can't reference abstract pointcut using static qualified name: " + ret.toShortString());
            }
            return ret;
        }
        inType = this.getLexicalType();
        ret = inType.getPointcut(this.id, this, false);
        if (ret == null) ** GOTO lbl14
        return ret;
lbl-1000:
        // 1 sources

        {
            if ((inType = inType.getDeclaringType()) == null || inType == this.getTypeManager().TYPE_NOT_FOUND) {
                this.showError("named pointcut not found: " + this.toShortString());
                return ret;
            }
            ret = inType.getPointcut(this.id, this, false);
lbl14:
            // 2 sources

            ** while (ret == null)
        }
lbl15:
        // 1 sources

        this.setParentName(inType.makeTypeD());
        if (ret.isAbstract()) {
            this.showError("can't reference abstract pointcut using static qualified name: " + ret.toShortString());
        }
        return ret;
    }

    private boolean isStaticReference() {
        return this.parentName != null;
    }

    private void bindPointcut() {
        this.pointcut = this.findPointcut();
        ((AspectJCompiler)this.getCompiler()).getCorrespondences().addPointsTo(this.findNonPcd(this.getParent()), this.pointcut.getPointcutDec());
    }

    private ASTObject findNonPcd(ASTObject node) {
        if (!(node instanceof Pcd)) {
            return node;
        }
        return this.findNonPcd(node.getParent());
    }

    public PointcutSO concretizePointcut(Type inType) {
        if (this.pointcut == null) {
            return null;
        }
        if (inType == null || this.isStaticReference()) {
            return this.pointcut;
        }
        PointcutSO ret = this.pointcut;
        while (inType != ret.getDeclaringType()) {
            if (!ret.getModifiers().isPrivate() && ret.isAccessible(inType.getTypeDec().getBody())) {
                ret = inType.getPointcut(this.id, inType.getTypeDec().getBody(), true);
                break;
            }
            inType = inType.getTypeDec().getSuperClassType();
        }
        return ret;
    }

    public TypeD getParentName() {
        return this.parentName;
    }

    public void setParentName(TypeD _parentName) {
        if (_parentName != null) {
            _parentName.setParent(this);
        }
        this.parentName = _parentName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public FormalsPattern getFormals() {
        return this.formals;
    }

    public void setFormals(FormalsPattern _formals) {
        if (_formals != null) {
            _formals.setParent(this);
        }
        this.formals = _formals;
    }

    public PointcutSO getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(PointcutSO _pointcut) {
        this.pointcut = _pointcut;
    }

    public NamePcd(SourceLocation location, TypeD _parentName, String _id, FormalsPattern _formals, PointcutSO _pointcut) {
        super(location);
        this.setParentName(_parentName);
        this.setId(_id);
        this.setFormals(_formals);
        this.setPointcut(_pointcut);
    }

    protected NamePcd(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NamePcd ret = new NamePcd(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.parentName != null) {
            ret.setParentName((TypeD)walker.process(this.parentName));
        }
        ret.id = this.id;
        if (this.formals != null) {
            ret.setFormals((FormalsPattern)walker.process(this.formals));
        }
        ret.pointcut = this.pointcut;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.parentName;
            }
            case 1: {
                return this.formals;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "parentName";
            }
            case 1: {
                return "formals";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setParentName((TypeD)child);
                return;
            }
            case 1: {
                this.setFormals((FormalsPattern)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "NamePcd(id: " + this.id + ", " + "pointcut: " + this.pointcut + ")";
    }
}

