/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.TypeDs;

public class NameTypeDsPattern
extends ASTObject {
    protected TypeDs trueNames;
    protected TypeDs falseNames;

    public boolean matches(TypeDs otherNames) {
        if (otherNames == null) {
            return this.trueNames.size() == 0;
        }
        int N1 = this.trueNames.size();
        int i = 0;
        while (i < N1) {
            if (!otherNames.contains(this.trueNames.get(i))) {
                return false;
            }
            ++i;
        }
        int N2 = this.falseNames.size();
        i = 0;
        while (i < N2) {
            if (otherNames.contains(this.falseNames.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TypeDs getTrueNames() {
        return this.trueNames;
    }

    public void setTrueNames(TypeDs _trueNames) {
        if (_trueNames != null) {
            _trueNames.setParent(this);
        }
        this.trueNames = _trueNames;
    }

    public TypeDs getFalseNames() {
        return this.falseNames;
    }

    public void setFalseNames(TypeDs _falseNames) {
        if (_falseNames != null) {
            _falseNames.setParent(this);
        }
        this.falseNames = _falseNames;
    }

    public NameTypeDsPattern(SourceLocation location, TypeDs _trueNames, TypeDs _falseNames) {
        super(location);
        this.setTrueNames(_trueNames);
        this.setFalseNames(_falseNames);
    }

    protected NameTypeDsPattern(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NameTypeDsPattern ret = new NameTypeDsPattern(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.trueNames != null) {
            ret.setTrueNames((TypeDs)walker.process(this.trueNames));
        }
        if (this.falseNames != null) {
            ret.setFalseNames((TypeDs)walker.process(this.falseNames));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.trueNames;
            }
            case 1: {
                return this.falseNames;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "trueNames";
            }
            case 1: {
                return "falseNames";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTrueNames((TypeDs)child);
                return;
            }
            case 1: {
                this.setFalseNames((TypeDs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "NameTypeDsPattern()";
    }
}

