/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.crosscuts.ast.EmptyPcd;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.ast.PointcutSO;

public class PointcutDec
extends Dec {
    protected Modifiers modifiers;
    protected String id;
    protected TypeD resultTypeD;
    protected Formals formals;
    protected Pcd pcd;

    public void walkInnerInfo(InnerInfoPass w) {
        int context = w.inMember(true);
        super.walkInnerInfo(w);
        w.restoreContext(context);
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        return null;
    }

    public void checkSpec() {
        if (this.isStatic()) {
            this.getCompiler().warnVersion("1.0beta1", this, "pointcut declarations may not be static");
        }
        if (this.resultTypeD != null) {
            this.getCompiler().warnVersion("1.0beta1", this, "pointcut declarations don't use returns clause");
        }
        if (this.isAbstract() && this.isPrivate()) {
            this.showError("abstract private pointcut can never be implemented");
        }
        if (!this.isAbstract() && this.pcd != null && !(this.pcd instanceof EmptyPcd)) {
            int i = 0;
            while (i < this.formals.size()) {
                if (!this.formals.get((int)i).isBound) {
                    this.formals.get(i).showError("not bound in this PCD");
                }
                ++i;
            }
        }
    }

    public void preScope(ScopeWalker walker) {
        walker.pushScope(this.makeBlockScope(walker));
    }

    public ASTObject postScope(ScopeWalker walker) {
        walker.popScope();
        return this;
    }

    public String toShortString() {
        return this.modifiers.toShortString() + " " + this.getDeclaringType().toShortString() + "." + this.id + this.formals.toShortString();
    }

    public String getKind() {
        return "pointcut";
    }

    public SemanticObject makeCorrespondingSemanticObject() {
        return new PointcutSO(this);
    }

    public boolean isAbstract(PlanData planData) {
        return this.pcd == null || this.pcd instanceof EmptyPcd;
    }

    public boolean conflictsWith(Dec otherDec) {
        if (!this.getId().equals(otherDec.getId())) {
            return false;
        }
        return this.isAccessible(otherDec) || otherDec.isAccessible(this);
    }

    void showOverrideError(Dec other, String message) {
        String overrideKind = "override";
        this.showError(this.toShortString() + " cannot " + overrideKind + " " + other.toShortString() + "; " + message);
    }

    public boolean checkOverride(Type inType, Dec otherDec) {
        PointcutDec other = (PointcutDec)otherDec;
        if (other.getModifiers().isFinal()) {
            this.showOverrideError(other, "overridden pointcut is final");
        } else if (this.getModifiers().isWeakerThan(other.getModifiers())) {
            this.showOverrideError(other, "attempting to assign weaker access privileges; was " + other.getModifiers().toShortString());
        } else if (!this.getFormals().matches(other.getFormals())) {
            this.showOverrideError(other, "signatures must match exactly; expected " + other.getFormals().toShortString());
        }
        return false;
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Modifiers _modifiers) {
        if (_modifiers != null) {
            _modifiers.setParent(this);
        }
        this.modifiers = _modifiers;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public TypeD getResultTypeD() {
        return this.resultTypeD;
    }

    public void setResultTypeD(TypeD _resultTypeD) {
        if (_resultTypeD != null) {
            _resultTypeD.setParent(this);
        }
        this.resultTypeD = _resultTypeD;
    }

    public Formals getFormals() {
        return this.formals;
    }

    public void setFormals(Formals _formals) {
        if (_formals != null) {
            _formals.setParent(this);
        }
        this.formals = _formals;
    }

    public Pcd getPcd() {
        return this.pcd;
    }

    public void setPcd(Pcd _pcd) {
        if (_pcd != null) {
            _pcd.setParent(this);
        }
        this.pcd = _pcd;
    }

    public PointcutDec(SourceLocation location, Modifiers _modifiers, String _id, TypeD _resultTypeD, Formals _formals, Pcd _pcd) {
        super(location);
        this.setModifiers(_modifiers);
        this.setId(_id);
        this.setResultTypeD(_resultTypeD);
        this.setFormals(_formals);
        this.setPcd(_pcd);
    }

    protected PointcutDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        PointcutDec ret = new PointcutDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        ret.id = this.id;
        if (this.resultTypeD != null) {
            ret.setResultTypeD((TypeD)walker.process(this.resultTypeD));
        }
        if (this.formals != null) {
            ret.setFormals((Formals)walker.process(this.formals));
        }
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.resultTypeD;
            }
            case 2: {
                return this.formals;
            }
            case 3: {
                return this.pcd;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "resultTypeD";
            }
            case 2: {
                return "formals";
            }
            case 3: {
                return "pcd";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setResultTypeD((TypeD)child);
                return;
            }
            case 2: {
                this.setFormals((Formals)child);
                return;
            }
            case 3: {
                this.setPcd((Pcd)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 4;
    }

    public String getDefaultDisplayName() {
        return "PointcutDec(id: " + this.id + ")";
    }
}

