/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.util.FuzzyBoolean;

public class SimpleTypeName
extends GenTypeName {
    protected Type type;
    protected boolean includeSubTypes;

    public String toShortString() {
        if (this.includeSubTypes) {
            return this.type.getPrettyString() + "+";
        }
        return this.type.getPrettyString();
    }

    public boolean matches(Type type) {
        if (this.includeSubTypes) {
            return type.isSubtypeOf(this.getType());
        }
        return type == this.getType();
    }

    public FuzzyBoolean matchesInstance(Type exprType) {
        Type formalType = this.getType();
        if (formalType.isObject()) {
            return FuzzyBoolean.YES;
        }
        if (formalType.isAssignableFrom(exprType)) {
            return FuzzyBoolean.YES;
        }
        if (exprType.isCoercableTo(formalType)) {
            return FuzzyBoolean.MAYBE;
        }
        return FuzzyBoolean.NO;
    }

    public JpPlan makePlan(JoinPoint jp, Expr expr) {
        Type exprType = expr.getType();
        Type formalType = this.getType();
        if (this.matchesInstance(exprType).alwaysFalse()) {
            return JpPlan.NO_PLAN;
        }
        JpPlan plan = new JpPlan(jp);
        if (formalType.isObject()) {
            return plan;
        }
        if (formalType.isAssignableFrom(exprType)) {
            return plan;
        }
        if (exprType.isCoercableTo(formalType)) {
            AST ast = this.getAST();
            Expr testExpr = ast.makeParen(ast.makeInstanceof(expr, formalType));
            plan.addExprTest(testExpr);
            return plan;
        }
        return JpPlan.NO_PLAN;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type _type) {
        this.type = _type;
    }

    public boolean getIncludeSubTypes() {
        return this.includeSubTypes;
    }

    public void setIncludeSubTypes(boolean _includeSubTypes) {
        this.includeSubTypes = _includeSubTypes;
    }

    public SimpleTypeName(SourceLocation location, Type _type, boolean _includeSubTypes) {
        super(location);
        this.setType(_type);
        this.setIncludeSubTypes(_includeSubTypes);
    }

    protected SimpleTypeName(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        SimpleTypeName ret = new SimpleTypeName(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.type = this.type;
        ret.includeSubTypes = this.includeSubTypes;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "SimpleTypeName(type: " + this.type + ", " + "includeSubTypes: " + this.includeSubTypes + ")";
    }
}

