/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class StaticInitializerPcd
extends Pcd {
    protected GenTypeName typeName;

    public String toShortString() {
        return "staticinitialization(" + this.getTypeName().toShortString() + ")";
    }

    public void checkStatic() {
    }

    public int getJpKind() {
        return 8192;
    }

    public JpPlanner makePlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                if (jp.getTypeCode() != StaticInitializerPcd.this.getJpKind()) {
                    return FuzzyBoolean.NO;
                }
                return StaticInitializerPcd.this.getTypeName().matches(jp.getTargetType()) ? FuzzyBoolean.YES : FuzzyBoolean.NO;
            }
        };
    }

    public GenTypeName getTypeName() {
        return this.typeName;
    }

    public void setTypeName(GenTypeName _typeName) {
        if (_typeName != null) {
            _typeName.setParent(this);
        }
        this.typeName = _typeName;
    }

    public StaticInitializerPcd(SourceLocation location, GenTypeName _typeName) {
        super(location);
        this.setTypeName(_typeName);
    }

    protected StaticInitializerPcd(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        StaticInitializerPcd ret = new StaticInitializerPcd(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.typeName != null) {
            ret.setTypeName((GenTypeName)walker.process(this.typeName));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.typeName;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "typeName";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTypeName((GenTypeName)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "StaticInitializerPcd()";
    }
}

