/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class ThisPcd
extends Pcd {
    protected GenTypeName typeName;

    public String toShortString() {
        return "this(" + this.getTypeName().toShortString() + ")";
    }

    public boolean allowsNameBinding() {
        return true;
    }

    public void checkStatic() {
        this.showNonStaticError();
    }

    public JpPlanner makePlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                if (jp.getThisExprType() == null) {
                    return FuzzyBoolean.NO;
                }
                return ThisPcd.this.getTypeName().matchesInstance(jp.getThisExprType());
            }

            public JpPlan makePlan(JoinPoint jp) {
                if (jp.getSourceLocation() == null) {
                    return JpPlan.NEVER_PLAN;
                }
                if (jp.makeThisExpr() == null) {
                    return JpPlan.NO_PLAN;
                }
                return ThisPcd.this.getTypeName().makePlan(jp, jp.makeThisExpr());
            }
        };
    }

    public GenTypeName getTypeName() {
        return this.typeName;
    }

    public void setTypeName(GenTypeName _typeName) {
        if (_typeName != null) {
            _typeName.setParent(this);
        }
        this.typeName = _typeName;
    }

    public ThisPcd(SourceLocation location, GenTypeName _typeName) {
        super(location);
        this.setTypeName(_typeName);
    }

    protected ThisPcd(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ThisPcd ret = new ThisPcd(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.typeName != null) {
            ret.setTypeName((GenTypeName)walker.process(this.typeName));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.typeName;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "typeName";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTypeName((GenTypeName)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "ThisPcd()";
    }
}

