/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.util.FuzzyBoolean;

public class VarTypeName
extends GenTypeName {
    protected FormalDec formalDec;

    public String toShortString() {
        return this.formalDec.getName();
    }

    public boolean matches(Type type) {
        return false;
    }

    public FuzzyBoolean matchesInstance(Type exprType) {
        Type formalType = this.formalDec.getType();
        if (formalType.isObject()) {
            return FuzzyBoolean.YES;
        }
        if (formalType.isAssignableFrom(exprType)) {
            return FuzzyBoolean.YES;
        }
        if (exprType.isCoercableTo(formalType)) {
            return FuzzyBoolean.MAYBE;
        }
        return FuzzyBoolean.NO;
    }

    public JpPlan makePlan(JoinPoint jp, Expr expr) {
        Type exprType = expr.getType();
        Type formalType = this.formalDec.getType();
        if (this.matchesInstance(exprType).alwaysFalse()) {
            return JpPlan.NO_PLAN;
        }
        JpPlan plan = new JpPlan(jp);
        if (formalType.isObject()) {
            if (exprType.isPrimitive()) {
                expr = exprType.makeObject(expr);
            }
            plan.bindExpr(this.formalDec, expr);
            return plan;
        }
        if (formalType.isAssignableFrom(exprType)) {
            plan.bindExpr(this.formalDec, expr);
            return plan;
        }
        if (exprType.isCoercableTo(formalType)) {
            AST ast = this.getAST();
            Expr testExpr = ast.makeParen(ast.makeInstanceof(expr, formalType));
            plan.addExprTest(testExpr);
            plan.bindExpr(this.formalDec, expr);
            return plan;
        }
        return JpPlan.NO_PLAN;
    }

    public FormalDec getFormalDec() {
        return this.formalDec;
    }

    public void setFormalDec(FormalDec _formalDec) {
        this.formalDec = _formalDec;
    }

    public VarTypeName(SourceLocation location, FormalDec _formalDec) {
        super(location);
        this.setFormalDec(_formalDec);
    }

    protected VarTypeName(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        VarTypeName ret = new VarTypeName(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.formalDec = this.formalDec;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "VarTypeName(formalDec: " + this.formalDec + ")";
    }
}

