/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.CodePattern;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.CodeDecJp;
import org.aspectj.compiler.crosscuts.joinpoints.ConstructorExecutionJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.MethodExecutionJp;
import org.aspectj.util.FuzzyBoolean;

public class WithinCodePcd
extends Pcd {
    protected CodePattern codePattern;

    public String toShortString() {
        return "withincode(" + this.getCodePattern().toShortString() + ")";
    }

    public void checkStatic() {
    }

    private CodeDec matchingEnclosingCodeDec(CodeDec codeDec) {
        while (codeDec != null) {
            CodeDecJp jp;
            if (codeDec instanceof ConstructorDec) {
                jp = new ConstructorExecutionJp((ConstructorDec)codeDec);
            } else if (codeDec instanceof MethodDec) {
                jp = new MethodExecutionJp((MethodDec)codeDec);
            } else {
                return null;
            }
            if (this.getCodePattern().matches(jp).alwaysTrue()) {
                return codeDec;
            }
            if (!codeDec.getDeclaringType().getTypeDec().isLocal()) break;
            codeDec = codeDec.getEnclosingCodeDec();
        }
        return null;
    }

    public JpPlanner makePlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                ASTObject sourceLocation = jp.getSourceLocation();
                if (sourceLocation == null) {
                    return FuzzyBoolean.NEVER;
                }
                CodeDec codeDec = sourceLocation instanceof CodeDec ? (CodeDec)sourceLocation : sourceLocation.getEnclosingCodeDec();
                if (codeDec == null) {
                    return FuzzyBoolean.NO;
                }
                if ((codeDec = WithinCodePcd.this.matchingEnclosingCodeDec(codeDec)) == null) {
                    return FuzzyBoolean.NO;
                }
                return FuzzyBoolean.YES;
            }
        };
    }

    public CodePattern getCodePattern() {
        return this.codePattern;
    }

    public void setCodePattern(CodePattern _codePattern) {
        if (_codePattern != null) {
            _codePattern.setParent(this);
        }
        this.codePattern = _codePattern;
    }

    public WithinCodePcd(SourceLocation location, CodePattern _codePattern) {
        super(location);
        this.setCodePattern(_codePattern);
    }

    protected WithinCodePcd(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        WithinCodePcd ret = new WithinCodePcd(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.codePattern != null) {
            ret.setCodePattern((CodePattern)walker.process(this.codePattern));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.codePattern;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "codePattern";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setCodePattern((CodePattern)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "WithinCodePcd()";
    }
}

