/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class WithinPcd
extends Pcd {
    protected GenTypeName typeName;

    public String toShortString() {
        return "within(" + this.getTypeName().toShortString() + ")";
    }

    public void checkStatic() {
    }

    private TypeDec matchingEnclosingTypeDec(TypeDec typeDec) {
        while (typeDec != null) {
            if (this.getTypeName().matches(typeDec.getType())) {
                return typeDec;
            }
            typeDec = typeDec.getEnclosingTypeDec();
        }
        return null;
    }

    public JpPlanner makePlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                ASTObject sourceLocation = jp.getSourceLocation();
                if (sourceLocation == null) {
                    return FuzzyBoolean.NEVER;
                }
                TypeDec typeDec = sourceLocation.getLexicalType().getTypeDec();
                TypeDec matchingTypeDec = WithinPcd.this.matchingEnclosingTypeDec(typeDec);
                if (matchingTypeDec == null) {
                    return FuzzyBoolean.NO;
                }
                return FuzzyBoolean.YES;
            }
        };
    }

    public GenTypeName getTypeName() {
        return this.typeName;
    }

    public void setTypeName(GenTypeName _typeName) {
        if (_typeName != null) {
            _typeName.setParent(this);
        }
        this.typeName = _typeName;
    }

    public WithinPcd(SourceLocation location, GenTypeName _typeName) {
        super(location);
        this.setTypeName(_typeName);
    }

    protected WithinPcd(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        WithinPcd ret = new WithinPcd(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.typeName != null) {
            ret.setTypeName((GenTypeName)walker.process(this.typeName));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.typeName;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "typeName";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTypeName((GenTypeName)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "WithinPcd()";
    }
}

