/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.Collection;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AnyCallExpr;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.AnonymousMethodExpr;
import org.aspectj.compiler.crosscuts.joinpoints.ExprJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;

public abstract class CallJp
extends ExprJp {
    private Formals codeFormals = null;
    protected Exprs argValues;
    protected Exprs innerArgs;

    public CallJp(AnyCallExpr callExpr, JoinPoint enclosingJp) {
        super(callExpr, enclosingJp);
    }

    public Dec getTargetDec() {
        return this.getCalledCodeDec();
    }

    public AnyCallExpr getCallExpr() {
        return (AnyCallExpr)this.expr;
    }

    public Exprs makeArgsExprs() {
        this.getCodeFormals();
        return (Exprs)CopyWalker.copy(this.argValues);
    }

    public abstract Type getTargetType();

    public abstract Type getTargetExprType();

    public abstract boolean isMethodCall();

    public CodeDec getCalledCodeDec() {
        return this.getCallExpr().getCodeDec();
    }

    public boolean canThrow(Type t) {
        return this.getCalledCodeDec().canThrow(t);
    }

    public Collection getPossibleCheckedExceptions() {
        return this.getCalledCodeDec().getPossibleCheckedExceptions();
    }

    public Formals getCodeFormals() {
        if (this.codeFormals == null) {
            AST ast = this.getAST();
            this.codeFormals = ast.makeFormals();
            this.argValues = ast.makeExprs();
            this.innerArgs = ast.makeExprs();
            Formals calledFormals = this.getCalledCodeDec().getFormals();
            int N = calledFormals.size();
            int i = 0;
            while (i < N) {
                FormalDec formal = ast.makeFinalFormal(calledFormals.get(i).getType(), calledFormals.get(i).getId());
                this.argValues.add(ast.makeVar(formal));
                this.codeFormals.add(formal);
                this.innerArgs.add(ast.makeVar(formal));
                ++i;
            }
        }
        return this.codeFormals;
    }

    protected abstract ASTObject makeInnerCall(Expr var1, Exprs var2);

    protected AnonymousMethodExpr makeSyntheticCall() {
        return this.makeAnonMethodExpr(this.getCodeFormals(), this.getCallExpr().getExpr(), this.getCallExpr().getArgs());
    }
}

