/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.AnonymousMethodExpr;
import org.aspectj.compiler.crosscuts.joinpoints.FieldGetJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;

public class FieldSetJp
extends FieldGetJp {
    public static final JoinPoint.Kind KIND = new JoinPoint.Kind("field-set", 128);
    FormalDec newValueFormal = null;

    public FieldSetJp(FieldSetExprPromise fieldSetExprPromise, JoinPoint enclosingJoinPoint) {
        super(fieldSetExprPromise, enclosingJoinPoint);
    }

    public JoinPoint.Kind getKind() {
        return KIND;
    }

    public FormalDec getNewValueFormal() {
        if (this.newValueFormal == null) {
            this.newValueFormal = this.getAST().makeFormal(this.getResultType(), "newValue");
        }
        return this.newValueFormal;
    }

    public Expr makeNewFieldValueExpr() {
        return this.getAST().makeVar(this.getNewValueFormal());
    }

    public Expr makeNewValueExpr() {
        return this.getResultType().makeObject(this.getAST().makeVar(this.getNewValueFormal()));
    }

    public List makeArgsTypes() {
        ArrayList<Type> ret = new ArrayList<Type>();
        ret.add(this.getResultType());
        return ret;
    }

    public Exprs makeArgsExprs() {
        return this.getAST().makeExprs(this.makeNewFieldValueExpr());
    }

    protected ASTObject makeInnerCall(Expr targetExpr, Exprs argsExprs) {
        return this.getAST().makeSet(targetExpr, this.getCalledFieldDec(), argsExprs.get(0));
    }

    protected AnonymousMethodExpr makeSyntheticCall() {
        AST ast = this.getAST();
        AssignExpr setExpr = ((FieldSetExprPromise)this.fieldGetExprPromise).getAssignExpr();
        Expr newValue = ast.makeCast(this.getNewValueFormal().getType(), setExpr.getRhs());
        return this.makeAnonMethodExpr(ast.makeFormals(this.getNewValueFormal()), ((FieldAccessExpr)setExpr.getLhs()).getExpr(), ast.makeExprs(newValue));
    }

    protected void replaceExprWith(Expr newExpr) {
        ((FieldSetExprPromise)this.fieldGetExprPromise).getAssignExpr().replaceWith(newExpr);
    }

    public static interface FieldSetExprPromise
    extends FieldGetJp.FieldGetExprPromise {
        public AssignExpr getAssignExpr();
    }
}

