/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.UnopExpr;

public class InstanceTest
extends CompilerObject {
    private List andBlocks = new ArrayList();

    private InstanceTest(JavaCompiler compiler) {
        this(compiler, new ArrayList());
    }

    private InstanceTest(JavaCompiler compiler, Type type, boolean isTrue) {
        this(compiler);
        this.addOr(type, isTrue);
    }

    private InstanceTest(JavaCompiler compiler, List andBlocks) {
        super(compiler);
        this.andBlocks = andBlocks;
    }

    public int size() {
        return this.andBlocks.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ITest(");
        int i = 0;
        while (i < this.andBlocks.size()) {
            AndBlock block1 = (AndBlock)this.andBlocks.get(i);
            if (i > 0) {
                buf.append("  || ");
            }
            buf.append(block1.toString());
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public void addOr(Type typeDec, boolean isTrue) {
        this.andBlocks.add(new AndBlock(this.getCompiler(), typeDec, isTrue));
    }

    public InstanceTest intersect(InstanceTest other) {
        ArrayList<AndBlock> newBlocks = new ArrayList<AndBlock>();
        int i = 0;
        while (i < this.andBlocks.size()) {
            AndBlock block1 = (AndBlock)this.andBlocks.get(i);
            int j = 0;
            while (j < other.andBlocks.size()) {
                AndBlock block2 = (AndBlock)other.andBlocks.get(j);
                newBlocks.add(block1.intersect(block2));
                ++j;
            }
            ++i;
        }
        return new InstanceTest(this.getCompiler(), newBlocks);
    }

    public InstanceTest union(InstanceTest other) {
        ArrayList newBlocks = new ArrayList(this.andBlocks);
        newBlocks.addAll(other.andBlocks);
        return new InstanceTest(this.getCompiler(), newBlocks);
    }

    public InstanceTest complement() {
        InstanceTest ret = null;
        int i = 0;
        while (i < this.andBlocks.size()) {
            AndBlock block = (AndBlock)this.andBlocks.get(i);
            InstanceTest test = block.complement();
            ret = ret == null ? test : ret.intersect(test);
            ++i;
        }
        return ret;
    }

    private void reduce(Type staticType) {
        if (staticType == null) {
            System.out.println("troubled..." + this);
            return;
        }
        ArrayList<AndBlock> newBlocks = new ArrayList<AndBlock>();
        int i = 0;
        while (i < this.andBlocks.size()) {
            AndBlock block = (AndBlock)this.andBlocks.get(i);
            if ((block = block.reduce(staticType)) != null) {
                newBlocks.add(block);
            }
            ++i;
        }
        this.andBlocks = newBlocks;
    }

    public Expr makeExpr(Expr thisExpr) {
        Type type = thisExpr.getType();
        this.reduce(type);
        Expr ret = null;
        int i = 0;
        while (i < this.andBlocks.size()) {
            AndBlock block = (AndBlock)this.andBlocks.get(i);
            Expr blockExpr = block.makeExpr(thisExpr);
            ret = ret == null ? blockExpr : this.getAST().makeBinop("||", ret, blockExpr);
            ++i;
        }
        return ret;
    }

    private static class AndBlock
    extends CompilerObject {
        private List trueTypes = new ArrayList();
        private List falseTypes = new ArrayList();

        public AndBlock(JavaCompiler compiler, Type typeDec, boolean isTrue) {
            super(compiler);
            if (isTrue) {
                this.trueTypes.add(typeDec);
            } else {
                this.falseTypes.add(typeDec);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.trueTypes.size()) {
                if (i > 0) {
                    buf.append(" && ");
                }
                buf.append(((Type)this.trueTypes.get(i)).toShortString());
                ++i;
            }
            i = 0;
            while (i < this.falseTypes.size()) {
                if (i > 0 || this.trueTypes.size() > 0) {
                    buf.append(" && ");
                }
                buf.append("!");
                buf.append(((Type)this.falseTypes.get(i)).toShortString());
                ++i;
            }
            return buf.toString();
        }

        public InstanceTest complement() {
            ArrayList<AndBlock> newBlocks = new ArrayList<AndBlock>(this.trueTypes.size() + this.falseTypes.size());
            int i = 0;
            while (i < this.trueTypes.size()) {
                newBlocks.add(new AndBlock(this.getCompiler(), (Type)this.trueTypes.get(i), false));
                ++i;
            }
            i = 0;
            while (i < this.falseTypes.size()) {
                newBlocks.add(new AndBlock(this.getCompiler(), (Type)this.falseTypes.get(i), true));
                ++i;
            }
            return new InstanceTest(this.getCompiler(), newBlocks);
        }

        public AndBlock intersect(AndBlock other) {
            this.trueTypes.addAll(other.trueTypes);
            this.falseTypes.addAll(other.falseTypes);
            return this;
        }

        public AndBlock reduce(Type staticType) {
            Iterator i = this.trueTypes.iterator();
            while (i.hasNext()) {
                Type trueType = (Type)i.next();
                if (!staticType.isSubtypeOf(trueType)) continue;
                i.remove();
            }
            i = this.falseTypes.iterator();
            while (i.hasNext()) {
                Type falseType = (Type)i.next();
                if (falseType.isSubtypeOf(staticType) || staticType.isSubtypeOf(falseType)) continue;
                i.remove();
            }
            if (this.trueTypes.size() == 0 && this.falseTypes.size() == 0) {
                return null;
            }
            return this;
        }

        private Expr makeInstanceOfExpr(Expr expr, Type checkType) {
            return this.getAST().makeParen(this.getAST().makeInstanceof(expr, checkType));
        }

        private Expr intersectExpr(Expr e1, Expr e2) {
            if (e1 == null) {
                return e2;
            }
            return this.getAST().makeBinop("&&", e1, e2);
        }

        public Expr makeExpr(Expr thisExpr) {
            Expr testExpr;
            Expr ret = null;
            int i = 0;
            while (i < this.trueTypes.size()) {
                testExpr = this.makeInstanceOfExpr(thisExpr, (Type)this.trueTypes.get(i));
                ret = this.intersectExpr(ret, testExpr);
                ++i;
            }
            i = 0;
            while (i < this.falseTypes.size()) {
                testExpr = this.makeInstanceOfExpr(thisExpr, (Type)this.falseTypes.get(i));
                testExpr = this.getAST().makeUnop("!", testExpr);
                ret = this.intersectExpr(ret, testExpr);
                ++i;
            }
            if (ret instanceof UnopExpr) {
                return ret;
            }
            return this.getAST().makeParen(ret);
        }
    }
}

