/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.crosscuts.AspectJCompiler;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.joinpoints.AdvicePlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.util.PartialOrder;

public abstract class JoinPoint
extends CompilerObject {
    public static final int METHOD_EXECUTION = 1;
    public static final int METHOD_CALL = 4;
    public static final int CONSTRUCTOR_EXECUTION = 8;
    public static final int CONSTRUCTOR_CALL = 32;
    public static final int FIELD_GET = 64;
    public static final int FIELD_SET = 128;
    public static final int HANDLER = 256;
    public static final int ADVICE_EXECUTION = 4096;
    public static final int STATIC_INITIALIZER_EXECUTION = 8192;
    public static final int INSTANCE_INITIALIZER_EXECUTION = 16384;
    public static final int INITIALIZER_EXECUTION = 32768;
    public static final int SUPER_METHOD_CALL = 65536;
    public static final int SUPER_CONSTRUCTOR_CALL = 131072;
    List plans = new ArrayList(0);
    private boolean implementedPlans = false;
    private VarDec dynamicJoinPointDec = null;
    private FieldDec staticJoinPointDec = null;

    public abstract Kind getKind();

    public JoinPoint(JavaCompiler compiler) {
        super(compiler);
    }

    public void addPlan(JpPlan plan) {
        this.plans.add(plan);
    }

    public abstract ASTObject getSourceLocation();

    public abstract Dec getTargetDec();

    public SemanticObject getTargetSO() {
        return this.getTargetDec().getCorrespondingSemanticObject();
    }

    public ASTObject getTargetNode() {
        return this.getSourceLocation();
    }

    public final int getTypeCode() {
        return this.getKind().getIntCode();
    }

    public abstract Type getResultType();

    public Type getExceptionType() {
        return null;
    }

    public Type getBytecodeType() {
        return this.getSourceLocation().getBytecodeType();
    }

    public Type getDeclaringType() {
        return this.getSourceLocation().getDeclaringType();
    }

    public abstract Type getTargetType();

    public Set getTargetTypes() {
        HashSet<Type> ret = new HashSet<Type>();
        Type t = this.getTargetType();
        if (t == null) {
            this.getCompiler().internalError("must override getTargetTypes in " + this);
        } else {
            ret.add(t);
        }
        return ret;
    }

    public Type getTargetExprType() {
        return this.getThisExprType();
    }

    public Expr makeTargetExpr() {
        return this.makeThisExpr();
    }

    public Type getThisExprType() {
        if (this.isStaticContext()) {
            return null;
        }
        return this.getDeclaringType();
    }

    public abstract boolean isStaticContext();

    public Expr makeThisExpr() {
        Type thisType = this.getThisExprType();
        if (thisType == null) {
            return null;
        }
        return this.getAST().makeThis(thisType);
    }

    public abstract Exprs makeArgsExprs();

    public Expr makeThisExprOrType() {
        if (this.isStaticContext()) {
            return this.getAST().makeTypeExpr(this.getBytecodeType());
        }
        return this.getAST().makeThis(this.getBytecodeType());
    }

    public Expr makeVoidReturnExpr() {
        return this.getAST().makeNull();
    }

    public abstract boolean canThrow(Type var1);

    public abstract Collection getPossibleCheckedExceptions();

    public void showError(ASTObject node, String message) {
        JpPlan plan;
        node.showError("on target " + this + " " + message);
        if (this.plans.size() > 0 && (plan = (JpPlan)this.plans.get(0)) instanceof AdvicePlan) {
            AdviceDec adviceDec = ((AdvicePlan)plan).getAdviceDec();
            if (adviceDec == node || adviceDec.getPcd() == node) {
                return;
            }
            Pcd where = adviceDec.getPcd();
            where.showError("above target " + this + " is matched by");
        }
    }

    public void showWarning(ASTObject node, String message) {
        node.showWarning("on target " + this + " " + message);
    }

    public Type makeFactoryType() {
        return this.getTypeManager().getType("org.aspectj.runtime.reflect", "Factory");
    }

    public FieldDec makeFactoryDec() {
        AST ast = this.getAST();
        File f = this.getStaticFieldHolder().getSourceFile();
        String fname = f == null ? "<missing>" : f.getName();
        Modifiers modifiers = ast.makeModifiers(24);
        if (this.getStaticFieldHolder().getType().isInterface()) {
            modifiers.setPublic(true);
        }
        return ast.makeField(modifiers, this.makeFactoryType(), "ajc$JPF", ast.makeNew(this.makeFactoryType(), ast.makeLiteral(fname), ast.makeLiteral(this.getStaticFieldHolder().getType())));
    }

    public FieldDec getFactoryDec() {
        if (this.getStaticFieldHolder().joinPointFactoryDec == null) {
            FieldDec factoryDec;
            this.getStaticFieldHolder().joinPointFactoryDec = factoryDec = this.makeFactoryDec();
            this.getStaticFieldHolder().getBody().add(0, factoryDec);
        }
        return this.getStaticFieldHolder().joinPointFactoryDec;
    }

    public Expr makeFactoryInstance() {
        return this.getAST().makeGet(this.getFactoryDec());
    }

    public Expr makeObjectsArray(Formals formals) {
        AST ast = this.getAST();
        Exprs exprs = ast.makeExprs();
        int i = 0;
        while (i < formals.size()) {
            exprs.add(ast.makeVar(formals.get(i)));
            ++i;
        }
        return ast.makeObjectArray(exprs);
    }

    public String makeString(int i) {
        return Integer.toString(i, 16);
    }

    public String makeString(Type t) {
        return t.getExternalName();
    }

    public String makeString1(ASTObject ast, boolean asType) {
        if (ast instanceof TypeD) {
            return this.makeString(((TypeD)ast).getType());
        }
        if (ast instanceof FormalDec) {
            FormalDec formal = (FormalDec)ast;
            if (asType) {
                return this.makeString(formal.getType());
            }
            return formal.getId();
        }
        return "?";
    }

    public String makeString(TypeDs list) {
        return this.makeString(list, true);
    }

    public String makeString(ASTObject list, boolean asType) {
        if (list == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int N = list.getChildCount();
        int i = 0;
        while (i < N) {
            buf.append(this.makeString1(list.getChildAt(i), asType));
            buf.append(':');
            ++i;
        }
        return buf.toString();
    }

    public Expr makeFactoryCall(String name, String stringRep) {
        return this.getAST().makeCall(this.makeFactoryInstance(), name, (Expr)this.getAST().makeLiteral(stringRep));
    }

    public Expr makeSignatureExpr(Dec dec) {
        if (dec instanceof MethodDec) {
            return this.makeSignatureExpr((MethodDec)dec);
        }
        if (dec instanceof ConstructorDec) {
            return this.makeSignatureExpr((ConstructorDec)dec);
        }
        if (dec instanceof AdviceDec) {
            return this.makeSignatureExpr((AdviceDec)dec);
        }
        if (dec instanceof FieldDec) {
            return this.makeSignatureExpr((FieldDec)dec);
        }
        if (dec instanceof InitializerDec) {
            return this.makeSignatureExpr((InitializerDec)dec);
        }
        return null;
    }

    public Expr makeSignatureExpr(ConstructorDec dec) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(dec.getModifiers().getValue()));
        buf.append('-');
        buf.append('-');
        buf.append(this.makeString(dec.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(dec.getFormals(), true));
        buf.append('-');
        buf.append(this.makeString(dec.getFormals(), false));
        buf.append('-');
        buf.append(this.makeString(dec.getThrows()));
        buf.append('-');
        return this.makeFactoryCall("makeConstructorSig", buf.toString());
    }

    public Expr makeSignatureExpr(MethodDec dec) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(dec.getModifiers().getValue()));
        buf.append('-');
        buf.append(dec.getName());
        buf.append('-');
        buf.append(this.makeString(dec.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(dec.getFormals(), true));
        buf.append('-');
        buf.append(this.makeString(dec.getFormals(), false));
        buf.append('-');
        buf.append(this.makeString(dec.getThrows()));
        buf.append('-');
        buf.append(this.makeString(dec.getResultType()));
        buf.append('-');
        return this.makeFactoryCall("makeMethodSig", buf.toString());
    }

    public Expr makeSignatureExpr(AdviceDec dec) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(dec.getModifiers().getValue()));
        buf.append('-');
        buf.append(dec.getName());
        buf.append('-');
        buf.append(this.makeString(dec.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(dec.getFormals(), true));
        buf.append('-');
        buf.append(this.makeString(dec.getFormals(), false));
        buf.append('-');
        buf.append(this.makeString(dec.getThrows()));
        buf.append('-');
        buf.append(this.makeString(dec.getResultType()));
        buf.append('-');
        return this.makeFactoryCall("makeAdviceSig", buf.toString());
    }

    public Expr makeSignatureExpr(FieldDec dec) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(dec.getModifiers().getValue()));
        buf.append('-');
        buf.append(dec.getName());
        buf.append('-');
        buf.append(this.makeString(dec.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(dec.getType()));
        buf.append('-');
        return this.makeFactoryCall("makeFieldSig", buf.toString());
    }

    public Expr makeSignatureExpr(InitializerDec dec) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(dec.getModifiers().getValue()));
        buf.append('-');
        buf.append('-');
        buf.append(this.makeString(dec.getDeclaringType()));
        buf.append('-');
        return this.makeFactoryCall("makeInitializerSig", buf.toString());
    }

    public Expr makeSignatureExpr(CatchClause dec) {
        StringBuffer buf = new StringBuffer();
        buf.append('-');
        buf.append('-');
        buf.append(this.makeString(dec.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(dec.getFormal().getType()));
        buf.append('-');
        buf.append(dec.getFormal().getId());
        buf.append('-');
        return this.makeFactoryCall("makeCatchClauseSig", buf.toString());
    }

    public Expr makeExecutingObjectExpr() {
        Expr ret = this.makeThisExpr();
        if (ret == null) {
            ret = this.getAST().makeNull();
        }
        return ret;
    }

    public JoinPoint getEnclosingExecutionJoinPoint() {
        return null;
    }

    protected final Type getJoinPointType() {
        return this.getTypeManager().getJoinPointType();
    }

    protected final Type getJoinPointStaticPartType() {
        return this.getTypeManager().getJoinPointStaticPartType();
    }

    protected Expr makeSignatureExpr() {
        return this.makeSignatureExpr(this.getTargetDec());
    }

    protected final String getKindString() {
        return this.getKind().toFullString();
    }

    protected Expr makeStaticEnclosingExecutionJoinPointExpr() {
        return null;
    }

    public final Expr makeStaticJoinPointExpr() {
        AST ast = this.getAST();
        Exprs args = ast.makeExprs(ast.makeLiteral(this.getKindString()), this.makeSignatureExpr());
        ASTObject sourceLocation = this.getSourceLocation();
        if (sourceLocation == null) {
            args.add(ast.makeNull());
        } else {
            args.add(ast.makeLiteral(sourceLocation.getBeginLine()));
            args.add(ast.makeLiteral(sourceLocation.getBeginColumn()));
        }
        return ast.makeCall(this.makeFactoryInstance(), "makeSJP", args);
    }

    private Expr reflectNull(Expr expr) {
        if (expr == null) {
            return this.getAST().makeNull();
        }
        return expr;
    }

    public final Expr makeDynamicJoinPointExpr() {
        AST ast = this.getAST();
        Exprs args = ast.makeExprs(this.makeStaticJoinPointVarExpr(), this.reflectNull(this.makeThisExpr()), this.reflectNull(this.makeTargetExpr()), ast.makeObjectArray(this.makeArgsExprs()));
        return ast.makeStaticCall(this.makeFactoryType(), "makeJP", args);
    }

    public Expr makeStaticEnclosingJoinPointVarExpr() {
        if (this.getStaticEnclosingJoinPointDec() == null) {
            return this.getAST().makeNull();
        }
        return this.getAST().makeGet(this.getStaticEnclosingJoinPointDec());
    }

    public Expr makeStaticJoinPointVarExpr() {
        return this.getAST().makeGet(this.getStaticJoinPointDec());
    }

    public Expr makeDynamicJoinPointVarExpr() {
        return this.getAST().makeVar(this.getDynamicJoinPointDec());
    }

    private boolean isSyntheticJoinPoint(Dec dec) {
        if (dec.isSynthetic() && dec instanceof FieldDec) {
            FieldDec field = (FieldDec)dec;
            if (field.getId().indexOf("$ajcjp") != -1) {
                return true;
            }
            if (field.getId().startsWith("ajc$")) {
                return true;
            }
        }
        return false;
    }

    public TypeDec getStaticFieldHolder() {
        return this.getBytecodeType().getOutermostType().getTypeDec();
    }

    FieldDec makeStaticFinalField(Type type, String name, Expr value) {
        AST ast = this.getAST();
        Modifiers modifiers = ast.makeModifiers(26);
        if (this.getStaticFieldHolder().getType().isAspect()) {
            modifiers.setPublic(true);
        }
        if (this.getStaticFieldHolder().getType().isInterface()) {
            modifiers.setPublic(true);
        }
        FieldDec ret = ast.makeField(modifiers, type, name, value);
        return ret;
    }

    void addStaticJoinPointDecToBody() {
        if (this.staticJoinPointDec != null) {
            this.staticJoinPointDec.setInitializer(this.makeStaticJoinPointExpr());
            Decs body = this.getStaticFieldHolder().getBody();
            int i = 0;
            while (i < body.size()) {
                if (!this.isSyntheticJoinPoint(body.get(i))) {
                    this.staticJoinPointDec.setId(this.staticJoinPointDec.getId() + i);
                    body.add(i, this.staticJoinPointDec);
                    break;
                }
                ++i;
            }
            if (i == body.size()) {
                body.add(this.staticJoinPointDec);
            }
        }
    }

    public FieldDec getStaticJoinPointDec() {
        if (this.staticJoinPointDec == null) {
            String name = this.getAST().makeGeneratedName(this.getTargetDec().getId() + "$ajcjp");
            this.staticJoinPointDec = this.makeStaticFinalField(this.getJoinPointStaticPartType(), name, null);
            this.staticJoinPointDec.setAllEnclosingTypes(this.getStaticFieldHolder().getType());
        }
        return this.staticJoinPointDec;
    }

    public VarDec getDynamicJoinPointDec() {
        if (this.dynamicJoinPointDec == null) {
            this.dynamicJoinPointDec = this.getAST().makeFinalVar(this.getJoinPointType(), "thisJoinPoint", this.makeDynamicJoinPointExpr());
        }
        return this.dynamicJoinPointDec;
    }

    public FieldDec getStaticEnclosingJoinPointDec() {
        if (this.getEnclosingExecutionJoinPoint() == null) {
            return this.getStaticJoinPointDec();
        }
        return this.getEnclosingExecutionJoinPoint().getStaticJoinPointDec();
    }

    void showPrettyCircularityError(List plans) {
        Iterator i = plans.iterator();
        while (i.hasNext()) {
            AdvicePlan plan = (AdvicePlan)i.next();
            AdviceDec adviceDec = plan.getAdviceDec();
            AspectDec aspectDec = plan.getAspectDec();
            if (adviceDec != null) {
                this.getCompiler().showError(adviceDec, "circularity in advice precedence applied to " + this);
                continue;
            }
            this.getCompiler().showError(null, plan + ": circularity in advice precedence applied to " + this);
        }
    }

    public boolean hasPlans() {
        return this.plans != null && this.plans.size() > 0;
    }

    public boolean plansMatch(JoinPoint other) {
        if (this.plans.size() != other.plans.size()) {
            return false;
        }
        LinkedList otherPlans = new LinkedList(other.plans);
        Iterator i1 = this.plans.iterator();
        block0: while (i1.hasNext()) {
            AdvicePlan advicePlan;
            JpPlan plan1 = (JpPlan)i1.next();
            if (plan1 instanceof AdvicePlan && (advicePlan = (AdvicePlan)plan1).getAdviceDec().needsCallSiteContext()) {
                return false;
            }
            Iterator i2 = otherPlans.iterator();
            while (i2.hasNext()) {
                JpPlan plan2 = (JpPlan)i2.next();
                if (!plan1.matches(plan2)) continue;
                i2.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    public void forgetPlans() {
        this.plans = new ArrayList(0);
    }

    public void makeCorrespondences() {
        if (this.plans == null) {
            return;
        }
        Iterator i = this.plans.iterator();
        while (i.hasNext()) {
            JpPlan plan = (JpPlan)i.next();
            if (!(plan instanceof AdvicePlan)) continue;
            AdviceDec adviceDec = ((AdvicePlan)plan).getAdviceDec();
            ASTObject codePoint = this.getTargetNode();
            ((AspectJCompiler)this.getCompiler()).getCorrespondences().addPointsTo(adviceDec, codePoint);
        }
    }

    void sortPlans() {
        if (this.plans.size() < 2) {
            return;
        }
        if (PartialOrder.sort(this.plans) == null) {
            this.showPrettyCircularityError(this.plans);
        }
    }

    public boolean needToImplement() {
        return this.plans.size() != 0 || this.dynamicJoinPointDec != null || this.staticJoinPointDec != null;
    }

    public void implementPlans() {
        if (this.implementedPlans || !this.needToImplement()) {
            return;
        }
        this.implementedPlans = true;
        this.sortPlans();
        Collections.reverse(this.plans);
        this.getCompiler().showMessage("  implementing plans on " + this + System.identityHashCode(this));
        this.preImplement();
        if (!this.needToImplement()) {
            return;
        }
        Iterator i = this.plans.iterator();
        while (i.hasNext()) {
            JpPlan plan = (JpPlan)i.next();
            plan.wrapJoinPoint(this);
        }
        this.makeCorrespondences();
        this.finishJoinPoint();
    }

    protected void preImplement() {
    }

    public void finishJoinPoint() {
        if (this.dynamicJoinPointDec != null) {
            this.getStmts().add(0, this.dynamicJoinPointDec);
        }
        this.addStaticJoinPointDecToBody();
    }

    public abstract Stmts getStmts();

    public abstract void setStmts(Stmts var1);

    public static class Kind {
        private String name;
        private int id;

        public Kind(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public int getIntCode() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }

        public String toFullString() {
            return this.name;
        }

        public String toShortString() {
            return this.name;
        }
    }
}

