/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AndAndOpExpr;
import org.aspectj.compiler.base.ast.BooleanLiteralExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.InstanceofExpr;
import org.aspectj.compiler.base.ast.LogNotOpExpr;
import org.aspectj.compiler.base.ast.OrOrOpExpr;
import org.aspectj.compiler.base.ast.ParenExpr;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.util.PartialOrder;

public class JpPlan
extends CompilerObject
implements PartialOrder.PartialComparable {
    public static final int CFLOWENTRY_ROOT = 0;
    public static final int EACHOBJECT = 0;
    public static final int AROUND = 1;
    public static final int AFTER = 1;
    public static final int BEFORE = 1;
    public static final int CFLOWENTRY_NOROOT = 2;
    public static final int SOFT_THROWABLE = 0;
    public JoinPoint joinPoint;
    public Map bindings = new HashMap();
    public Expr test;
    public Expr ifTest;
    public Expr instance;
    public static final JpPlan NO_PLAN = new JpPlan(null){

        public boolean isPossible() {
            return false;
        }

        public JpPlan or(JpPlan other) {
            return other;
        }

        public JpPlan and(JpPlan other) {
            return NO_PLAN;
        }

        public JpPlan not() {
            return ANY_PLAN;
        }

        public String toString() {
            return "NO_PLAN";
        }
    };
    public static final JpPlan NEVER_PLAN = new JpPlan(null){

        public boolean isPossible() {
            return false;
        }

        public JpPlan or(JpPlan other) {
            return this;
        }

        public JpPlan and(JpPlan other) {
            return this;
        }

        public JpPlan not() {
            return this;
        }

        public String toString() {
            return "NEVER_PLAN";
        }
    };
    public static final JpPlan ANY_PLAN = new JpPlan(null){

        public JpPlan or(JpPlan other) {
            if (other == ANY_PLAN) {
                return ANY_PLAN;
            }
            return other.or(ANY_PLAN);
        }

        public JpPlan and(JpPlan other) {
            return other;
        }

        public JpPlan not() {
            return NO_PLAN;
        }

        public String toString() {
            return "ANY_PLAN";
        }
    };
    protected List dependencies = new LinkedList();

    public JpPlan(JoinPoint jp) {
        super(jp == null ? null : jp.getCompiler());
        this.joinPoint = jp;
    }

    public boolean isPossible() {
        if (this.ifTest == null) {
            return this.test == null || !this.isAlwaysFalse(this.test);
        }
        if (this.test == null) {
            return this.ifTest == null || !this.isAlwaysFalse(this.ifTest);
        }
        return !this.isAlwaysFalse(this.test) && !this.isAlwaysFalse(this.ifTest);
    }

    public JoinPoint getJoinPoint() {
        return this.joinPoint;
    }

    public Expr getInstance() {
        return this.instance;
    }

    public void wrapJoinPoint(JoinPoint jp) {
        System.err.println("shouldn't be making this JpPlan concrete!");
    }

    public boolean dependsOn(Object o) {
        return this.dependencies.contains(o);
    }

    public void addDependency(Object o) {
        this.dependencies.add(o);
    }

    public int getPreSortOrder() {
        return 0;
    }

    public int compareTo(Object o) {
        if (!(o instanceof JpPlan) || this == o) {
            return 0;
        }
        JpPlan otherPlan = (JpPlan)o;
        if (this.getPreSortOrder() < otherPlan.getPreSortOrder()) {
            return -1;
        }
        if (this.getPreSortOrder() > otherPlan.getPreSortOrder()) {
            return 1;
        }
        return 0;
    }

    public int fallbackCompareTo(Object o) {
        return 0;
    }

    public boolean matches(JpPlan other) {
        return this == other;
    }

    public JpPlan or(JpPlan other) {
        if (other == NEVER_PLAN) {
            return other;
        }
        if (!other.isPossible()) {
            return this;
        }
        JpPlan plan = new JpPlan(this.joinPoint);
        plan.test = this.orExprs(this.test, other.test);
        plan.ifTest = this.orExprs(this.ifTest, other.ifTest);
        plan.instance = this.mergeInstance(this.instance, other.instance);
        plan.bindings = this.mergeBindings(this.bindings, other.bindings);
        plan.dependencies.addAll(other.dependencies);
        return plan;
    }

    public JpPlan and(JpPlan other) {
        if (other == NEVER_PLAN) {
            return other;
        }
        if (!other.isPossible()) {
            return NO_PLAN;
        }
        JpPlan plan = new JpPlan(this.joinPoint);
        plan.test = this.andExprs(this.test, other.test);
        plan.ifTest = this.andExprs(this.ifTest, other.ifTest);
        plan.instance = this.mergeInstance(this.instance, other.instance);
        plan.bindings = this.mergeBindings(this.bindings, other.bindings);
        plan.dependencies.addAll(other.dependencies);
        return plan;
    }

    public JpPlan not() {
        if (!this.isPossible()) {
            return ANY_PLAN;
        }
        if (this.test == null && this.ifTest == null) {
            return NO_PLAN;
        }
        JpPlan newPlan = new JpPlan(this.joinPoint);
        newPlan.test = this.notExpr(this.test);
        newPlan.ifTest = this.notExpr(this.ifTest);
        newPlan.dependencies = this.dependencies;
        return newPlan;
    }

    public void setInstanceExpr(Expr i) {
        this.instance = i;
    }

    public void addExprTest(Expr t1) {
        this.test = this.andExprs(this.test, t1);
    }

    public void addIfTest(Expr t1) {
        this.ifTest = this.andExprs(this.ifTest, t1);
    }

    Expr andExprs(Expr e1, Expr e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return this.getAST().makeBinop("&&", e1, e2);
    }

    Expr orExprs(Expr e1, Expr e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return this.getAST().makeBinop("||", e1, e2);
    }

    Expr notExpr(Expr e) {
        if (e == null) {
            return null;
        }
        return this.getAST().makeUnop("!", e);
    }

    void checkEquivalent(FormalDec fd, Expr e1, Expr e2) {
        if (!e1.equals(e2)) {
            this.joinPoint.showError(fd, "incompatible bindings for this formal: both " + e1.unparse() + " and " + e2.unparse());
        }
    }

    Map mergeBindings(Map b1, Map b2) {
        HashMap ret = new HashMap(b1);
        Iterator i = b2.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            if (ret.containsKey(key)) {
                this.checkEquivalent((FormalDec)key, (Expr)ret.get(key), (Expr)entry.getValue());
                continue;
            }
            ret.put(key, entry.getValue());
        }
        return ret;
    }

    Expr mergeInstance(Expr i1, Expr i2) {
        if (i1 == null) {
            return i2;
        }
        return i1;
    }

    public void bindInstance(Expr expr) {
        this.instance = expr;
    }

    public void bindExpr(FormalDec formalDec, Expr expr) {
        if (this.bindings.containsKey(formalDec)) {
            this.checkEquivalent(formalDec, expr, (Expr)this.bindings.get(formalDec));
        } else {
            this.bindings.put(formalDec, expr);
        }
    }

    public Stmt wrapDynamicTest(Stmt trueStmt) {
        Expr dynamicTest = this.getDynamicTest();
        if (dynamicTest != null) {
            AST ast = this.getAST();
            return ast.makeBlock(ast.makeIf(dynamicTest, trueStmt));
        }
        return trueStmt;
    }

    private Expr makeDynamicTest(Expr expr, boolean keepTypes) {
        if (expr == null) {
            return null;
        }
        if (expr != null) {
            expr = (Expr)new ExprMover(this.getCompiler(), keepTypes).process(expr);
            if (this.isAlwaysTrue(expr = this.simplify(expr))) {
                expr = null;
            }
        }
        return expr;
    }

    private Expr getBasicDynamicTest() {
        return this.makeDynamicTest(this.test, false);
    }

    private Expr getIfDynamicTest() {
        return this.makeDynamicTest(this.ifTest, true);
    }

    public Expr getDynamicTest() {
        return this.andExprs(this.getBasicDynamicTest(), this.getIfDynamicTest());
    }

    boolean isAlwaysFalse(Expr expr) {
        return expr instanceof BooleanLiteralExpr && !((BooleanLiteralExpr)expr).getBooleanValue();
    }

    boolean isAlwaysTrue(Expr expr) {
        return expr instanceof BooleanLiteralExpr && ((BooleanLiteralExpr)expr).getBooleanValue();
    }

    Expr simplify(Expr expr) {
        if (expr == null) {
            return null;
        }
        return (Expr)new BooleanExprSimplifier(this.getCompiler()).process(expr);
    }

    public void moveBindings(Map remap) {
        this.test = this.getBasicDynamicTest();
        this.ifTest = this.getIfDynamicTest();
        Iterator i = remap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            if (!this.bindings.containsKey(key)) continue;
            this.bindings.put(entry.getValue(), this.bindings.get(key));
        }
    }

    void showFormalNotBound(FormalDec formalDec) {
        formalDec.showError("formal not bound on " + this.joinPoint);
    }

    public Exprs getCallExprs(Formals formals) {
        AST ast = this.getAST();
        Exprs exprs = ast.makeExprs();
        int i = 0;
        while (i < formals.size()) {
            Expr expr = (Expr)this.bindings.get(formals.get(i));
            if (expr == null) {
                this.showFormalNotBound(formals.get(i));
                break;
            }
            exprs.add(this.makeLegalExpr(expr, formals.get(i).getType()));
            ++i;
        }
        return exprs;
    }

    Expr makeLegalExpr(Expr expr, Type type) {
        Type exprType = expr.getType();
        if (type.isObject()) {
            return exprType.makeObject(expr);
        }
        return this.getAST().makeCast(type, expr);
    }

    public String toString() {
        if (this.joinPoint != null) {
            return "plan(" + this.joinPoint.toString() + ")";
        }
        return super.toString();
    }

    private class ExprMover
    extends Walker {
        private boolean keepTypes;

        public ExprMover(JavaCompiler compiler, boolean keepTypes) {
            super(compiler);
            this.keepTypes = keepTypes;
        }

        public ASTObject process(ASTObject object) {
            object.walk(this);
            if (object instanceof VarExpr) {
                VarExpr var = (VarExpr)object;
                if (var.getId().equals("thisJoinPoint")) {
                    return JpPlan.this.joinPoint.makeDynamicJoinPointVarExpr();
                }
                if (var.getId().equals("thisJoinPointStaticPart")) {
                    return JpPlan.this.joinPoint.makeStaticJoinPointVarExpr();
                }
                if (var.getId().equals("aspect$instance") && JpPlan.this.instance != null) {
                    return JpPlan.this.instance.copy();
                }
                VarDec varDec = var.getVarDec();
                Expr expr = (Expr)JpPlan.this.bindings.get(varDec);
                if (expr != null) {
                    expr = (Expr)expr.copy();
                    if (this.keepTypes) {
                        return this.getAST().forceCast(varDec.getType(), expr);
                    }
                    return expr;
                }
                return var;
            }
            return object;
        }
    }

    private class BooleanExprSimplifier
    extends Walker {
        public BooleanExprSimplifier(JavaCompiler compiler) {
            super(compiler);
        }

        public ASTObject process(ASTObject node) {
            node.walk(this);
            if (node instanceof InstanceofExpr) {
                return ((InstanceofExpr)node).simplify();
            }
            if (node instanceof AndAndOpExpr) {
                AndAndOpExpr e = (AndAndOpExpr)node;
                if (JpPlan.this.isAlwaysFalse(e.getRand1()) || JpPlan.this.isAlwaysFalse(e.getRand2())) {
                    return node.getAST().makeLiteral(false);
                }
                if (JpPlan.this.isAlwaysTrue(e.getRand1())) {
                    return e.getRand2();
                }
                if (JpPlan.this.isAlwaysTrue(e.getRand2())) {
                    return e.getRand1();
                }
                return node;
            }
            if (node instanceof OrOrOpExpr) {
                OrOrOpExpr e = (OrOrOpExpr)node;
                if (JpPlan.this.isAlwaysTrue(e.getRand1()) || JpPlan.this.isAlwaysTrue(e.getRand2())) {
                    return node.getAST().makeLiteral(true);
                }
                if (JpPlan.this.isAlwaysFalse(e.getRand1())) {
                    return e.getRand2();
                }
                if (JpPlan.this.isAlwaysFalse(e.getRand2())) {
                    return e.getRand1();
                }
                return node;
            }
            if (node instanceof ParenExpr) {
                ParenExpr e = (ParenExpr)node;
                if (JpPlan.this.isAlwaysFalse(e.getExpr())) {
                    return e.getExpr();
                }
                if (JpPlan.this.isAlwaysTrue(e.getExpr())) {
                    return e.getExpr();
                }
                return node;
            }
            if (node instanceof LogNotOpExpr) {
                LogNotOpExpr e = (LogNotOpExpr)node;
                if (JpPlan.this.isAlwaysTrue(e.getRand1())) {
                    return node.getAST().makeLiteral(false);
                }
                if (JpPlan.this.isAlwaysFalse(e.getRand1())) {
                    return node.getAST().makeLiteral(true);
                }
                return node;
            }
            return node;
        }
    }
}

