/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AnyCallExpr;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.joinpoints.CallJp;
import org.aspectj.compiler.crosscuts.joinpoints.CalleeSideCallJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;

public class MethodCallJp
extends CallJp {
    public static final JoinPoint.Kind KIND = new JoinPoint.Kind("method-call", 4);
    private Map skipTypes = null;

    public MethodCallJp(CallExpr callExpr, JoinPoint enclosingJp) {
        super(callExpr, enclosingJp);
    }

    public JoinPoint.Kind getKind() {
        return KIND;
    }

    public boolean isMethodCall() {
        return true;
    }

    public Type getTargetExprType() {
        if (this.getCalledCodeDec().isStatic()) {
            return null;
        }
        return this.getCallExpr().getExpr().getType();
    }

    public Type getTargetType() {
        return this.getCallExpr().getExpr().getType();
    }

    protected AnyCallExpr makeBasicInnerCall(Expr targetExpr, Exprs argsExprs) {
        AnyCallExpr innerCall = this.getCallExpr();
        innerCall = (AnyCallExpr)innerCall.copy();
        innerCall.setArgs(argsExprs);
        innerCall.setExpr(targetExpr);
        return innerCall;
    }

    protected ASTObject makeInnerCall(Expr targetExpr, Exprs argsExprs) {
        AnyCallExpr innerCall = this.makeBasicInnerCall(targetExpr, argsExprs);
        if (this.skipTypes != null) {
            ASTObject ret = innerCall;
            boolean isVoid = innerCall.getType().isVoid();
            Iterator i = this.skipTypes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Type type = (Type)entry.getKey();
                MethodDec md = (MethodDec)entry.getValue();
                AST ast = this.getAST();
                if (md.isStatic()) {
                    return ast.makeStaticCall(md.getMethod(), (Exprs)this.innerArgs.copy());
                }
                Expr innerExpr = (Expr)targetExpr.copy();
                if (!innerExpr.getType().isCoercableTo(type)) continue;
                CallExpr skipCall = ast.makeCall(md.getMethod(), ast.makeCast(type, innerExpr), (Exprs)this.innerArgs.copy());
                if (innerExpr.getType().isSubtypeOf(type)) {
                    return skipCall;
                }
                Expr instanceTest = ast.makeInstanceof((Expr)innerExpr.copy(), type);
                if (isVoid) {
                    Stmt stmt = ret instanceof Stmt ? (Stmt)ret : ast.makeStmt((Expr)ret);
                    ret = ast.makeIf(instanceTest, ast.makeStmt(skipCall), stmt);
                    continue;
                }
                ret = ast.makeTriTest(instanceTest, skipCall, (Expr)ret);
            }
            return ret;
        }
        return innerCall;
    }

    protected void preImplement() {
        if (!this.hasPlans()) {
            return;
        }
        CodeDec codeDec = this.getCalledCodeDec();
        MethodDec targetMethodDec = (MethodDec)codeDec;
        boolean needsCallSiteAdvice = false;
        HashMap<Type, MethodDec> skipAdviceOnTypes = new HashMap<Type, MethodDec>();
        Iterator i = targetMethodDec.getMatchingMethods().iterator();
        while (i.hasNext()) {
            MethodDec dec = (MethodDec)i.next();
            CalleeSideCallJp targetPoint = (CalleeSideCallJp)this.getWorld().calleeSideCallPoints.get(dec);
            if (targetPoint == null || !targetPoint.hasPlans()) {
                needsCallSiteAdvice = true;
                continue;
            }
            skipAdviceOnTypes.put(targetPoint.getCodeDec().getDeclaringType(), targetPoint.getPostMethodDec());
            if (this.plansMatch(targetPoint)) continue;
            needsCallSiteAdvice = true;
        }
        if (!needsCallSiteAdvice) {
            this.forgetPlans();
        } else if (skipAdviceOnTypes.size() > 0) {
            Set keepTypes = Type.filterTopTypes(skipAdviceOnTypes.keySet());
            skipAdviceOnTypes.keySet().retainAll(keepTypes);
            this.skipAdviceOnTypes(skipAdviceOnTypes);
        }
    }

    public void skipAdviceOnTypes(Map onTypes) {
        this.skipTypes = onTypes;
    }
}

