/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.StepRequest;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerApp;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.Options;
import org.aspectj.debugger.base.SourceLineFinder;
import org.aspectj.debugger.base.SourceManager;
import org.aspectj.debugger.request.BreakpointRequestAction;
import org.aspectj.debugger.request.ClassLineBreakpointRequestAction;
import org.aspectj.debugger.request.ClearAtRequest;
import org.aspectj.debugger.request.ClearOnRequest;
import org.aspectj.debugger.request.SourceLineBreakpointRequestAction;
import org.aspectj.debugger.request.StopAtRequest;
import org.aspectj.debugger.request.StopOnRequest;
import org.aspectj.tools.ide.SourceLine;

public class AJDebugger
extends Debugger {
    public static AJDebugger INSTANCE = null;
    private static final String workingdir = "ajworkingdir";
    private static final String sep = File.separator;
    private static final char sepChar = File.separatorChar;
    private static final int NO_LINE = -1;
    private static final int NO_MAP = -2;
    private HashMap noAJCHash = new HashMap();
    private File workingdirFile = null;
    private final int limit = 10;
    static final String sigToken = "$signature";
    static final String memberToken = "$member";
    static final String staticMemberToken = "$static$member";
    static final String adviceToken = "$reception";
    static final String aroundToken = "$around$reception";
    static final String ajcToken = "$ajc";

    public File getWorkingdir() {
        return this.workingdirFile;
    }

    public void setWorkingdir(String newWorkingdir) {
        try {
            newWorkingdir = new File(newWorkingdir).getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setWorkingdir(new File(newWorkingdir));
    }

    private void setWorkingdir(File file) {
        if (file == null) {
            this.error("The workingdir is null: " + file);
            return;
        }
        if (!file.exists()) {
            this.error("The workingdir doesn't exist: " + file);
            return;
        }
        if (!file.isDirectory()) {
            String msg = "The workingdir isn't a directory: " + file;
            File parent = file.getParentFile();
            msg = msg + "\nTrying to set workingdir with " + parent;
            this.error(msg);
            this.setWorkingdir(parent);
            return;
        }
        this.workingdirFile = file;
    }

    public AJDebugger(DebuggerApp app) {
        this(app, true);
    }

    public AJDebugger(DebuggerApp app, boolean readStartupFiles) {
        super(app);
        if (readStartupFiles) {
            this.readStartupFiles();
        }
        this.setWorkingDirDefault();
        INSTANCE = this;
    }

    public ClassLineBreakpointRequestAction createClassLineEvent(String className, int line, boolean stop) throws DebuggerException {
        return this.createClassLineEvent(className, line, stop, null);
    }

    public ClassLineBreakpointRequestAction createClassLineEvent(String className, int line, boolean stop, String text) throws DebuggerException {
        SourceLine sl = this.classToOutput(className, line);
        ClassLineBreakpointRequestAction a = null;
        if (stop) {
            a = new StopAtRequest(this, className, sl.line);
            a.setText(text);
        } else {
            a = new ClearAtRequest(this, className, sl.line);
            a.setText(text);
        }
        return a;
    }

    public SourceLineBreakpointRequestAction createSourceLineEvent(String sourceName, int line, boolean stop) throws DebuggerException {
        return this.createSourceLineEvent(sourceName, line, stop, null);
    }

    public SourceLineBreakpointRequestAction createSourceLineEvent(String sourceName, int line, boolean stop, String text) throws DebuggerException {
        SourceLine sl = this.fileToOutput(sourceName, line);
        SourceLineBreakpointRequestAction a = null;
        String justSource = this.removeFullWorkingDir(sl.filename);
        if (stop) {
            a = new StopOnRequest(this, justSource, sl.line);
            a.setText(text);
        } else {
            a = new ClearOnRequest(this, justSource, sl.line);
            a.setText(text);
        }
        return a;
    }

    private SourceLine mapToSourceLine(String fullPath, int lineNumber) {
        return new SourceLine(fullPath, lineNumber);
    }

    public SourceLine getSourceLineFromClass(String className, int lineNumber) {
        String fullOutputPath = this.getFullOutputPathFromClass(className);
        return this.mapToSourceLine(fullOutputPath, lineNumber);
    }

    public SourceLine getSourceLineFromSource(String relativePath, int lineNumber) {
        String fullOutputPath = this.getFullOutputPath(relativePath);
        return this.mapToSourceLine(fullOutputPath, lineNumber);
    }

    public SourceLine getSourceLine(BreakpointRequestAction ba) {
        SourceLine sl = null;
        if (ba instanceof ClassLineBreakpointRequestAction) {
            ClassLineBreakpointRequestAction ca = (ClassLineBreakpointRequestAction)ba;
            return this.getSourceLineFromClass(ca.getClassName(), ca.getLine());
        }
        if (ba instanceof BreakpointRequestAction) {
            sl = ba.sourceLine();
        }
        if (sl == null) {
            String sourceName = ba.getRealSourceName();
            String pkgWithSep = this.getPackagePathWithSeparator(ba.getLocation());
            if ("".equals(pkgWithSep)) {
                int islash = sourceName.lastIndexOf(File.separatorChar);
                if (islash == -1) {
                    islash = sourceName.lastIndexOf(47);
                }
                if (islash == -1) {
                    islash = sourceName.lastIndexOf(92);
                }
                if (islash != -1) {
                    sourceName = sourceName.substring(islash + 1);
                }
            }
            String fullOutputPath = this.getFullOutputPath(pkgWithSep + sourceName);
            int lineNumber = ba.getLine();
            sl = this.mapToSourceLine(fullOutputPath, lineNumber);
        }
        return sl;
    }

    public void use(String sourcePath) {
        super.use(sourcePath);
        this.setWorkingDirDefault();
    }

    protected void setWorkingDirDefault() {
        if (this.getWorkingdir() == null) {
            String defaultWorkingdir = this.getSourcePath() + sep + workingdir;
            this.app.outln("Using default workingdir: " + defaultWorkingdir);
            this.setWorkingdir(defaultWorkingdir);
        }
    }

    protected void go(String className, String vmArgs, String commandLine, boolean isSuspended, int debugTraceMode) {
        if (this.getWorkingdir() == null) {
            this.setWorkingDirDefault();
        }
        super.go(className, vmArgs, commandLine, isSuspended, debugTraceMode);
    }

    private int line(SourceLine sl) {
        return sl.line + 1;
    }

    private SourceLine fileToOutput(String relativePath, int sourceLine) throws NonMappingSourceLineException {
        String fullPath = this.getFullSourcePath(relativePath);
        return this.mapToOutputLine(fullPath, sourceLine);
    }

    private SourceLine classToOutput(String className, int sourceLine) throws NonMappingSourceLineException {
        String fullPath = this.getFullSourcePathFromAJCClass(className);
        if (fullPath == null) {
            return this.noSourceLine(this.getFullSourcePathFromClass(className), sourceLine);
        }
        return this.mapToOutputLine(fullPath, sourceLine);
    }

    public boolean isAjcFile(String fullPath) {
        String relativePath = this.getRelativePath(fullPath);
        String fullOutputPath = this.getFullOutputPath(relativePath);
        File outputFile = new File(fullOutputPath);
        return outputFile != null && outputFile.exists() && !outputFile.isDirectory();
    }

    private SourceLine mapToOutputLine(String fullPath, int sourceLine) throws NonMappingSourceLineException {
        return new SourceLine(fullPath, sourceLine);
    }

    public SourceLine noSourceLine(String fullPath, int line) {
        return new SourceLine(fullPath, line);
    }

    public SourceLine sourceLine(SourceLine sl) {
        sl.filename = this.removeSourcePath(sl.filename);
        return sl;
    }

    public SourceLine nonMappingSourceLine(String sourceName, int lineNumber) {
        return new SourceLine("<non-mapping>:" + sourceName + ":" + lineNumber, -1);
    }

    public SourceLine emptySourceLine() {
        return new SourceLine("<no-source>", -1);
    }

    private boolean outputFileExists(String fullPath) {
        String relativePath = this.removeSourcePath(fullPath);
        File file = new File(this.getFullOutputPath(relativePath));
        return file.exists();
    }

    public String __removeSourcePath(String fullPath) {
        int iroot = (fullPath = new File(fullPath).getAbsolutePath()).toLowerCase().indexOf(this.getSourcePath().toLowerCase());
        if (iroot != -1) {
            String relativePath = fullPath.substring(this.getSourcePath().length());
            while (relativePath.length() > 0 && !Character.isJavaIdentifierPart(relativePath.charAt(0))) {
                relativePath = relativePath.substring(1);
            }
            return relativePath;
        }
        return fullPath;
    }

    public String addSourcePath(String relativePath) {
        if (!relativePath.startsWith(this.getSourcePath())) {
            try {
                return new File(this.getSourcePath() + sep + relativePath).getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return relativePath;
    }

    public String removeWorkingDir(String relativePath) {
        String target = workingdir + sep;
        int iwd = relativePath.indexOf(target);
        if (iwd != -1) {
            return relativePath.substring(target.length());
        }
        return relativePath;
    }

    public String removeWorkingDirFromFullPath(String fullPath) {
        String target = workingdir + sep;
        int iwd = fullPath.indexOf(target);
        if (iwd == -1) {
            return fullPath;
        }
        return fullPath.substring(0, iwd) + fullPath.substring(iwd + target.length());
    }

    public String removeFilePath(String fullPath, File comparison) {
        int isep = fullPath.indexOf(sep);
        if (isep == -1) {
            return fullPath;
        }
        int i = 0;
        while (i < fullPath.length()) {
            char c = fullPath.charAt(i);
            if (this.isSep(c)) {
                String filePath = fullPath.substring(0, i);
                File file = new File(fullPath.substring(0, i));
                if (file.equals(comparison)) {
                    return fullPath.substring(i + 1);
                }
            }
            ++i;
        }
        return fullPath;
    }

    public String removeFilePath(String fullPath, String comparison) {
        return this.removeFilePath(fullPath, new File(comparison));
    }

    public String removeFullWorkingDir(String fullPath) {
        return this.removeFilePath(fullPath, this.getWorkingdir());
    }

    public String removeSourcePath(String fullPath) {
        return this.removeCurrentPath(this._removeSourcePath(fullPath));
    }

    public String _removeSourcePath(String fullPath) {
        return this.removeFilePath(fullPath, this.getSourcePath());
    }

    public String removeCurrentPath(String fullPath) {
        return this.removeFilePath(fullPath, ".");
    }

    private boolean isSep(char c) {
        return c == sepChar || c == '/' || c == '\\';
    }

    private String getFullSourcePathFromClass(String className) {
        String relativePath = this.getRelativeFilePathFromClass(className);
        return this.getFullSourcePath(relativePath);
    }

    public String getFullSourcePath(String relativePath) {
        return this.getFullFilePath(relativePath, false);
    }

    public String getFullOutputPath(Location loc, String realSourceName) {
        String decString = loc.declaringType().name();
        String pkg = "";
        int idot = decString.lastIndexOf(".");
        if (idot != -1) {
            pkg = decString.substring(0, idot).replace('.', sepChar) + sep;
        }
        String relativePath = pkg + realSourceName;
        return this.getFullOutputPath(relativePath);
    }

    public String getPackagePathWithSeparator(Location loc) {
        if (loc == null) {
            return "";
        }
        String decString = loc.declaringType().name();
        String pkg = "";
        int idot = decString.lastIndexOf(".");
        if (idot != -1) {
            pkg = decString.substring(0, idot).replace('.', sepChar) + sep;
        }
        return pkg;
    }

    public String getFullOutputPath(String relativePath) {
        char c;
        if (this.getWorkingdir() == null) {
            return "";
        }
        String wdName = this.getWorkingdir().getName();
        int iwd = relativePath.indexOf(wdName);
        if (iwd != -1) {
            relativePath = relativePath.substring(iwd + wdName.length());
        }
        if ((c = relativePath.charAt(0)) == '/' || c == '\\' || c == sepChar) {
            relativePath = relativePath.substring(1);
        }
        return this.getFullFilePath(relativePath, true);
    }

    public String getFullOutputPathFromClass(String className) {
        return this.getFullOutputPath(this.getRelativeFilePathFromClass(className));
    }

    public String getFullFilePath(String relativePath, boolean inWorkingDir) {
        String fullName = null;
        File file = inWorkingDir ? new File(this.getWorkingdir() + sep + relativePath) : new File(relativePath);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        try {
            relativePath = this.getRelativePath(relativePath);
            if (relativePath.toLowerCase().startsWith(this.getSourcePath().toLowerCase())) {
                fullName = relativePath;
            } else {
                boolean oldway = false;
                if (oldway) {
                    fullName = this.getSourcePath() + sep;
                    if (inWorkingDir) {
                        fullName = fullName + workingdir + sep;
                    }
                    fullName = fullName + relativePath;
                } else {
                    fullName = inWorkingDir ? this.getWorkingdir() + sep + relativePath : this.getSourcePath() + sep + relativePath;
                }
            }
            return new File(fullName).getAbsolutePath();
        }
        catch (Exception ioe) {
            ioe.printStackTrace(System.err);
            System.err.println("relativePath=" + relativePath);
            System.err.println("fullName=" + fullName);
            return new File(fullName).getAbsolutePath();
        }
    }

    public String getRelativePath(String fullPath) {
        int isourcePath = fullPath.toLowerCase().indexOf(this.getSourcePath().toLowerCase());
        if (isourcePath == -1) {
            return fullPath;
        }
        return fullPath.substring(isourcePath + this.getSourcePath().length());
    }

    public String getRelativeFilePathFromClass(String className) {
        String newClassName = className.replace('.', sepChar);
        newClassName = newClassName + ".java";
        return newClassName;
    }

    public String getFullSourcePathFromAJCClass(String className) {
        if (this.noAJCHash.get(className) != null) {
            return null;
        }
        String ajFile = this.getFullOutputPathFromClass(className);
        return ajFile;
    }

    public String getClassNameFromFullSourcePath(String fullSourcePath, int line) {
        return "";
    }

    public String sourceName(ReferenceType refType) {
        return "";
    }

    public String sourceName(Location loc) throws AbsentInformationException {
        return this.sourceLine((Location)loc).filename;
    }

    public int lineNumber(Location loc) {
        try {
            return this.sourceLine((Location)loc).line;
        }
        catch (AbsentInformationException aie) {
            aie.printStackTrace();
            return super.lineNumber(loc);
        }
    }

    public boolean locationMaps(Location loc) {
        String sourceName = "";
        try {
            sourceName = loc.sourceName();
        }
        catch (AbsentInformationException aie) {
            return true;
        }
        return this.isMappingRelativePath(sourceName, loc);
    }

    public boolean isMappingRelativePath(String sourceName, Location loc) {
        String fullPath = this.getPackagePathWithSeparator(loc) + sourceName;
        return this.isMappingFullPath(fullPath, loc);
    }

    public boolean isMappingFullPath(String fullPath, Location loc) {
        String fullOutputPath = this.getFullOutputPath(fullPath);
        if (!new File(fullOutputPath).exists()) {
            return true;
        }
        int lineNumber = loc.lineNumber();
        SourceLine sl = null;
        try {
            sl = this.sourceLine(loc);
        }
        catch (AbsentInformationException aie) {
            return true;
        }
        return sl != null && sl.line >= 0;
    }

    public SourceLine sourceLine(String sourceName, String fullOutputPath, int lineNumber) {
        SourceLine sl = this.mapToSourceLine(fullOutputPath, lineNumber);
        if (sl != null) {
            return this.sourceLine(sl);
        }
        if (new File(fullOutputPath).exists()) {
            return this.nonMappingSourceLine(sourceName, lineNumber);
        }
        return this.noSourceLine(sourceName, lineNumber);
    }

    public SourceLine sourceLine(Location loc) throws AbsentInformationException {
        String sourceName = "<not-available>";
        try {
            sourceName = loc.sourceName();
        }
        catch (AbsentInformationException aie) {
            // empty catch block
        }
        int lineNumber = loc.lineNumber();
        String fullSrcPath = this.getFullSourcePath(this.getPackagePathWithSeparator(loc) + sourceName);
        SourceLine sl = this.sourceLineOfMethodThatShouldMap(loc, fullSrcPath);
        if (sl != null) {
            return sl;
        }
        String fullOutputPath = this.getFullOutputPath(this.getPackagePathWithSeparator(loc) + sourceName);
        return this.sourceLine(sourceName, fullOutputPath, lineNumber);
    }

    public SourceLine sourceLineOfMethodThatShouldMap(Location loc, String fullSrcPath) {
        return new SourceLineFinder(fullSrcPath).findMethod(loc);
    }

    public SourceLine sourceLineOfMethodThatShouldMap(String className, String methodName, String fullSrcPath) {
        return new SourceLineFinder(fullSrcPath).findMethod(className, methodName);
    }

    public String method(Location loc) {
        return this.method(loc.method());
    }

    public void setOptions(Options options) {
        super.setOptions(options);
        if (options.isSet("workingdir")) {
            this.setWorkingdir(options.getOpt("workingdir"));
        }
    }

    public String method(Method method) {
        if (this.getOptions().isSet("nodemangle")) {
            return method.name();
        }
        return this.demangleMethodName(method.name());
    }

    public String name(Method method) {
        if (this.getOptions().isSet("nodemangle")) {
            return method.name();
        }
        return this.demangleMethodName(method.name());
    }

    public String name(ReferenceType refType) {
        return refType != null ? refType.name() : "null-name";
    }

    void handleBreakpointEvent(BreakpointEvent event) {
        try {
            SourceLine sl = this.sourceLine(event.location());
            if (!this.locationMaps(event.location())) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.handleBreakpointEvent(event);
    }

    void handleStepEvent(StepEvent event) {
        try {
            if (!this.locationMaps(event.location())) {
                String name = ((StepRequest)event.request()).getProperty("name") + "";
                if (name.equals("next")) {
                    this.nextCommand();
                    return;
                }
                if (name.equals("step")) {
                    this.stepCommand();
                    return;
                }
                if (name.equals("step up")) {
                    this.stepUpCommand();
                    return;
                }
                if (name.equals("stepi")) {
                    this.stepiCommand();
                    return;
                }
                this.error("Bad property!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.handleStepEvent(event);
    }

    public String demangleMethodName(String methodName) {
        String translatedMethodName = "";
        int idollar = methodName.indexOf("$");
        if (idollar == -1) {
            return methodName;
        }
        int iajc = methodName.indexOf(ajcToken);
        if (iajc != -1) {
            translatedMethodName = "<advice #";
            int i = iajc + ajcToken.length();
            while (i < methodName.length() && Character.isDigit(methodName.charAt(i))) {
                translatedMethodName = translatedMethodName + methodName.charAt(i);
                ++i;
            }
            translatedMethodName = translatedMethodName + ">";
        } else {
            translatedMethodName = methodName.substring(0, idollar);
        }
        return translatedMethodName;
    }

    public boolean isAdvice(String methodName) {
        return methodName.indexOf(ajcToken) != -1;
    }

    public String iter(List list) {
        return this.iter(list, new Formatter(){

            public String format(Object o) {
                return "  " + o;
            }
        });
    }

    public String fields(List fields) {
        String result = "";
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            try {
                result = result + field.type().name() + " " + field.name() + "\n";
            }
            catch (ClassNotLoadedException cnle) {
                // empty catch block
            }
        }
        return result;
    }

    public String methods(List methods) {
        String result = "";
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Method method = (Method)iter.next();
            String methString = method + "";
            int idot = method.declaringType().name().length();
            methString = methString.substring(0, idot) + ' ' + methString.substring(idot + 1);
            result = result + methString + "\n";
        }
        return result;
    }

    public String classes(List classes) {
        String result = "** classes list **";
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            result = result + "\n" + ((ReferenceType)iter.next()).name();
        }
        return result;
    }

    public String clazz(ReferenceType refType) {
        String result = "";
        if (refType instanceof ArrayReference) {
            result = "Array: " + refType.name();
        } else {
            String name = refType.name();
            result = "Class: " + name + "\n";
            try {
                Class<?> clazz = Class.forName(name);
                result = result + "extends: " + clazz.getSuperclass().getName() + "\n";
                Class<?>[] interfaces = clazz.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    result = result + "implements: " + interfaces[i].getName() + "\n";
                    ++i;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public String threads(List threads) {
        ThreadGroupReference threadGroupRef;
        String result = "";
        Iterator iter = threads.iterator();
        Hashtable<ThreadGroupReference, Vector<String[]>> threadHash = new Hashtable<ThreadGroupReference, Vector<String[]>>();
        String[][] cols = new String[threads.size()][3];
        int[] max = new int[3];
        int col = 0;
        while (iter.hasNext()) {
            ThreadReference threadRef = (ThreadReference)iter.next();
            threadGroupRef = threadRef.threadGroup();
            cols[col] = new String[3];
            cols[col][0] = "(" + threadRef.type().name() + ")" + this.toHex(threadRef.uniqueID());
            cols[col][1] = threadRef.name();
            cols[col][2] = AJDebugger.status(threadRef);
            int i = 0;
            while (i < max.length) {
                if (cols[col][i].length() > max[i]) {
                    max[i] = cols[col][i].length();
                }
                ++i;
            }
            Vector<String[]> v = (Vector<String[]>)threadHash.get(threadGroupRef);
            if (v == null) {
                v = new Vector<String[]>();
            }
            v.add(cols[col]);
            threadHash.put(threadGroupRef, v);
        }
        Enumeration keys = threadHash.keys();
        while (keys.hasMoreElements()) {
            threadGroupRef = (ThreadGroupReference)keys.nextElement();
            result = result + "Group " + threadGroupRef.name() + ":\n";
            Vector v = (Vector)threadHash.get(threadGroupRef);
            int i = 0;
            while (i < v.size()) {
                String[] stringCol = (String[])v.get(i);
                result = result + "   ";
                result = result + this.space(stringCol[0], max[0]) + " ";
                result = result + this.space(stringCol[1], max[1]) + " ";
                result = result + this.space(stringCol[2], max[2]) + "\n";
                ++i;
            }
        }
        return result;
    }

    public String space(String str, int length) {
        String result = str;
        int diff = length - str.length();
        int i = 0;
        while (i < diff) {
            result = result + " ";
            ++i;
        }
        return result;
    }

    public static String status(ThreadReference threadRef) {
        switch (threadRef.status()) {
            case -1: {
                return "unknown";
            }
            case 0: {
                return "zombie";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "sleeping";
            }
            case 3: {
                return "monitor";
            }
            case 4: {
                return "waiting";
            }
            case 5: {
                return "not started";
            }
        }
        return "?";
    }

    public List frames(ThreadReference threadRef) throws IncompatibleThreadStateException {
        Vector<StackFrame> frames = new Vector<StackFrame>();
        try {
            Iterator<StackFrame> iter = threadRef.frames().iterator();
            while (iter.hasNext()) {
                StackFrame frame = iter.next();
                if (!this.locationMaps(frame.location())) continue;
                frames.add(frame);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            // empty catch block
        }
        return frames;
    }

    public String frames(List frames) {
        String result = "";
        Iterator iter = frames.iterator();
        int i = 1;
        String tabs = "";
        int size = frames.size();
        while ((size /= 10) != 0) {
            tabs = tabs + " ";
        }
        while (iter.hasNext()) {
            block8: {
                result = result + "  [" + i++ + "] " + tabs;
                try {
                    Location loc = ((StackFrame)iter.next()).location();
                    result = result + this.name(loc.declaringType()) + "." + this.name(loc.method()) + " ";
                    try {
                        String sourceName = this.sourceName(loc);
                        int lineNumber = this.lineNumber(loc);
                        if (lineNumber == -2) {
                            result = result + "(" + sourceName + ")";
                            break block8;
                        }
                        if (lineNumber != -1) {
                            result = result + "(" + sourceName + ":" + lineNumber + ")";
                            break block8;
                        }
                        result = result + "[class " + loc.declaringType().name() + "]";
                    }
                    catch (AbsentInformationException aie) {}
                }
                catch (InvalidStackFrameException isfe) {
                    result = result + "<thread resumed>";
                }
            }
            result = result + "\n";
        }
        return result;
    }

    public String threadGroups(List threadGroups) {
        String result = "";
        Iterator iter = threadGroups.iterator();
        int i = 1;
        while (iter.hasNext()) {
            ThreadGroupReference ref = (ThreadGroupReference)iter.next();
            result = result + i++ + ". (" + ref.type().name() + ")" + this.toHex(ref.uniqueID()) + " " + ref.name() + "\n";
        }
        return result;
    }

    public String toHex(long l) {
        return "0x" + Long.toHexString(l);
    }

    public String sourceLines(List sourceLines) {
        return this.sourceLines(sourceLines, false);
    }

    public String sourceLines(List sourceLines, boolean arrow) {
        return this.iter(sourceLines, new SourceLinesFormatter(arrow));
    }

    public String sourceLine(SourceManager.SourceLine sl) {
        Vector<SourceManager.SourceLine> v = new Vector<SourceManager.SourceLine>(1);
        v.add(sl);
        return this.sourceLines(v);
    }

    public String locals(List locals) {
        if (locals == null || locals.size() == 0) {
            return "No local variables";
        }
        String result = "";
        Iterator iter = locals.iterator();
        Vector<LocalVariable> args = new Vector<LocalVariable>();
        Vector<LocalVariable> vars = new Vector<LocalVariable>();
        while (iter.hasNext()) {
            LocalVariable local = (LocalVariable)iter.next();
            if (local.isArgument()) {
                args.add(local);
                continue;
            }
            vars.add(local);
        }
        result = result + "Method arguments:";
        int i = 0;
        while (i < args.size()) {
            result = result + "\n" + this.local((LocalVariable)args.get(i));
            ++i;
        }
        result = result + (args.size() < 1 ? "\n" : "") + "Local variables:";
        int i2 = 0;
        while (i2 < vars.size()) {
            result = result + "\n" + this.local((LocalVariable)vars.get(i2));
            ++i2;
        }
        return result;
    }

    public String local(LocalVariable local) {
        String result = "  " + local.name();
        try {
            StackFrame frame = this.getDefaultFrame();
            result = result + " = " + frame.getValue(local);
        }
        catch (NoVMException nvme) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public String iter(List list, Formatter f) {
        String str = "";
        boolean newline = false;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            str = str + (newline ? "\n" : "") + f.format(iter.next());
            newline = true;
        }
        return str;
    }

    public String format(ExceptionEvent e) {
        String str = e.exception().referenceType().name();
        Location loc = e.catchLocation();
        str = str + " (";
        str = str + (loc == null ? "uncaught" : "to be caught at: " + this.format(loc, e.thread()));
        str = str + ")";
        str = str + "\n" + this.format((LocatableEvent)e);
        ObjectReference exception = e.exception();
        try {
            ThreadReference thread = this.threads.getThread();
            List<Method> methods = exception.referenceType().methodsByName("printStackTrace");
            Iterator<Method> iter = methods.iterator();
            while (iter.hasNext()) {
                Method method = iter.next();
                List<String> argumentTypeNames = method.argumentTypeNames();
                if (argumentTypeNames.size() != 0) continue;
                Vector arguments = new Vector();
                int options = 1;
                exception.invokeMethod(thread, method, arguments, options);
                break;
            }
        }
        catch (DebuggerException de) {
        }
        catch (InvalidTypeException ite) {
        }
        catch (ClassNotLoadedException cnle) {
        }
        catch (IncompatibleThreadStateException itse) {
        }
        catch (InvocationException ie) {
            // empty catch block
        }
        return str;
    }

    public String format(LocatableEvent e) {
        return this.format(e.location(), e.thread());
    }

    public String format(Location loc, ThreadReference thread) {
        int lineNumber = this.lineNumber(loc);
        String method = this.method(loc);
        long codeIndex = loc.codeIndex();
        String str = "thread=\"" + thread.name() + "\", " + loc.declaringType().name() + "." + method + "()" + (lineNumber > 0 ? ", line=" + lineNumber : "") + (codeIndex >= 0L ? ", bci=" + codeIndex : "");
        try {
            String smsl;
            SourceLine sl = this.sourceLine(loc);
            if (sl != null && sl.line > 0 && !(smsl = this.sourceLine(this.getSourceManager().getSourceLine(sl.filename, sl.line - 1))).startsWith("null")) {
                str = str + "\n" + smsl;
            }
        }
        catch (AbsentInformationException aie) {
            // empty catch block
        }
        return str;
    }

    public String strip(String sourceName) {
        int islash = sourceName.lastIndexOf(File.separator);
        if (islash == -1) {
            islash = sourceName.lastIndexOf(47);
        }
        if (islash == -1) {
            islash = sourceName.lastIndexOf(92);
        }
        if (islash != -1) {
            return sourceName.substring(islash + 1);
        }
        return sourceName;
    }

    public String methodName(LocatableEvent e) {
        return this.method(e.location());
    }

    public static String d() {
        return "AJDebugger";
    }

    public String toString() {
        return AJDebugger.d();
    }

    public String toLongString() {
        Object[] objects = new Object[]{"Sourcepath", this.getSourcePath(), "Workingdir", this.getWorkingdir(), "Running class", this.runningClass, "Status", this.status, "Old class", this.oldClass, "Old VM args", this.oldVmArgs, "Old command line", this.oldCommandLine};
        return this.format(this.map(objects));
    }

    private Map map(Object[] objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int i = 0;
        while (i < objects.length) {
            map.put(objects[i], objects[i + 1]);
            i += 2;
        }
        return map;
    }

    private String format(Map map) {
        Iterator<Object> iter = map.keySet().iterator();
        Vector<String> keys = new Vector<String>();
        Vector<String> vals = new Vector<String>();
        while (iter.hasNext()) {
            Object keyObj = iter.next();
            String key = keyObj + "";
            String val = map.get(keyObj) + "";
            keys.add(key);
            vals.add(val);
        }
        int longest = -1;
        iter = keys.iterator();
        while (iter.hasNext()) {
            int length = (iter.next() + "").length();
            if (length <= longest) continue;
            longest = length;
        }
        String str = "----------------------------------------------------------------------\n";
        int i = 0;
        while (i < keys.size()) {
            String key = keys.get(i) + "";
            String val = vals.get(i) + "";
            while (key.length() < longest) {
                key = key + " ";
            }
            str = str + key + "  : " + val + "\n";
            ++i;
        }
        str = str + "----------------------------------------------------------------------\n";
        return str;
    }

    class SourceLinesFormatter
    implements Formatter {
        final int tabs = 10;
        final boolean arrow;

        public SourceLinesFormatter(boolean arrow) {
            this.arrow = arrow;
        }

        public String format(Object o) {
            if (!(o instanceof SourceManager.SourceLine)) {
                return o + "";
            }
            SourceManager.SourceLine sl = (SourceManager.SourceLine)o;
            String lineString = sl.getLineString();
            int lineNumber = sl.getLineNumber();
            String result = "";
            if (lineNumber > 0) {
                result = result + lineNumber + " ";
                result = lineNumber < 10 ? result + "      " : (lineNumber < 100 ? result + "     " : (lineNumber < 1000 ? result + "    " : (lineNumber < 10000 ? result + "   " : (lineNumber < 100000 ? result + "  " : result + "           "))));
                result = result + (AJDebugger.this.isStopped(sl) && this.arrow ? "=>" : "  ");
                result = result + lineString;
            }
            return result;
        }
    }

    static interface Formatter {
        public String format(Object var1);
    }

    public static class NonMappingOutputLineException
    extends DebuggerException {
        public NonMappingOutputLineException(String outputFile, int line) {
            super("The following does not map to an executable source line: " + outputFile + "::" + line);
        }
    }

    public static class NonMappingSourceLineException
    extends DebuggerException {
        public NonMappingSourceLineException(String source, int line) {
            super("The following does not map to an executable output line: " + source + "::" + line);
        }
    }
}

