/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.EventRequest;
import java.util.Iterator;
import org.aspectj.debugger.base.Debug;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.NoVMException;

public class EventSpinner
implements Runnable {
    private Thread runner;
    private EventQueue eventQueue;
    private Debugger debugger;
    private boolean isRunning;
    private boolean isDone;
    boolean printThreads = false;

    public EventSpinner(Debugger debugger) {
        this.debugger = debugger;
    }

    public void start() {
        Debug.debug(this, "Starting the event queue");
        try {
            this.eventQueue = this.debugger.getVM().eventQueue();
            this.isRunning = true;
            this.runner = new Thread(this);
            this.runner.start();
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block26: {
            iter = null;
            disconnect = false;
            try {
                while (this.isRunning) {
                    eventSet = this.eventQueue.remove();
                    this.handle(eventSet);
                }
            }
            catch (InterruptedException ie) {
                var7_7 = null;
                try {
                    eventSet = null;
                    while ((eventSet = this.eventQueue.remove(10L)) != null) {
                        this.handle(eventSet);
                    }
                }
                catch (InterruptedException ie) {
                }
                catch (VMDisconnectedException vmde) {
                    disconnect = true;
                }
                break block26;
            }
            catch (VMDisconnectedException vmde) {
                disconnect = true;
                vmde.getMessage();
                var7_8 = null;
                ** try [egrp 2[TRYBLOCK] [4, 5 : 90->123)] { 
lbl31:
                // 1 sources

                eventSet = null;
                while ((eventSet = this.eventQueue.remove(10L)) != null) {
                    this.handle(eventSet);
                }
                break block26;
lbl36:
                // 1 sources

                catch (InterruptedException ie) {
                }
lbl38:
                // 1 sources

                catch (VMDisconnectedException vmde) {
                    disconnect = true;
                }
                break block26;
            }
            catch (Exception e) {
                this.debugger.app().handleInternalException(e);
                var7_9 = null;
                ** try [egrp 2[TRYBLOCK] [4, 5 : 90->123)] { 
lbl46:
                // 1 sources

                eventSet = null;
                while ((eventSet = this.eventQueue.remove(10L)) != null) {
                    this.handle(eventSet);
                }
                break block26;
lbl51:
                // 1 sources

                catch (InterruptedException ie) {
                }
lbl53:
                // 1 sources

                catch (VMDisconnectedException vmde) {
                    disconnect = true;
                }
                break block26;
            }
            var7_6 = null;
            {
                catch (Throwable var6_28) {
                    var7_10 = null;
                    ** try [egrp 2[TRYBLOCK] [4, 5 : 90->123)] { 
lbl62:
                    // 1 sources

                    eventSet = null;
                    while (true) {
                        if ((eventSet = this.eventQueue.remove(10L)) == null) {
                            throw var6_28;
                        }
                        this.handle(eventSet);
                    }
lbl68:
                    // 1 sources

                    catch (InterruptedException ie) {
                        throw var6_28;
                    }
lbl70:
                    // 1 sources

                    catch (VMDisconnectedException vmde) {
                        disconnect = true;
                        throw var6_28;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [4, 5 : 90->123)] { 
lbl74:
                // 1 sources

                eventSet = null;
                while ((eventSet = this.eventQueue.remove(10L)) != null) {
                    this.handle(eventSet);
                }
lbl79:
                // 1 sources

                catch (InterruptedException ie) {
                }
lbl81:
                // 1 sources

                catch (VMDisconnectedException vmde) {}
                disconnect = true;
            }
        }
        try {
            this.isDone = true;
            this.notifyAll();
            return;
        }
        catch (IllegalMonitorStateException var3_5) {
            // empty catch block
        }
    }

    private void handle(EventSet set) throws VMDisconnectedException {
        if (set == null) {
            return;
        }
        try {
            EventIterator iter = set.eventIterator();
            boolean resume = false;
            this.printThreads(true);
            while (iter.hasNext()) {
                Event event = iter.nextEvent();
                resume |= this.debugger.handle(event);
            }
            if (resume) {
                this.debugger.getVM().resume();
            }
            this.printThreads(false);
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
    }

    void printThreads(boolean before) {
        try {
            if (!this.printThreads) {
                return;
            }
            Iterator<ThreadReference> threadIter = this.debugger.getVM().allThreads().iterator();
            System.out.print((before ? "BEFORE" : "AFTER") + ": ");
            while (threadIter.hasNext()) {
                ThreadReference threadRef = threadIter.next();
                System.out.print("(" + threadRef.uniqueID() + "):" + threadRef.suspendCount() + ", ");
            }
            System.out.println();
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
    }

    public void shutDown() {
        this.isRunning = false;
        if (this.runner != null) {
            this.runner.interrupt();
        }
        while (!this.isDone) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
            }
            catch (IllegalMonitorStateException imse) {
                return;
            }
        }
    }

    class DummyVMDisconnectEvent
    implements VMDisconnectEvent {
        DummyVMDisconnectEvent() {
        }

        public String toString() {
            return "Dummy VMDisconnectEvent: vm=" + EventSpinner.this.debugger.vm();
        }

        public VirtualMachine virtualMachine() {
            return EventSpinner.this.debugger.vm();
        }

        public EventRequest request() {
            return null;
        }
    }
}

