/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.request.BreakpointRequestAction;

public class SourceManager {
    private Debugger debugger;
    private String sourcePath;

    public SourceManager(Debugger debugger) {
        this(debugger, ".");
    }

    public SourceManager(Debugger debugger, String sourcePath) {
        this.debugger = debugger;
        try {
            this.sourcePath = new File(sourcePath).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSourcePath(String sourcePath) {
        try {
            File file = new File(sourcePath);
            if (file.exists()) {
                this.sourcePath = file.getCanonicalPath();
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sourcePath = sourcePath;
        if (this.debugger.getOptions().isSet("extra")) {
            this.debugger.error("The path " + sourcePath + " does not exist");
            this.showPossiblePaths(sourcePath);
        }
    }

    private void showPossiblePaths(String sourcePath) {
        Iterator iter = this.getPossiblePaths(sourcePath).iterator();
        if (!iter.hasNext()) {
            this.debugger.error("There are no possible paths");
            return;
        }
        String error = "Possible paths are:\n";
        while (iter.hasNext()) {
            error = error + "\n  " + iter.next();
        }
        this.debugger.error(error);
    }

    private List getPossiblePaths(String sourcePath) {
        Vector<File> completions = new Vector<File>();
        int isep1 = sourcePath.lastIndexOf(File.separatorChar);
        int isep2 = sourcePath.lastIndexOf(47);
        int isep3 = sourcePath.lastIndexOf(92);
        int ilastSep = -1;
        ilastSep = isep1 >= isep2 && isep1 >= isep3 ? isep1 : (isep2 >= isep1 && isep2 >= isep3 ? isep2 : (isep3 >= isep2 && isep3 >= isep2 ? isep3 : isep1));
        if (ilastSep == -1) {
            return completions;
        }
        File file = new File(sourcePath.substring(0, ilastSep + 1) + ".");
        File parent = file.getParentFile();
        if (!parent.exists()) {
            return completions;
        }
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File _file) {
                return _file.isDirectory();
            }
        });
        int i = 0;
        while (i < files.length) {
            completions.add(files[i]);
            ++i;
        }
        return completions;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public List getSourceLines(String sourceName) {
        Vector<SourceLine> list = new Vector<SourceLine>();
        LineNumberReader in = this.getReader(sourceName);
        if (in == null) {
            return list;
        }
        try {
            String lineString = "";
            int lineNumber = -1;
            while ((lineNumber = in.getLineNumber()) != -1 && (lineString = in.readLine()) != null) {
                list.add(new SourceLine(sourceName, lineString, lineNumber));
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return list;
    }

    public String getLine(String sourceName, int lineNumber) {
        return this.getSourceLine((String)sourceName, (int)lineNumber).lineString;
    }

    /*
     * Unable to fully structure code
     */
    public List getSourceLines(String sourceName, int startLine, int endLine) throws DebuggerException {
        lines = new Vector<SourceLine>();
        lines.add(this.emptySourceLine());
        in = this.getReader(sourceName);
        if (in == null) {
            return lines;
        }
        if (startLine <= endLine) ** GOTO lbl15
        throw new DebuggerException("Start line must be greater than the end line.");
lbl-1000:
        // 1 sources

        {
            try {
                in.readLine();
                continue;
            }
            catch (IOException ioe) {
                return lines;
            }
lbl15:
            // 2 sources

            ** while (in.getLineNumber() < startLine)
        }
lbl16:
        // 1 sources

        lines = new Vector<E>();
        num = -1;
        lineStr = "";
        try {
            while ((lineStr = in.readLine()) != null && (num = in.getLineNumber()) <= endLine) {
                lines.add(new SourceLine(sourceName, lineStr, num - 1));
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return lines;
    }

    /*
     * Unable to fully structure code
     */
    public SourceLine getSourceLine(String sourceName, int lineNumber) {
        sl = this.emptySourceLine();
        in = this.getReader(sourceName);
        if (in != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            try {
                in.readLine();
                continue;
            }
            catch (IOException ioe) {
                return null;
            }
lbl11:
            // 2 sources

            ** while (in.getLineNumber() < lineNumber)
        }
lbl12:
        // 1 sources

        line = "";
        try {
            line = in.readLine();
            sl = new SourceLine(sourceName, line, lineNumber);
            in.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return sl;
    }

    private LineNumberReader getReader(String relativeFileName) {
        LineNumberReader in = null;
        try {
            if (relativeFileName != null) {
                in = new LineNumberReader(new FileReader(this.resolve(relativeFileName)));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return in;
    }

    public File getFile(String relativeFileName) {
        String fullName = this.resolve(relativeFileName);
        File file = new File(fullName);
        return file;
    }

    private String resolve(String fileName) {
        return this.resolve(fileName, this.debugger.getFilePaths());
    }

    private String resolve(String fileName, List filePaths) {
        Iterator iter = filePaths.iterator();
        while (iter.hasNext()) {
            String filePath = iter.next() + "";
            String fullName = fileName;
            if (!fullName.startsWith(this.getSourcePath())) {
                fullName = this.sourcePath + File.separator + (filePath.equals("") ? "" : File.separator) + fileName;
            }
            try {
                File file = new File(fullName);
                if (!file.exists()) continue;
                return file.getCanonicalPath();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return fileName;
    }

    private SourceLine emptySourceLine() {
        return new SourceLine("<not available>", "", -1);
    }

    public static class SourceLine {
        public String sourceName = "";
        public String lineString = "";
        public int lineNumber = -1;
        public static final String tab = "    ";
        private static char c;
        private boolean hasBreakpoint = false;
        private boolean isBreakpoint = false;
        private BreakpointRequestAction request;
        private boolean isExecutable = false;
        private String className = null;
        public static final SourceLine emptyLine;
        public static final int NONE = 0;
        public static final int UNVERIFIED = 1;
        public static final int VERIFIED = 2;
        private int status = 0;
        private LineUpdatable updater;

        public void setUpdater(LineUpdatable updater) {
            this.updater = updater;
        }

        private void update() {
            if (this.updater != null) {
                this.updater.update(this.getLineNumber());
            }
        }

        public SourceLine(String sourceName, String lineString, int lineNumber) {
            this.sourceName = sourceName;
            this.lineNumber = lineNumber + 1;
            this.lineString = this.expandTabs(lineString);
        }

        public String toString() {
            return this.sourceName + ":" + this.lineNumber + ": " + this.lineString;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String getLineString() {
            return this.lineString;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setStatus(int status) {
            this.status = status;
            this.update();
        }

        public int getStatus() {
            return this.status;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setRequest(BreakpointRequestAction request) {
            this.request = request;
            request.setSourceLine(this);
        }

        public boolean hasBreakpoint() {
            return this.status != 0;
        }

        public void clear() {
            this.setStatus(0);
        }

        public void unverify(BreakpointRequestAction request) {
            this.setRequest(request);
            this.setStatus(1);
        }

        public void verify(BreakpointRequestAction request) {
            this.setRequest(request);
            this.setStatus(2);
        }

        public void ex(String className) {
            this.setExecutable(true, className);
        }

        public void unex() {
            this.setExecutable(false);
        }

        public void setExecutable(boolean isExecutable) {
            this.setExecutable(isExecutable, null);
        }

        public void setExecutable(boolean isExecutable, String className) {
            this.isExecutable = isExecutable;
            this.setClassName(className);
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public BreakpointRequestAction getRequest() {
            return this.request;
        }

        private String expandTabs(String line) {
            char[] chars = line.toCharArray();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < chars.length) {
                c = chars[i];
                buf.append(c == '\t' ? tab : c + "");
                ++i;
            }
            return buf.toString();
        }

        static {
            emptyLine = new SourceLine("<not-available>", "", 0);
        }
    }

    public static interface LineUpdatable {
        public void update(int var1);
    }
}

