/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.Iterator;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.NoVMException;

class Threads {
    private ThreadReference threadRef;
    private ThreadGroupReference threadGroupRef;
    private int frame;
    private Debugger debugger;
    private ThreadReference stoppedThreadRef;

    Threads(Debugger debugger) {
        this.debugger = debugger;
    }

    void flush() {
        this.threadRef = null;
        this.threadGroupRef = null;
        this.frame = 0;
        this.stoppedThreadRef = null;
    }

    ThreadReference setThread(ThreadReference threadRef) {
        this.threadRef = threadRef;
        return this.threadRef;
    }

    ThreadGroupReference setThreadGroup(ThreadGroupReference threadGroupRef) {
        this.threadGroupRef = threadGroupRef;
        return this.threadGroupRef;
    }

    int setFrame(int frame) {
        this.frame = frame;
        return this.frame;
    }

    ThreadReference setStoppedThread(ThreadReference stoppedThreadRef) {
        this.stoppedThreadRef = stoppedThreadRef;
        return this.stoppedThreadRef;
    }

    ThreadReference getThread() throws NoVMException {
        if (this.threadRef == null) {
            Iterator<ThreadReference> iter = this.debugger.getVM().allThreads().iterator();
            if (iter.hasNext()) {
                this.threadRef = iter.next();
                return this.threadRef;
            }
        }
        return this.threadRef;
    }

    ThreadGroupReference getThreadGroup() throws NoVMException {
        if (this.threadGroupRef == null) {
            Iterator<ThreadGroupReference> iter = this.debugger.getVM().topLevelThreadGroups().iterator();
            if (iter.hasNext()) {
                this.threadGroupRef = iter.next();
                return this.threadGroupRef;
            }
        }
        return this.threadGroupRef;
    }

    int getFrame() {
        return this.frame;
    }

    StackFrame getStackFrame() throws NoVMException {
        StackFrame stackFrame = null;
        try {
            stackFrame = this.getThread().frame(this.frame);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        return stackFrame;
    }

    ThreadReference getStoppedThread() throws NoVMException {
        if (this.stoppedThreadRef == null) {
            Iterator<ThreadReference> iter = this.debugger.getVM().allThreads().iterator();
            while (iter.hasNext()) {
                ThreadReference threadRef = iter.next();
                if (!threadRef.isAtBreakpoint()) continue;
                this.stoppedThreadRef = threadRef;
                return this.stoppedThreadRef;
            }
        }
        return this.stoppedThreadRef;
    }
}

