/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ReferenceType;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJLineMapper;
import org.aspectj.debugger.gui.AdviceNode;
import org.aspectj.debugger.gui.AdvisableMethodNode;
import org.aspectj.debugger.gui.ClassNode;
import org.aspectj.debugger.gui.MethodNode;
import org.aspectj.tools.ide.Declaration;
import org.aspectj.tools.ide.SymbolManager;

public class AJCClassNode
extends ClassNode {
    private String name;
    private Declaration classDec;
    private boolean isAspect;

    public AJCClassNode(String name) {
        this(null, name);
    }

    public AJCClassNode(Declaration classDec) {
        super(null);
        this.classDec = classDec;
        this.init(null, classDec.getSignature());
    }

    public AJCClassNode(ReferenceType refType) {
        this(refType, refType.name());
    }

    private AJCClassNode(ReferenceType refType, String name) {
        super(refType);
        this.init(refType, name);
    }

    private void init(ReferenceType refType, String name) {
        this.name = name;
        this.addKids();
    }

    protected String name() {
        return this.name;
    }

    protected String packageName() {
        return this.classDec.getPackageName();
    }

    protected boolean callsAddKids() {
        return true;
    }

    public int getType() {
        if (this.isAspect) {
            return AJIcons.ASPECT_ICON;
        }
        if (this.kind().equals("class")) {
            return AJIcons.CLASS_ICON;
        }
        return AJIcons.INTERFACE_ICON;
    }

    public void addMethods() {
        if (this.name == null) {
            return;
        }
        if (this.classDec == null) {
            String fileName = AJLineMapper.getSourceFilePathFromAJCClass(this.name);
            if (fileName == null) {
                return;
            }
            Declaration[] decs = SymbolManager.getSymbolManager().getDeclarations(fileName);
            this.classDec = this.classDec(decs);
        }
        if (this.classDec == null) {
            return;
        }
        this.addMethods(this.classDec);
        this.addAdvices(this.classDec);
    }

    public static AJCClassNode[] makeNodes(String fileName) {
        Declaration[] decs = SymbolManager.getSymbolManager().getDeclarations(fileName);
        if (decs == null) {
            return new AJCClassNode[0];
        }
        Vector<AJCClassNode> classNodes = new Vector<AJCClassNode>();
        int i = 0;
        while (i < decs.length) {
            Declaration dec = decs[i];
            if (dec != null) {
                classNodes.add(new AJCClassNode(dec));
            }
            ++i;
        }
        int N = classNodes.size();
        AJCClassNode[] nodes = new AJCClassNode[N];
        int i2 = 0;
        Iterator iter = classNodes.iterator();
        while (iter.hasNext() && i2 < N) {
            nodes[i2] = (AJCClassNode)iter.next();
            ++i2;
        }
        return nodes;
    }

    public String getName() {
        return this.name;
    }

    private void addAdvices(Declaration classDec) {
        this.addAdvices(classDec.getDeclarations());
    }

    private void addAdvices(Declaration[] decs) {
        if (decs == null) {
            return;
        }
        int i = 0;
        while (i < decs.length) {
            Declaration dec = decs[i];
            if (dec != null && dec.getKind().equals("advice")) {
                this.addAdvice(dec);
            }
            ++i;
        }
    }

    private void addMethods(Declaration classDec) {
        this.addMethods(classDec.getDeclarations());
    }

    private void addMethods(Declaration[] decs) {
        if (decs == null) {
            return;
        }
        int i = 0;
        while (i < decs.length) {
            Declaration dec = decs[i];
            if (dec != null && this.isMethod(dec)) {
                this.addMethod(dec);
            }
            ++i;
        }
    }

    private boolean isMethod(Declaration dec) {
        return dec.getKind().equals("method") || dec.getKind().equals("constructor");
    }

    private void addAdvice(Declaration dec) {
        AdviceNode adviceNode = new AdviceNode(dec);
        this.add(adviceNode);
        this.isAspect = true;
        this.addMethods(adviceNode, dec);
    }

    private void addMethod(Declaration dec) {
        if (dec == null) {
            return;
        }
        AdvisableMethodNode methodNode = new AdvisableMethodNode(dec);
        this.add(methodNode);
        this.addAdvice(methodNode, dec);
    }

    private void addMethods(AdviceNode adviceNode, Declaration dec) {
        Declaration[] pointsTo = dec.getPointsTo();
        if (pointsTo == null) {
            return;
        }
        int i = 0;
        while (i < pointsTo.length) {
            Declaration methodDec = pointsTo[i];
            if (methodDec != null) {
                AdvisableMethodNode methodNode = new AdvisableMethodNode(methodDec);
                adviceNode.add(methodNode);
            }
            ++i;
        }
    }

    private void addAdvice(MethodNode methodNode, Declaration dec) {
        Declaration[] pointedToBy = dec.getPointedToBy();
        if (pointedToBy == null) {
            return;
        }
        int i = 0;
        while (i < pointedToBy.length) {
            Declaration advice = pointedToBy[i];
            if (advice != null) {
                AdviceNode adviceNode = new AdviceNode(advice);
                methodNode.add(adviceNode);
            }
            ++i;
        }
    }

    private Declaration classDec(Declaration[] decs) {
        if (decs == null) {
            return null;
        }
        Vector<Declaration> q = new Vector<Declaration>();
        int i = 0;
        while (i < decs.length) {
            q.add(decs[i]);
            ++i;
        }
        while (!q.isEmpty()) {
            Declaration dec = (Declaration)q.remove(0);
            if (dec == null || !this.isType(dec)) continue;
            String signature = dec.getSignature();
            String packageName = dec.getPackageName();
            String fullSignature = packageName != null && !"".equals(packageName) ? packageName + "." + signature : signature;
            if ((fullSignature = fullSignature.trim()).equals(this.name)) {
                return dec;
            }
            Declaration[] newDecs = dec.getDeclarations();
            if (newDecs == null) continue;
            int i2 = 0;
            while (i2 < newDecs.length) {
                q.add(newDecs[i2]);
                ++i2;
            }
        }
        while (!q.isEmpty()) {
        }
        return null;
    }

    private boolean isType(Declaration dec) {
        return dec.getKind().equals("class") || dec.getKind().equals("interface");
    }

    protected String kind() {
        if (this.isAspect) {
            return "aspect";
        }
        if (this.classDec == null) {
            return "class";
        }
        return this.classDec.getKind();
    }

    public String getRelativePath() {
        return this.classDec.getFilename();
    }

    public int getLine() {
        return this.classDec.getBeginLine();
    }

    public List getAdviceStrings() {
        if (!this.isAspect) {
            return null;
        }
        Vector<String> adviceStrings = new Vector<String>();
        if (this.children == null) {
            return adviceStrings;
        }
        Iterator iter = ((AbstractList)this.children).iterator();
        while (iter.hasNext()) {
            TreeNode treeNode = (TreeNode)iter.next();
            if (!(treeNode instanceof AdviceNode)) continue;
            adviceStrings.add(((AdviceNode)treeNode).getBreakpoint());
        }
        return adviceStrings;
    }
}

