/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.aspectj.debugger.gui.AJValueGetter;
import org.aspectj.debugger.gui.FieldGetter;
import org.aspectj.debugger.gui.Util;

public class AJMemberValueGetter
implements AJValueGetter,
FieldGetter {
    private ObjectReference parent = null;
    private Field field = null;

    public AJMemberValueGetter(ObjectReference parent, Field field) {
        this.parent = parent;
        this.field = field;
    }

    public Value getValue() {
        return this.parent.getValue(this.field);
    }

    public Value getValue(String s) {
        return this.parent.getValue(this.field);
    }

    public void setValue(Value v) throws ClassNotLoadedException, InvalidTypeException {
        this.parent.setValue(this.field, v);
    }

    public ThreadReference getThread() throws ClassNotLoadedException {
        try {
            return this.parent.owningThread();
        }
        catch (Exception e) {
            Util.ex(e);
            return null;
        }
    }

    public String getName() {
        return this.refType().name() + "." + this.field.name();
    }

    public Type getTypeRef() throws ClassNotLoadedException {
        return this.field.type();
    }

    public String getTypeName() throws ClassNotLoadedException {
        return "" + this.field.type();
    }

    public ReferenceType getDeclaringClass() {
        return this.field.declaringType();
    }

    public Field getField() {
        return this.field;
    }

    private ReferenceType refType() {
        return this.parent.referenceType();
    }
}

