/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.aspectj.debugger.gui.AJValueGetter;
import org.aspectj.debugger.gui.FieldGetter;

public class AJReferenceTypeMemberValueGetter
implements AJValueGetter,
FieldGetter {
    private ReferenceType refType;
    private Field field;

    public AJReferenceTypeMemberValueGetter(ReferenceType refType, Field field) {
        this.refType = refType;
        this.field = field;
    }

    public Value getValue() {
        return this.refType.getValue(this.field);
    }

    public Value getValue(String s) {
        return this.getValue();
    }

    public void setValue(Value v) throws ClassNotLoadedException, InvalidTypeException {
        this.refType.classObject().setValue(this.field, v);
    }

    public ThreadReference getThread() throws ClassNotLoadedException, IncompatibleThreadStateException {
        return this.refType.classObject().owningThread();
    }

    public String getName() {
        return this.refType.name() + "." + this.field.name();
    }

    public Type getTypeRef() throws ClassNotLoadedException {
        return this.field.type();
    }

    public String getTypeName() throws ClassNotLoadedException {
        return this.getTypeRef().name();
    }

    public ReferenceType getDeclaringClass() {
        return this.refType;
    }

    public Field getField() {
        return this.field;
    }
}

