/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.gui.AJDataFlavor;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJRootNode;
import org.aspectj.debugger.gui.AJThreadGroupNode;
import org.aspectj.debugger.gui.AJThreadGroupTreeMouseListener;
import org.aspectj.debugger.gui.AJThreadNode;
import org.aspectj.debugger.gui.AJTree;
import org.aspectj.debugger.gui.AJTreeCellRenderer;
import org.aspectj.debugger.gui.AJTreeModel;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.AJValueNode;
import org.aspectj.debugger.gui.AJValueWrapper;
import org.aspectj.debugger.gui.NoCollapsingRootExpansionListener;
import org.aspectj.debugger.gui.Util;

public class AJThreadGroupTree
extends AJTree
implements DropTargetListener,
DragSourceListener,
DragGestureListener,
Serializable {
    public Map threadNodes = new HashMap();
    DropTarget dropTarget = null;
    DragSource dragSource = null;

    public AJThreadGroupTree() {
        AJRootNode root = this.root();
        AJTreeModel model = new AJTreeModel(root);
        AJTreeCellRenderer rend = new AJTreeCellRenderer();
        this.setRoot(root);
        this.setModel(model);
        this.setCellRenderer(rend);
        this.addMouseListener(new AJThreadGroupTreeMouseListener(this));
        this.addTreeWillExpandListener(new NoCollapsingRootExpansionListener(this));
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public boolean add(ThreadReference ref) {
        boolean result = false;
        try {
            if (this.threadNodes.containsKey(ref)) {
                return false;
            }
            MutableTreeNode treeNode = this.addToRoot(ref);
            result = true;
        }
        catch (Exception e) {
            Util.ex(e);
        }
        return result;
    }

    private MutableTreeNode addToRoot(ThreadReference ref) {
        List list = this.findParent(ref);
        boolean expand = this.getRoot().getChildCount() == 0;
        AJTreeNode newNode = this.getRoot().add(list);
        if (expand) {
            this.expandRow(0);
        }
        this.threadNodes.put(ref, newNode);
        return newNode;
    }

    public void expandToFrame(StackFrame frame) {
        TreePath path = this.pathToFrame(frame);
        this.expand(path);
    }

    private void expand(TreePath path) {
        if (path != null) {
            Object o = path.getLastPathComponent();
            TreePath newPath = null;
            if (o instanceof AJThreadNode) {
                AJThreadNode threadNode = (AJThreadNode)o;
                threadNode.showKids();
                int i = threadNode.getChildCount();
                if (i > 0) {
                    newPath = path.pathByAddingChild((AJTreeNode)threadNode.getChildAt(i - 1));
                }
            }
            System.out.println("expand path:" + path);
            this.scrollPathToVisible(newPath != null ? newPath : path);
            this.setSelectionPath(path);
        }
    }

    AJThreadNode threadNode(long id) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            AJThreadNode threadNode;
            TreeNode next = enumeration.nextElement();
            if (!(next instanceof AJThreadNode) || (threadNode = (AJThreadNode)next).getId() != id) continue;
            return threadNode;
        }
        return null;
    }

    private TreePath pathToFrame(StackFrame frame) {
        TreePath path = null;
        try {
            ThreadReference ref = frame.thread();
            long id = ref.uniqueID();
            AJThreadNode node = this.threadNode(id);
            if (node != null) {
                Object[] nodes = node.getPath();
                path = new TreePath(nodes);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return path;
    }

    public void expandToLocals(StackFrame frame) {
        TreePath path = this.pathToFrame(frame);
        if (path == null) {
            return;
        }
        AJTreeNode node = (AJTreeNode)path.getLastPathComponent();
        if (node.getChildCount() > 0) {
            path = path.pathByAddingChild(node.getChildAt(0));
        }
        this.expand(path);
    }

    public void expandToValue(Value value, String name) {
        Enumeration<TreeNode> nodes = ((AJRootNode)this.getModel().getRoot()).breadthFirstEnumeration();
        if (nodes == null) {
            return;
        }
        AJTreeNode node = null;
        while (nodes.hasMoreElements()) {
            AJValueNode vnode;
            Value val;
            node = (AJTreeNode)nodes.nextElement();
            if (node instanceof AJValueNode && (val = (vnode = (AJValueNode)node).getValue()) != null && val.equals(value) && vnode.getName().equals(name)) break;
        }
        if (node == null) {
            return;
        }
        TreePath path = new TreePath(node.getPath());
        if (node.getChildCount() > 0) {
            path = path.pathByAddingChild(node.getChildAt(0));
        }
        this.expand(path);
    }

    public boolean remove(ThreadReference ref) {
        if (!this.threadNodes.containsKey(ref)) {
            return false;
        }
        List list = this.findParent(ref);
        AJTreeNode removedNode = this.getRoot().remove(list);
        this.threadNodes.remove(removedNode);
        this.modernize();
        return true;
    }

    public void validateThreadNodes() {
        block3: {
            try {
                Iterator iter = this.threadNodes.values().iterator();
                while (iter.hasNext()) {
                    AJThreadNode node = (AJThreadNode)iter.next();
                    AJTreeModel model = (AJTreeModel)this.getModel();
                    node.validate(model);
                    model.nodeStructureChanged(node);
                }
                this.reloadAll();
            }
            catch (Exception e) {
                if (Debugger.demoMode) break block3;
                System.err.println("VALIDATE ----------------------------");
                System.err.flush();
                e.printStackTrace(System.err);
            }
        }
    }

    public void invalidateAllThreads() {
        block3: {
            try {
                Iterator iter = this.threadNodes.values().iterator();
                while (iter.hasNext()) {
                    AJThreadNode node = (AJThreadNode)iter.next();
                    AJTreeModel model = (AJTreeModel)this.getModel();
                    node.invalidate();
                    model.nodeStructureChanged(node);
                }
                this.reloadAll();
            }
            catch (Exception e) {
                if (Debugger.demoMode) break block3;
                System.err.println("VALIDATE ----------------------------");
                System.err.flush();
                e.printStackTrace(System.err);
            }
        }
    }

    public void doModernize() {
        try {
            this.validateThreadNodes();
        }
        catch (ThreadDeath td) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    private List findParent(ThreadReference ref) {
        ArrayList<AJTreeNode> list = new ArrayList<AJTreeNode>();
        int i = 0;
        list.add(i++, new AJThreadNode(ref, (DefaultTreeModel)this.getModel()));
        ThreadGroupReference parent = ref.threadGroup();
        while (parent != null) {
            list.add(i++, new AJThreadGroupNode(parent, (DefaultTreeModel)this.getModel()));
            parent = parent.parent();
        }
        return list;
    }

    public void clear() {
        AJRootNode root = this.root();
        AJTreeModel model = new AJTreeModel(root);
        AJTreeCellRenderer rend = new AJTreeCellRenderer();
        this.setRoot(root);
        this.setModel(model);
        this.setCellRenderer(rend);
    }

    private AJRootNode root() {
        return new AJRootNode("Threads", AJIcons.THREADS_ICON);
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        Point point = e.getLocation();
        int x = (int)point.getX();
        int y = (int)point.getY();
        int row = this.getRowForLocation(x, y);
        TreePath path = this.getPathForLocation(x, y);
        if (row == -1) {
            return;
        }
        AJTreeNode node = (AJTreeNode)path.getLastPathComponent();
        if (!node.isValueNode()) {
            e.rejectDrag();
        } else {
            e.acceptDrag(2);
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(2);
        Point point = e.getLocation();
        int x = (int)point.getX();
        int y = (int)point.getY();
        int row = this.getRowForLocation(x, y);
        TreePath path = this.getPathForLocation(x, y);
        if (row == -1) {
            return;
        }
        AJTreeNode node = (AJTreeNode)path.getLastPathComponent();
        try {
            Value newValue = ((AJValueWrapper)e.getTransferable().getTransferData(AJDataFlavor.FLAVORS[0])).unwrap();
            AJValueNode valueNode = (AJValueNode)node;
            valueNode.setValue(newValue);
            ((AJTreeModel)this.getModel()).reload(valueNode);
            e.getDropTargetContext().dropComplete(true);
        }
        catch (NullPointerException npe) {
            AJUtil.warn(npe);
        }
        catch (Exception ee) {
            AJUtil.ex(ee);
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        Point point = e.getDragOrigin();
        int x = (int)point.getX();
        int y = (int)point.getY();
        int row = this.getRowForLocation(x, y);
        TreePath path = this.getPathForLocation(x, y);
        if (row == -1) {
            return;
        }
        AJTreeNode node = (AJTreeNode)path.getLastPathComponent();
        AJValueWrapper trans = null;
        if (node.isValueNode()) {
            trans = new AJValueWrapper(((AJValueNode)node).getValue());
        }
        this.dragSource.startDrag(e, DragSource.DefaultMoveDrop, trans, this);
    }
}

