/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJStackFrameNode;
import org.aspectj.debugger.gui.AJThreadFormatter;
import org.aspectj.debugger.gui.AJTreeModel;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.ComponentRepository;

public class AJThreadNode
extends AJTreeNode {
    ThreadReference thread = null;
    private long id = -1L;
    boolean tdb = false;

    public AJThreadNode(ThreadReference thread, DefaultTreeModel model) {
        super(AJIcons.THREAD_ICON, model);
        this.thread = thread;
        this.setUserObject(thread);
        this.id = thread.uniqueID();
    }

    public long getId() {
        return this.id;
    }

    public void showKids() {
        try {
            this.showFrames();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            // empty catch block
        }
    }

    public void hideKids() {
        this.hideFrames();
    }

    public boolean isOKToExpand() {
        if (!this.thread.isSuspended() && !this.thread.isAtBreakpoint()) {
            return false;
        }
        return super.isOKToExpand();
    }

    public void validate() {
        this.showFrames();
    }

    public void invalidate() {
        this.hideFrames();
    }

    public void validate(AJTreeModel model) {
        this.showFrames(model);
    }

    private boolean locationsAreEqual(Location l1, Location l2) {
        try {
            String type1 = l1.declaringType().toString();
            String type2 = l2.declaringType().toString();
            String meth1 = l1.method().toString();
            String meth2 = l2.method().toString();
            boolean result = type1.equals(type2) && meth1.equals(meth2);
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean framesAreEqual(StackFrame f1, StackFrame f2) {
        try {
            String m1 = f1.location().method().toString();
            String m2 = f2.location().method().toString();
            return m1.equals(m2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean framesAreValid() {
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            if (this.isValidFrame((AJStackFrameNode)enumeration.nextElement())) continue;
            return false;
        }
        return true;
    }

    private boolean isValidFrame(AJStackFrameNode node) {
        try {
            node.location();
        }
        catch (InvalidStackFrameException e) {
            return false;
        }
        return true;
    }

    private void showFrames(DefaultTreeModel model) {
        try {
            Iterator iter = this.frames().iterator();
            this.removeAllChildren();
            boolean i = false;
            while (iter.hasNext()) {
                AJStackFrameNode node = new AJStackFrameNode((StackFrame)iter.next());
                this.add(node);
                node.showKids();
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        model.reload(this);
    }

    private void showFrames() {
        this.showFrames(this.getModel());
    }

    private void hideFrames() {
        try {
            this.removeAllChildren();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rightMouseButton(MouseEvent e) {
        JPopupMenu menu = null;
        menu = this.thread.isAtBreakpoint() ? new ContPopupMenu() : (this.thread.isSuspended() ? new ResumePopupMenu() : new SuspendPopupMenu());
        menu.show(ComponentRepository.getThreadGroupTreePane().getTree(), e.getX(), e.getY());
    }

    public List frames() throws IncompatibleThreadStateException {
        return ComponentRepository.getAJDebugger().frames(this.thread);
    }

    public void interrupt() {
        this.thread.interrupt();
    }

    public String name() {
        return this.thread.name();
    }

    public void resume() {
        this.thread.resume();
    }

    public int status() {
        return this.thread.status();
    }

    public void suspend() {
        this.thread.suspend();
    }

    public ThreadReference getThread() {
        return this.thread;
    }

    public void setThread(ThreadReference thread) {
        this.thread = thread;
        this.setUserObject(thread);
    }

    public boolean isThread() {
        return true;
    }

    public int getType() {
        if (this.thread.isAtBreakpoint()) {
            return AJIcons.THREAD_BREAKPOINT_ICON;
        }
        if (this.thread.isSuspended()) {
            return AJIcons.THREAD_SUSPENDED_ICON;
        }
        return AJIcons.THREAD_RUNNING_ICON;
    }

    public String toString() {
        String t = "";
        try {
            t = "[ ";
            Object[] frames = this.frames().toArray();
            int i = 0;
            while (i < frames.length) {
                t = t + System.identityHashCode((StackFrame)frames[i]) + " ";
                ++i;
            }
            t = t + " ]:";
            t = t + "bp=" + this.thread.isAtBreakpoint() + ": ";
            t = t + "su=" + this.thread.isSuspended() + ": ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (this.tdb ? this.dd() + t : "") + AJThreadFormatter.format(this.thread);
    }

    private String other() {
        if (this.thread.isAtBreakpoint()) {
            return "at breakpoint";
        }
        if (this.thread.isSuspended()) {
            return "suspended";
        }
        return "running";
    }

    private String statusString() {
        switch (this.status()) {
            case 3: {
                return "monitor";
            }
            case 5: {
                return "not started";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "sleeping";
            }
            case -1: {
                return "unkown";
            }
            case 4: {
                return "waiting";
            }
            case 0: {
                return "zombie";
            }
        }
        return "?";
    }

    private class ContPopupMenu
    extends JPopupMenu {
        ContPopupMenu() {
            JMenuItem item = new JMenuItem("Continue");
            item.addActionListener(new ActionListener(this){
                private final /* synthetic */ ContPopupMenu this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ComponentRepository.getCommandLine().executeCommand("cont");
                }
            });
            this.add(item);
        }
    }

    private class SuspendPopupMenu
    extends TwoActionPopupMenu {
        private SuspendPopupMenu() {
        }

        String getCommand() {
            return "suspend";
        }
    }

    private class ResumePopupMenu
    extends TwoActionPopupMenu {
        private ResumePopupMenu() {
        }

        String getCommand() {
            return "resume";
        }
    }

    abstract class TwoActionPopupMenu
    extends JPopupMenu {
        TwoActionPopupMenu() {
            final String command = this.getCommand();
            char[] chars = command.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            String upperCommand = new String(chars);
            final String id = AJThreadNode.this.getThread().uniqueID() + "";
            JMenuItem item1 = new JMenuItem(upperCommand + " thread #" + id);
            item1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ComponentRepository.getCommandLine().executeCommand(command + " " + id);
                    ComponentRepository.getThreadGroupTreePane().modernizeTree();
                }
            });
            JMenuItem item2 = new JMenuItem(upperCommand + " all");
            item2.addActionListener(new ActionListener(this, command){
                private final /* synthetic */ String val$command;
                private final /* synthetic */ TwoActionPopupMenu this$1;
                {
                    this.this$1 = this$1;
                    this.val$command = val$command;
                }

                public void actionPerformed(ActionEvent e) {
                    ComponentRepository.getCommandLine().executeCommand(this.val$command);
                    ComponentRepository.getThreadGroupTreePane().modernizeTree();
                }
            });
            this.add(item1);
            this.add(item2);
        }

        abstract String getCommand();
    }
}

