/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.Iterator;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.gui.AJDecParser;
import org.aspectj.debugger.gui.AJLineMapper;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.tools.ide.Declaration;

public class AJTranslator {
    static final String AJC = "$ajc";
    static final String BEFORE_AJC = "before$ajc";
    static final String AFTER_AJC = "after$ajc";
    static final String AROUND_AJC = "around$ajc";
    static final String EXECUTION = "$execution";
    static final String RECEPTION = "$reception";
    static final String CALL = "$call";
    static final String ASPECT_OF = "aspectOf";
    static final String HAS_ASPECT = "hasAspect";
    static final String AROUND = "$around";
    static final String AROUND_EXECUTION = "$around$execution";
    static final String AROUND_RECEPTION = "$around$reception";
    static final String AROUND_CALL = "$around$call";
    static final String[] SPECIAL_STRINGS = new String[]{"$execution", "$reception", "$call", "aspectOf", "hasAspect"};
    static final String[] ADVICE_STRINGS = new String[]{"before$ajc", "after$ajc", "around$ajc"};

    public static String getMappingMethodName(String method) {
        String clazz = AJUtil.getTypeFromMethod(method);
        String file = AJLineMapper.getSourceFilePathFromAJCClass(clazz);
        if (file == null) {
            return method;
        }
        int line = AJDecParser.getMethodLineNumber(file, method);
        if (line == -1) {
            return method;
        }
        Declaration dec = AJLineMapper.symbolManager.getDeclarationAtLine(file, line);
        if (dec == null || dec.getPointedToBy() == null || dec.getPointedToBy().length == 0) {
            return method;
        }
        String baseName = AJUtil.stripParens(method);
        ReferenceType refType = null;
        try {
            refType = ComponentRepository.getAJDebugger().getReferenceTypeFromToken(clazz);
        }
        catch (DebuggerException de) {
            // empty catch block
        }
        if (refType == null) {
            return method;
        }
        Iterator<Method> iter = refType.methods().iterator();
        String uScoreClass = clazz.replace('.', '_');
        String comp = AJUtil.stripTypeFromMethod(baseName) + "$" + uScoreClass;
        while (iter.hasNext()) {
            Method meth = iter.next();
            if (!meth.name().startsWith(comp) || AJTranslator.isNonMappingMethod(meth)) continue;
            return meth + "";
        }
        return method;
    }

    public static String translateFullWorkingDirMethodName(String meth) {
        String type = AJUtil.getTypeFromMethod(meth);
        String name = AJTranslator.translateWorkingDirMethodName(AJUtil.getNameFromMethod(meth));
        String params = AJUtil.getParamsFromMethod(meth);
        return type + "." + name + "(" + params + ")";
    }

    public static boolean isNonMappingMethod(Method method) {
        Location loc = method.location();
        if (loc == null) {
            return false;
        }
        int line = AJLineMapper.getCorrespondingLine((Location)loc).line;
        return line == -2;
    }

    public static boolean isNonMappingMethod(String clazz, int oldLine) {
        String ajFile = AJLineMapper.getSourceFilePathFromAJCClass(clazz);
        if (ajFile == null) {
            return false;
        }
        int line = AJLineMapper.getCorrespondingLine((String)clazz, (int)oldLine).line;
        return line == -2;
    }

    public static String getBaseName(String method) {
        int end = method.indexOf("(");
        if (end == -1) {
            end = method.length();
        }
        int i = end - 1;
        int idollar = -1;
        while (i >= 0) {
            char c = method.charAt(i);
            if (c == '.') break;
            if (c == '$') {
                idollar = i;
            }
            --i;
        }
        return idollar != -1 ? method.substring(0, idollar) : method;
    }

    public static String getBaseNameWithParams(String method) {
        int ip = method.indexOf("(");
        String params = "";
        String nameAndMaybeType = method;
        if (ip != -1) {
            params = method.substring(ip);
            nameAndMaybeType = method.substring(0, ip);
        }
        return AJTranslator.getBaseName(nameAndMaybeType) + params;
    }

    public static String translateWorkingDirMethodName_(String methodName) {
        int firstDollar = methodName.indexOf(36);
        if (firstDollar == -1) {
            return methodName;
        }
        String baseName = methodName.substring(0, firstDollar);
        int iajc = methodName.indexOf(AJC);
        if (iajc != -1) {
            String numStr = methodName.substring(iajc + AJC.length());
            return baseName + "<" + "advice-#" + numStr + ">";
        }
        int iaroundExecution = methodName.indexOf(AROUND_EXECUTION);
        if (iaroundExecution != -1) {
            return baseName + "<" + "around-execution>";
        }
        int iaroundReception = methodName.indexOf(AROUND_RECEPTION);
        if (iaroundReception != -1) {
            return baseName + "<" + "around-reception>";
        }
        int iaroundCall = methodName.indexOf(AROUND_CALL);
        if (iaroundCall != -1) {
            String numStr = methodName.substring(iaroundCall + AROUND_CALL.length());
            return baseName + "<" + "around-call-#" + numStr + ">";
        }
        int iexecution = methodName.indexOf(EXECUTION);
        if (iexecution != -1) {
            return baseName + "<" + "execution>";
        }
        int ireception = methodName.indexOf(RECEPTION);
        if (ireception != -1) {
            return baseName + "<" + "reception>";
        }
        int icall = methodName.indexOf(CALL);
        if (icall != -1) {
            String numStr = methodName.substring(icall + CALL.length());
            return baseName + "<" + "call-#" + numStr + ">";
        }
        return methodName;
    }

    public static String translateWorkingDirMethod(String clazz, String methodName) {
        if (AJTranslator.isAdvice(methodName)) {
            return AJTranslator.translateWorkingDirMethodName(methodName);
        }
        return AJTranslator.getMappingMethodName(clazz + "." + methodName);
    }

    public static String translateWorkingDirMethodName(String methodName) {
        int firstDollar = methodName.indexOf(36);
        if (firstDollar == -1) {
            return methodName;
        }
        String baseName = methodName.substring(0, firstDollar);
        String noDollars = methodName.substring(firstDollar + 1).replace('$', '-');
        return baseName + "<" + noDollars + ">";
    }

    public static boolean isAdvice(String methodName) {
        return methodName.indexOf(AJC) != -1;
    }

    public static boolean isReception(String methodName) {
        return methodName.indexOf(RECEPTION) != -1;
    }

    public static boolean isSpecialMethod(String methodName) {
        int i = 0;
        while (i < SPECIAL_STRINGS.length) {
            if (methodName.indexOf(SPECIAL_STRINGS[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String translateSourceMethodNameWithParams(String methodName) {
        String params = AJUtil.getParamsFromMethod(methodName);
        String rest = AJUtil.stripParens(methodName);
        String result = AJTranslator.translateSourceMethodName(rest);
        return result + "(" + params + ")";
    }

    public static String translateSourceMethodName(String methodName) {
        int firstLT = methodName.indexOf("<");
        if (firstLT < 1) {
            return methodName;
        }
        String baseName = methodName.substring(0, firstLT);
        String dollars = methodName.substring(firstLT + 1, methodName.length() - 1).replace('-', '$');
        return baseName + "$" + dollars;
    }

    public static String translateSourceMethodName_(String methodName) {
        if (methodName.equals("<init>") || methodName.equals("<clinit>")) {
            return methodName;
        }
        if (methodName.startsWith("<") && methodName.endsWith(">")) {
            int iAdvice = methodName.indexOf("-advice-#");
            if (iAdvice == -1) {
                return methodName;
            }
            String adviceType = methodName.substring(1, iAdvice);
            int iNum = iAdvice + 9;
            String numStr = methodName.substring(iNum, methodName.length() - 1);
            return adviceType + AJC + numStr;
        }
        return methodName;
    }

    public static String translateWorkingDirMethodNameWithParams(String methodName) {
        String params = AJUtil.getParamsFromMethod(methodName);
        String rest = AJUtil.stripParens(methodName);
        String result = AJTranslator.translateWorkingDirMethodName(rest);
        return result + "(" + params + ")";
    }

    public static String getTranslatedMethodName(String classID, String meth) {
        return "";
    }
}

