/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.ComponentRepository;

public class AJTreeNode
extends DefaultMutableTreeNode {
    protected DefaultTreeModel model;
    protected int type = -1;
    protected String string = "";
    protected boolean alwaysExpand = false;
    private boolean dd = true;

    public AJTreeNode(int type, DefaultTreeModel model) {
        this.setAllowsChildren(true);
        this.setType(type);
        this.setModel(model);
    }

    public AJTreeNode(int type) {
        this(type, null);
    }

    public AJTreeNode() {
        this(AJIcons.DEFAULT_ICON);
    }

    public void add(AJTreeNode treeNode) {
        AJTreeNode aJTreeNode = this;
        synchronized (aJTreeNode) {
            if (this.model == null) {
                super.add(treeNode);
            } else {
                this.model.insertNodeInto(treeNode, this, this.getChildCount());
            }
        }
    }

    public DefaultTreeModel getModel() {
        return this.model;
    }

    public void setModel(DefaultTreeModel model) {
        this.model = model;
    }

    public boolean isValid() {
        return true;
    }

    public int getType() {
        return this.type;
    }

    public void setAlwaysExpand(boolean alwaysExpand) {
        this.alwaysExpand = alwaysExpand;
    }

    public void setType(int type) {
        this.type = type;
    }

    protected AJTreeNode add(List list) {
        return this.add(list, list.size() - 1);
    }

    private AJTreeNode add(List list, int index) {
        if (index < 0) {
            return (AJTreeNode)list.get(0);
        }
        Enumeration enumeration = this.children();
        AJTreeNode add = (AJTreeNode)list.get(index);
        while (enumeration.hasMoreElements()) {
            AJTreeNode next = (AJTreeNode)enumeration.nextElement();
            if (!next.equals(add)) continue;
            return next.add(list, index - 1);
        }
        this.add(add);
        return add.add(list, index - 1);
    }

    protected AJTreeNode remove(List list) {
        return this.remove(list, list.size() - 1);
    }

    private AJTreeNode remove(List list, int index) {
        if (index < 0) {
            return (AJTreeNode)list.get(0);
        }
        Enumeration enumeration = this.children();
        AJTreeNode remove = (AJTreeNode)list.get(index);
        while (enumeration.hasMoreElements()) {
            AJTreeNode next = (AJTreeNode)enumeration.nextElement();
            if (!next.equals(remove)) continue;
            if (index == 0) {
                this.remove(next);
                return next;
            }
            return next.remove(list, index - 1);
        }
        return null;
    }

    public boolean equals(AJTreeNode node) {
        return this.getUserObject().equals(node.getUserObject());
    }

    public void showKids() {
    }

    public void hideKids() {
    }

    public boolean isOKToExpand() {
        if (this.alwaysExpand) {
            return true;
        }
        return ComponentRepository.getAJDebugger().isStopped();
    }

    public boolean isOKToCollapse() {
        return true;
    }

    public boolean isEditable() {
        return false;
    }

    public void validate() {
    }

    public void mouseEvent(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.leftMouseButton(e);
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            this.middleMouseButton(e);
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.rightMouseButton(e);
        }
    }

    public void leftMouseButton(MouseEvent e) {
    }

    public void middleMouseButton(MouseEvent e) {
    }

    public void rightMouseButton(MouseEvent e) {
    }

    public JPopupMenu getPopupMenu() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public boolean isThread() {
        return false;
    }

    public boolean isThreadGroup() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isField() {
        return false;
    }

    public boolean isStackFrame() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isLocalVariable() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isByte() {
        return false;
    }

    public boolean isChar() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isShort() {
        return false;
    }

    public boolean isValueNode() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public String toString() {
        return this.getUserObject() == null ? this.string : "" + this.getUserObject();
    }

    public Enumeration children() {
        try {
            return super.children();
        }
        catch (Exception e) {
            AJUtil.warn("Caught " + e.getMessage());
            e.printStackTrace(System.err);
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
    }

    protected String dd() {
        return this.dd ? System.identityHashCode(this) + ": " : "";
    }
}

