/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.Method;
import com.sun.jdi.request.BreakpointRequest;
import java.awt.Frame;
import java.io.File;
import javax.swing.JOptionPane;

public class AJUtil {
    private static final Frame FRAME = null;

    public static void info(Object o) {
        Object msg = AJUtil.check(o);
        JOptionPane.showMessageDialog(FRAME, msg, "Info", 1);
    }

    public static void warn(Object o) {
        Object msg = AJUtil.check(o);
        JOptionPane.showMessageDialog(FRAME, msg, "Warning", 2);
    }

    public static void error(Object o) {
        Object msg = AJUtil.check(o);
        JOptionPane.showMessageDialog(FRAME, msg, "Error", 0);
    }

    public static void question(Object o) {
        Object msg = AJUtil.check(o);
        JOptionPane.showMessageDialog(FRAME, msg, "Huh?", 3);
    }

    public static void popup(Object o) {
        Object msg = AJUtil.check(o);
        JOptionPane.showMessageDialog(FRAME, msg, "Error", -1);
    }

    public static void ex(Throwable o) {
        if (o == null) {
            return;
        }
        o.printStackTrace(System.err);
        JOptionPane.showMessageDialog(FRAME, o.getMessage(), "Exception", 0);
    }

    public static String getStringFromRequest(BreakpointRequest request) {
        String strip;
        String specString = request + "";
        if (specString.indexOf(strip = "breakpoint request ") != -1) {
            return specString.substring(strip.length() - 1);
        }
        return specString;
    }

    public static String stripParens(Method method) {
        return AJUtil.stripParens(method + "");
    }

    public static String stripParens(String method) {
        int index = method.indexOf("(");
        if (index < 0) {
            return method;
        }
        String noParens = method.substring(0, index);
        return noParens.trim();
    }

    public static String getParams(Method method) {
        return AJUtil.getParams(method + "");
    }

    public static String getParams(String method) {
        int lparen = method.indexOf("(");
        int rparen = method.indexOf(")");
        if (lparen < 0 || rparen < 0) {
            return method;
        }
        return method.substring(lparen + 1, rparen).trim();
    }

    public static String removePathFromSource(String source) {
        int isep = source.lastIndexOf(File.separatorChar);
        if (isep == -1) {
            return source;
        }
        return source.substring(isep + 1);
    }

    public static String stripTypeFromMethod(String name) {
        int iDot = AJUtil.locateFirstDotBeforeLParen(name);
        if (iDot != -1) {
            return name.substring(iDot + 1, name.length());
        }
        return name;
    }

    public static String getParamsFromMethod(Method method) {
        return AJUtil.getParamsFromMethod(method + "");
    }

    public static String getParamsFromMethod(String name) {
        int iLParen = name.indexOf("(");
        int iRParen = name.indexOf(")");
        if (iLParen == -1 || iRParen == -1) {
            return "";
        }
        return name.substring(iLParen + 1, iRParen);
    }

    public static String getTypeFromMethod(String name) {
        int iDot = AJUtil.locateFirstDotBeforeLParen(name);
        if (iDot != -1) {
            return name.substring(0, iDot);
        }
        return name;
    }

    public static String getNameFromMethod(String name) {
        int iDot = AJUtil.locateFirstDotBeforeLParen(name);
        int lParen = name.indexOf("(");
        if (iDot != -1 && lParen != -1) {
            return name.substring(iDot, lParen);
        }
        return name;
    }

    public static String safeIndex(String str, String pat) {
        int index = str.indexOf(pat);
        if (index != -1) {
            return str.substring(index + pat.length() + 1).trim();
        }
        return str;
    }

    private static int locateFirstDotBeforeLParen(String name) {
        int iDot = -1;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '(') break;
            if (c == '.') {
                iDot = i;
            }
            ++i;
        }
        return iDot;
    }

    private static Object check(Object o) {
        if (o == null) {
            return "<NULL MESSAGE>";
        }
        return o;
    }
}

