/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJLineMapper;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.AbstractSourcePane;
import org.aspectj.debugger.gui.Advisable;
import org.aspectj.debugger.gui.Breakable;
import org.aspectj.debugger.gui.MethodNode;
import org.aspectj.debugger.gui.Sourceable;
import org.aspectj.tools.ide.Declaration;

public class AdviceNode
extends AJTreeNode
implements Sourceable,
Breakable,
Advisable {
    protected Declaration dec;

    public AdviceNode(Declaration dec) {
        super(AJIcons.ADVICE_ICON);
        this.dec = dec;
        this.setUserObject(this.dec.getSignature());
        this.setAlwaysExpand(true);
    }

    public String getToolTipText() {
        if (this.dec == null) {
            return "no declaration";
        }
        if (this.dec.getCrosscutDeclaration() == null) {
            return "no crosscut declaration";
        }
        return this.showClass() + this.dec.getSignature() + " : " + this.dec.getCrosscutDeclaration().getSignature();
    }

    protected String showClass() {
        if (this.getParent() instanceof MethodNode) {
            return this.dec.getDeclaringType() + ".";
        }
        return "";
    }

    public void showOnSource(AbstractSourcePane sourcePane) {
        sourcePane.showSourceForFileAndLine(this.dec.getFilename(), this.dec.getBeginLine());
    }

    public String getBreakpoint() {
        return AJLineMapper.removeRoot(this.dec.getFilename()) + ":" + this.dec.getBeginLine();
    }

    public List getAdvisedMethodStrings() {
        Vector<String> methods = new Vector<String>();
        if (this.children == null) {
            return methods;
        }
        Iterator iter = ((AbstractList)this.children).iterator();
        while (iter.hasNext()) {
            methods.add(((MethodNode)iter.next()).getBreakpoint());
        }
        return methods;
    }
}

