/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.aspectj.debugger.gui.AJCClassNode;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.Advisable;
import org.aspectj.debugger.gui.Advisedable;
import org.aspectj.debugger.gui.Breakable;
import org.aspectj.debugger.gui.ClassNode;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.gui.MethodNode;

public class ClassNodeMouseListener
extends MouseAdapter {
    protected JTree tree;
    protected GUIDebugger guiDebugger;
    static final String stop = "stop in ";

    public ClassNodeMouseListener(GUIDebugger guiDebugger, JTree tree) {
        this.guiDebugger = guiDebugger;
        this.tree = tree;
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int selRow = this.tree.getRowForLocation(x, y);
        TreePath path = this.tree.getPathForLocation(x, y);
        if (path == null) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            AJTreeNode treeNode = (AJTreeNode)path.getLastPathComponent();
            String breakString = null;
            List adviceStrings = null;
            List advisedMethodStrings = null;
            List classMethodStrings = null;
            List classAdviceStrings = null;
            String name = null;
            boolean isAdvice = true;
            if (treeNode instanceof MethodNode) {
                isAdvice = false;
            }
            if (treeNode instanceof Breakable) {
                Breakable breakable = (Breakable)((Object)treeNode);
                breakString = breakable.getBreakpoint();
                final String cmd = stop + breakString;
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item = new JMenuItem(cmd);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent _) {
                        ComponentRepository.getAJDebugger().execute(cmd);
                    }
                });
                menu.add(item);
                menu.show(this.tree, x, y);
            }
            if (treeNode instanceof Advisedable) {
                Advisedable advisedable = (Advisedable)((Object)treeNode);
                adviceStrings = advisedable.getAdviceStrings();
            }
            if (treeNode instanceof Advisable) {
                Advisable advisable = (Advisable)((Object)treeNode);
                advisedMethodStrings = advisable.getAdvisedMethodStrings();
            }
            if (treeNode instanceof ClassNode) {
                ClassNode classNode = (ClassNode)treeNode;
                classMethodStrings = classNode.getMethodStrings();
                name = classNode.fullName();
            }
            if (treeNode instanceof AJCClassNode) {
                AJCClassNode ajcClassNode = (AJCClassNode)treeNode;
                classAdviceStrings = ajcClassNode.getAdviceStrings();
            }
            this.show(x, y, isAdvice, breakString, adviceStrings, advisedMethodStrings, classMethodStrings, classAdviceStrings, name);
        } else if (!SwingUtilities.isLeftMouseButton(e) || e.getClickCount() == 2) {
            // empty if block
        }
    }

    private void show(int x, int y, boolean isAdvice, String breakString, List adviceStrings, List advisedMethodStrings, List classMethodStrings, List classAdviceStrings, String name) {
        JPopupMenu menu = new JPopupMenu();
        if (breakString != null && !breakString.equals("")) {
            String cmd;
            String adviceOrMethod = isAdvice ? "advice" : "method";
            String title = cmd = stop + breakString;
            menu.add(new AbstractAction(title){

                public void actionPerformed(ActionEvent _) {
                    ComponentRepository.getAJDebugger().execute(cmd);
                }
            });
        }
        this.add(menu, "stop in all advice", adviceStrings);
        this.add(menu, "stop in all advised methods", advisedMethodStrings);
        this.add(menu, "stop in all declared methods", classMethodStrings);
        this.add(menu, "stop in all declared advice", classAdviceStrings);
        if (name != null && !name.equals("null")) {
            this.add(menu, "run class " + name, "run " + name);
        }
        menu.show(this.tree, x, y);
    }

    private void add(JPopupMenu menu, String title, String command) {
        Vector<String> list = new Vector<String>();
        list.add(command);
        this.add(menu, title, list, "");
    }

    private void add(JPopupMenu menu, String title, List strings) {
        this.add(menu, title, strings, stop);
    }

    private void add(JPopupMenu menu, String title, final List strings, final String prefix) {
        if (strings == null || strings.size() == 0) {
            return;
        }
        menu.add(new AbstractAction(title){

            public void actionPerformed(ActionEvent _) {
                int i = 0;
                while (i < strings.size()) {
                    Object command = strings.get(i);
                    if (command != null && !(command + "").equals("null")) {
                        ClassNodeMouseListener.this.guiDebugger.getDebugger().execute(prefix + command);
                    }
                    ++i;
                }
            }
        });
    }

    protected JTree tree() {
        return this.tree;
    }
}

