/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.aspectj.debugger.base.ClassListener;
import org.aspectj.debugger.base.VMListener;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJTree;
import org.aspectj.debugger.gui.AJTreeCellRenderer;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.ClassNode;
import org.aspectj.debugger.gui.ClassNodeFactory;
import org.aspectj.debugger.gui.ClassNodeMouseListener;
import org.aspectj.debugger.gui.ClassNodeSelectionListener;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.gui.NoCollapsingRootExpansionListener;
import org.aspectj.tools.ide.SymbolManager;

public class ClassTreePane
extends JPanel
implements VMListener,
ClassListener {
    private JTree tree;
    private DefaultTreeModel treeModel;
    private RootNode root;
    private GUIDebugger guiDebugger;
    static final String stop = "stop in ";

    public ClassTreePane(GUIDebugger guiDebugger) {
        super(new BorderLayout());
        this.guiDebugger = guiDebugger;
        guiDebugger.getDebugger().addVMListener(this);
        guiDebugger.getDebugger().addClassListener(this);
        this.root = new RootNode();
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new AJTree(this.treeModel){

            public void clear() {
            }

            public int getVisibleRowCount() {
                return this.getRowCount();
            }
        };
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setCellRenderer(new AJTreeCellRenderer());
        this.tree.addTreeSelectionListener(new ClassNodeSelectionListener(guiDebugger));
        this.tree.addMouseListener(new ClassNodeMouseListener(guiDebugger, this.tree));
        this.tree.addTreeWillExpandListener(new NoCollapsingRootExpansionListener(this.tree));
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add(treeView);
    }

    public JTree getTree() {
        return this.tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    void showMenu(int x, int y, final String cmd, final Vector advice, final Vector advisedMethods, final Vector methods, boolean isAdvice) {
        JPopupMenu menu = new JPopupMenu();
        if (cmd != null && !cmd.equals("")) {
            String adviceOrMethod = isAdvice ? "advice" : "method";
            menu.add(new AbstractAction("Break in " + adviceOrMethod){

                public void actionPerformed(ActionEvent e) {
                    ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + cmd);
                }
            });
        }
        if (advice != null && advice.size() > 0) {
            menu.add(new AbstractAction("Break in all advice"){

                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < advice.size()) {
                        ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + advice.get(i));
                        ++i;
                    }
                }
            });
        }
        if (methods != null && methods.size() > 0) {
            menu.add(new AbstractAction("Break in all methods"){

                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < methods.size()) {
                        ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + methods.get(i));
                        ++i;
                    }
                }
            });
        }
        if (advisedMethods != null && advisedMethods.size() > 0) {
            menu.add(new AbstractAction("Break in all advised methods"){

                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < advisedMethods.size()) {
                        ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + advisedMethods.get(i));
                        ++i;
                    }
                }
            });
        }
        if (methods != null && methods.size() > 0 && advice != null && advice.size() > 0) {
            menu.add(new AbstractAction("Break in all advice & methods"){

                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < methods.size()) {
                        ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + methods.get(i));
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < advice.size()) {
                        ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + advice.get(i2));
                        ++i2;
                    }
                }
            });
        }
        if (methods != null && methods.size() > 0 && advice != null && advice.size() > 0 && advisedMethods != null && advisedMethods.size() > 0) {
            menu.add(new AbstractAction("Break in all advice, advised methods, and methods"){

                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < methods.size()) {
                        ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + methods.get(i));
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < advice.size()) {
                        ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + advice.get(i2));
                        ++i2;
                    }
                    int i3 = 0;
                    while (i3 < methods.size()) {
                        ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + advisedMethods.get(i3));
                        ++i3;
                    }
                }
            });
        }
        menu.show(this.tree, x, y);
    }

    void showMultipleMenu(int x, int y, final Vector cmds) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new AbstractAction("Break in " + cmds.size() + " points"){

            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < cmds.size()) {
                    ComponentRepository.getCommandLine().executeCommand(ClassTreePane.stop + cmds.get(i));
                    ++i;
                }
            }
        });
        menu.show(this.tree, x, y);
    }

    public void loadAJCClasses(String newSourcePath) {
        new AJCClassLoader().load(newSourcePath);
    }

    protected void reset() {
        this.root = new RootNode();
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree.setModel(this.treeModel);
    }

    public void addClass(ReferenceType refType) {
        boolean expand = this.root.getChildCount() == 0;
        this.root.addClass(refType);
        if (expand) {
            this.tree.expandRow(0);
        }
    }

    public void removeClass(String className) {
        this.root.removeClass(className);
    }

    public void vmDeathEvent(VMDeathEvent e) {
        this.reset();
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
        this.reset();
    }

    public void vmStartEvent(VMStartEvent e) {
        this.reset();
    }

    public void classPrepareEvent(ClassPrepareEvent e) {
        this.addClass(e.referenceType());
    }

    public void classUnloadEvent(ClassUnloadEvent e) {
        this.removeClass(e.className());
    }

    MutableTreeNode insertNode(String name, MutableTreeNode parent, MutableTreeNode newChild) {
        int N = parent.getChildCount();
        int i = 0;
        while (i < N) {
            int cmp;
            MutableTreeNode child = (MutableTreeNode)parent.getChildAt(i);
            String childString = child.toString();
            int ispace = childString.indexOf(" ");
            if (ispace != -1) {
                childString = childString.substring(0, ispace);
            }
            if ((cmp = name.compareTo(childString)) == 0) {
                return child;
            }
            if (cmp < 0) {
                this.treeModel.insertNodeInto(newChild, parent, i);
                return newChild;
            }
            ++i;
        }
        this.treeModel.insertNodeInto(newChild, parent, N);
        if (parent == this.root) {
            this.tree.expandPath(new TreePath(((DefaultMutableTreeNode)newChild).getPath()));
        }
        return newChild;
    }

    public String toString() {
        return ClassTreePane.d();
    }

    public static String d() {
        return "Class Tree Pane";
    }

    class PackageNode
    extends RootNode {
        private String name;

        public PackageNode(String name) {
            this.setType(AJIcons.PACKAGE_ICON);
            this.name = name;
            this.setUserObject(this.name);
        }
    }

    class RootNode
    extends AJTreeNode {
        private int classCount = 0;

        public RootNode() {
            super(AJIcons.CLASSES_ICON);
            this.setUserObject("Classes");
        }

        public boolean isOKToExpand() {
            return true;
        }

        public ClassNode addClass(ReferenceType refType) {
            return this.addClass(refType.name(), refType);
        }

        public ClassNode addClass(String name) {
            return this.addClass(name, null);
        }

        public ClassNode removeClass(ReferenceType refType) {
            return null;
        }

        public ClassNode removeClass(String className) {
            return null;
        }

        protected ClassNode addClass(String name, ReferenceType refType) {
            this.incClassCount();
            int idot = name.indexOf(".");
            if (idot == -1) {
                ClassNode classNode = ClassNodeFactory.classNode(name, refType);
                classNode.setAlwaysExpand(true);
                ClassTreePane.this.insertNode(name, this, classNode);
                return classNode;
            }
            String head = name.substring(0, idot);
            String tail = name.substring(idot + 1);
            return ((RootNode)ClassTreePane.this.insertNode(head, this, new PackageNode(head))).addClass(tail, refType);
        }

        public int getClassCount() {
            return this.classCount;
        }

        public void incClassCount() {
            this.changeClassCount(1);
        }

        public void decClassCount() {
            this.changeClassCount(-1);
        }

        private void changeClassCount(int delta) {
            this.classCount += delta;
            try {
                ClassTreePane.this.getTreeModel().nodeChanged(this);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private static class AJCClassLoader {
        private AJCClassLoader() {
        }

        public void load(String sourcePath) {
            if (sourcePath == null || "".equals(sourcePath)) {
                return;
            }
            SymbolManager sm = SymbolManager.getSymbolManager();
            File file = new File(sourcePath);
            if (file == null || !file.exists()) {
                return;
            }
            if (file.isDirectory()) {
                this.loadAJCClasses(file);
            } else {
                this.loadAJCClasses(file.getParentFile());
            }
        }

        private void loadAJCClasses(File dir) {
            if (dir == null || !dir.exists() || !dir.isDirectory()) {
                return;
            }
            File[] javaFiles = dir.listFiles(AJCClassLoader.javaFilter());
            int i = 0;
            while (i < javaFiles.length) {
                this.loadAJCClass(javaFiles[i]);
                ++i;
            }
            File[] dirs = dir.listFiles(AJCClassLoader.dirFilter());
            int i2 = 0;
            while (i2 < dirs.length) {
                this.loadAJCClasses(dirs[i2]);
                ++i2;
            }
        }

        private void loadAJCClass(File file) {
        }

        private static FileFilter dirFilter() {
            return new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            };
        }

        private static FileFilter javaFilter() {
            return new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().indexOf("ajworkingdir") == -1 && file.getName().endsWith(".java");
                }
            };
        }
    }
}

