/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.aspectj.debugger.gui.AJTextField;
import org.aspectj.debugger.gui.ColorChangingLabel;
import org.aspectj.debugger.gui.ComponentDirector;
import org.aspectj.debugger.gui.ComponentRepository;

public class CommandLine
extends JPanel {
    private String TITLE = "Command";
    private int WIDTH = 40;
    private AJTextField text = null;
    private JLabel label = new JLabel(this.TITLE + ": ");
    private ColorChangingLabel statusLabel;

    public CommandLine(ComponentDirector gui) {
        this.text = new AJTextField("", this.WIDTH);
        this.text.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommandLine.this.pressEnter();
            }
        });
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.label);
        this.add(this.text);
        this.statusLabel = new ColorChangingLabel();
    }

    public boolean isManagingFocus() {
        return true;
    }

    public ColorChangingLabel getStatusLabel() {
        return this.statusLabel;
    }

    void addText(String str) {
        String getText = this.text.getText();
        int pos = this.text.getCaretPosition();
        if (getText.length() == 0) {
            this.text.setText(str);
        } else {
            this.text.setText(getText.substring(0, pos) + str + getText.substring(pos, getText.length()));
            this.text.setCaretPosition(pos + 1);
        }
    }

    void pressEnter() {
        String str = this.text.getText();
        this.executeCommand(str);
    }

    void pressBackSpace() {
        String getText = this.text.getText();
        int pos = this.text.getCaretPosition();
        if (getText.length() != 0 && pos != 0) {
            this.text.setText(getText.substring(0, pos - 1) + (pos < getText.length() ? getText.substring(pos, getText.length()) : ""));
            this.text.setCaretPosition(pos - 1);
        }
    }

    void pressRight() {
        int newPos = this.text.getCaretPosition() + 1;
        if (newPos <= this.text.getText().length()) {
            this.text.setCaretPosition(newPos);
        }
    }

    void pressLeft() {
        int newPos = this.text.getCaretPosition() - 1;
        if (newPos >= 0) {
            this.text.setCaretPosition(newPos);
        }
    }

    void pressHome() {
        this.text.setCaretPosition(0);
    }

    void pressEnd() {
        this.text.setCaretPosition(this.text.getText().length());
    }

    void executeCommand(String cmd) {
        ComponentRepository.getAJDebugger().executeCommand(cmd);
        this.text.setText("");
    }

    protected JTextField getTextField() {
        return this.text;
    }

    public static String d() {
        return "Command Line";
    }

    public String toString() {
        return CommandLine.d();
    }
}

