/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ThreadReference;
import java.awt.Frame;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.aspectj.debugger.gui.AJNewValueDialog;
import org.aspectj.debugger.gui.AJToolBar;
import org.aspectj.debugger.gui.AJValueNode;
import org.aspectj.debugger.gui.BreakpointDialog;
import org.aspectj.debugger.gui.CatchDialog;
import org.aspectj.debugger.gui.ClearBreakpointDialog;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.DumpDialog;
import org.aspectj.debugger.gui.EvalDialog;
import org.aspectj.debugger.gui.ExecuteDialog;
import org.aspectj.debugger.gui.FieldsDialog;
import org.aspectj.debugger.gui.LocalsDialog;
import org.aspectj.debugger.gui.MonitorDialog;
import org.aspectj.debugger.gui.PrintDialog;
import org.aspectj.debugger.gui.RunDialog;
import org.aspectj.debugger.gui.SetBreakpointDialog;
import org.aspectj.debugger.gui.UseDialog;
import org.aspectj.debugger.gui.WatchDialog;

public class Dialogs {
    public static void showBreakpointDialog() {
        new BreakpointDialog(ComponentRepository.getComponentDirector()).show();
    }

    public static void showSetBreakpointDialog() {
        new SetBreakpointDialog(ComponentRepository.getComponentDirector()).show();
    }

    public static void showClearBreakpointDialog() {
        new ClearBreakpointDialog(ComponentRepository.getComponentDirector()).show();
    }

    public static void showNewValueDialog(AJValueNode node) {
        new AJNewValueDialog((Frame)ComponentRepository.getComponentDirector(), node).popup(node);
    }

    public static void showRunDialog() {
        new RunDialog().show();
    }

    public static void showCatchDialog() {
        new CatchDialog().show();
    }

    public static void showWatchDialog() {
        new WatchDialog().show();
    }

    public static void showUseDialog() {
        new UseDialog().show();
    }

    public static void showDumpDialog() {
        new DumpDialog().show();
    }

    public static void showEvalDialog() {
        new EvalDialog().show();
    }

    public static void showFieldsDialog() {
        new FieldsDialog().show();
    }

    public static void showLocalsDialog() {
        new LocalsDialog().show();
    }

    public static void showPrintDialog() {
        new PrintDialog().show();
    }

    public static String showSuspendDialog() {
        return Dialogs.showThreadDialog("suspend", "Suspend");
    }

    public static String showResumeDialog() {
        return Dialogs.showThreadDialog("resume", "Ruspend");
    }

    public static String showWhereDialog() {
        return Dialogs.showThreadDialog("view", "View");
    }

    public static void showHelpDialog() {
    }

    public static void showExecuteDialog() {
        new ExecuteDialog().show();
    }

    public static void showAboutDialog() {
        String msg = "by the aspectj.org team (C)";
        msg = msg + "\n" + ComponentRepository.getAJDebugger().version();
        int type = 1;
        String title = "About AJBuilder";
        JOptionPane.showMessageDialog(ComponentRepository.getComponentDirector(), msg, title, type);
    }

    static String showThreadDialog(String msg, String action) {
        try {
            Iterator<ThreadReference> iter = ComponentRepository.getAJDebugger().vm().allThreads().iterator();
            Vector<AJToolBar.ThreadPair> v = new Vector<AJToolBar.ThreadPair>();
            v.add(new AJToolBar.ThreadPair("All threads", -1L));
            while (iter.hasNext()) {
                ThreadReference o = iter.next();
                ThreadReference thread = iter.next();
                String name = thread.name();
                long id = thread.uniqueID();
                AJToolBar.ThreadPair pair = new AJToolBar.ThreadPair(name, id);
                v.add(pair);
            }
            Object[] os = v.toArray();
            AJToolBar.ThreadPair selected = (AJToolBar.ThreadPair)JOptionPane.showInputDialog(ComponentRepository.getComponentDirector(), "Please select a thread to " + msg, action + " a thread", 3, null, os, os[0]);
            if (selected != null && selected.id != -1L) {
                return selected.id + "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void showMonitorDialog() {
        new MonitorDialog(ComponentRepository.getGUIDebugger()).show();
    }

    public static void main(String[] args) {
        String s = Dialogs.showSuspendDialog();
        System.out.println("> " + s);
    }
}

