/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.Value;
import org.aspectj.debugger.gui.AJValueGetter;
import org.aspectj.debugger.gui.AJValueNode;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.Hexable;

public abstract class HexableAJValueNode
extends AJValueNode
implements Hexable {
    private boolean isHex = false;
    private static final int HEX_LENGTH = 8;

    public HexableAJValueNode(AJValueGetter getter, int type) {
        super(getter, type);
    }

    public abstract String getHexValue(Value var1);

    public void setHex(boolean isHex) {
        this.isHex = isHex;
    }

    public boolean isHex() {
        return this.isHex;
    }

    public void toggle() {
        this.setHex(!this.isHex());
        ComponentRepository.getThreadGroupTreePane().getTree().reloadAll();
    }

    public String format(Value value) {
        return this.isHex() ? "0x" + this.pad(this.getHexValue(value)) : super.format(value);
    }

    private String pad(String str) {
        int length = 8 - str.length();
        while (length-- > 0) {
            str = "0" + str;
        }
        return str;
    }
}

