/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.util.gui.CenteredJDialog;

public abstract class LineBreakpointDialog
extends CenteredJDialog {
    private GUIDebugger guid;
    private static final int TEXT_WIDTH = 30;
    private static final int LINE_WIDTH = 10;
    private static final String CLASS_NAME_STR = "Class name:";
    private static final String FILE_NAME_STR = "File name:";
    private static final String LINE_NUMBER_STR = "Line number:";
    private static final String METHOD_STR = "Method:";
    private JTextField classNameField = new JTextField(30);
    private JTextField fileNameField = new JTextField(30);
    private JTextField lineNumberField = new JTextField(10);
    private JTextField methodField;
    private JLabel lineNumberLabel;
    private JLabel methodLabel;
    private JRadioButton classNameRadioButton;
    private JRadioButton fileNameRadioButton;
    private ButtonGroup buttonGroup;
    private JButton classNameButton;
    private JButton fileNameButton;
    private JButton okButton;
    private JButton cancelButton;

    protected GUIDebugger guid() {
        return this.guid;
    }

    protected Frame gui() {
        return this.guid != null ? this.guid.getGui() : null;
    }

    public abstract String findClassName();

    public abstract String findFileName();

    public LineBreakpointDialog(GUIDebugger guid) {
        super(guid != null ? guid.getGui() : null, "Add Line Breakpoint", true);
        this.lineNumberField.setFocusAccelerator('n');
        this.methodField = new JTextField(30);
        this.methodField.setFocusAccelerator('m');
        this.lineNumberLabel = this.jlabel(LINE_NUMBER_STR);
        this.lineNumberLabel.setLabelFor(this.lineNumberField);
        this.lineNumberLabel.setDisplayedMnemonic('n');
        this.methodLabel = this.jlabel(METHOD_STR);
        this.methodLabel.setLabelFor(this.methodField);
        this.methodLabel.setDisplayedMnemonic('m');
        this.classNameRadioButton = new JRadioButton(new ClassNameSelectAction());
        this.classNameRadioButton.setSelected(true);
        this.classNameRadioButton.setMnemonic('a');
        this.fileNameRadioButton = new JRadioButton(new FileNameSelectAction());
        this.fileNameRadioButton.setMnemonic('F');
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.classNameRadioButton);
        this.buttonGroup.add(this.fileNameRadioButton);
        this.classNameButton = new JButton(new FindClassNameAction());
        this.fileNameButton = new JButton(new FindFileNameAction());
        this.okButton = new JButton(new OKAction());
        this.cancelButton = new JButton(new CancelAction());
        this.guid = guid;
        if (guid == null) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
        }
        JPanel lineBreakpointPanel = new JPanel();
        lineBreakpointPanel.setBorder(BorderFactory.createTitledBorder("Line Breakpoint"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 13;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.anchor = 17;
        GridBagLayout gb = new GridBagLayout();
        gb.setConstraints(lineBreakpointPanel, c);
        lineBreakpointPanel.setLayout(gb);
        int gridy = 0;
        c.gridx = 0;
        c.gridy = gridy;
        gb.setConstraints(this.classNameRadioButton, c);
        lineBreakpointPanel.add(this.classNameRadioButton);
        c.gridx = 1;
        c.gridy = gridy;
        gb.setConstraints(this.classNameField, c);
        lineBreakpointPanel.add(this.classNameField);
        c.gridx = 2;
        c.gridy = gridy++;
        gb.setConstraints(this.classNameButton, c);
        lineBreakpointPanel.add(this.classNameButton);
        c.gridx = 0;
        c.gridy = gridy;
        gb.setConstraints(this.fileNameRadioButton, c);
        lineBreakpointPanel.add(this.fileNameRadioButton);
        c.gridx = 1;
        c.gridy = gridy;
        gb.setConstraints(this.fileNameField, c);
        lineBreakpointPanel.add(this.fileNameField);
        c.gridx = 2;
        c.gridy = gridy++;
        gb.setConstraints(this.fileNameButton, c);
        lineBreakpointPanel.add(this.fileNameButton);
        c.gridx = 0;
        c.gridy = gridy;
        gb.setConstraints(this.lineNumberLabel, c);
        lineBreakpointPanel.add(this.lineNumberLabel);
        c.gridx = 1;
        c.gridy = gridy++;
        gb.setConstraints(this.lineNumberField, c);
        lineBreakpointPanel.add(this.lineNumberField);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        bottomPanel.add(this.okButton);
        bottomPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(lineBreakpointPanel);
        this.getContentPane().add(bottomPanel);
    }

    private void ok() {
        try {
            if (this.ok_()) {
                this.dispose();
            }
        }
        catch (Throwable t) {
            AJUtil.error(t);
        }
    }

    private boolean ok_() throws Throwable {
        int lineNumber = Integer.parseInt(this.lineNumberField.getText().trim());
        if (this.classNameRadioButton.isSelected()) {
            String className = this.classNameField.getText();
            if (className == null) {
                className = "";
            }
            if ((className = className.trim()).equals("")) {
                throw new Error("Class name cannot be empty");
            }
            if (this.guid != null) {
                this.guid.getDebugger().stopAtCommand(className, lineNumber);
                return true;
            }
            System.out.println("className=" + className + " line=" + lineNumber);
        }
        if (this.fileNameRadioButton.isSelected()) {
            String fileName = this.fileNameField.getText();
            if (fileName == null) {
                fileName = "";
            }
            if ((fileName = fileName.trim()).equals("")) {
                throw new Error("File name cannot be empty");
            }
            if (this.guid != null) {
                this.guid.getDebugger().stopOnCommand(fileName, lineNumber);
                return true;
            }
            System.out.println("fileName=" + fileName + " line=" + lineNumber);
        }
        return false;
    }

    private void cancel() {
        this.dispose();
    }

    private JLabel jlabel(String str) {
        JLabel label = new JLabel(str);
        label.setForeground(Color.black);
        return label;
    }

    private final class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent e) {
            LineBreakpointDialog.this.cancel();
        }
    }

    private final class OKAction
    extends AbstractAction {
        public OKAction() {
            super("OK");
        }

        public void actionPerformed(ActionEvent e) {
            LineBreakpointDialog.this.ok();
        }
    }

    private final class FindFileNameAction
    extends AbstractAction {
        public FindFileNameAction() {
            super("...");
        }

        public void actionPerformed(ActionEvent e) {
            LineBreakpointDialog.this.fileNameField.setText(LineBreakpointDialog.this.findFileName());
        }
    }

    private final class FindClassNameAction
    extends AbstractAction {
        public FindClassNameAction() {
            super("...");
        }

        public void actionPerformed(ActionEvent e) {
            LineBreakpointDialog.this.classNameField.setText(LineBreakpointDialog.this.findClassName());
        }
    }

    private final class FileNameSelectAction
    extends AbstractAction {
        public FileNameSelectAction() {
            super(LineBreakpointDialog.FILE_NAME_STR);
        }

        public void actionPerformed(ActionEvent e) {
            LineBreakpointDialog.this.classNameField.setEnabled(false);
            LineBreakpointDialog.this.classNameButton.setEnabled(false);
            LineBreakpointDialog.this.methodField.setEnabled(false);
            LineBreakpointDialog.this.fileNameField.setEnabled(true);
            LineBreakpointDialog.this.fileNameButton.setEnabled(true);
        }
    }

    private final class ClassNameSelectAction
    extends AbstractAction {
        public ClassNameSelectAction() {
            super(LineBreakpointDialog.CLASS_NAME_STR);
        }

        public void actionPerformed(ActionEvent e) {
            LineBreakpointDialog.this.fileNameField.setEnabled(false);
            LineBreakpointDialog.this.fileNameButton.setEnabled(false);
            LineBreakpointDialog.this.classNameField.setEnabled(true);
            LineBreakpointDialog.this.classNameButton.setEnabled(true);
            LineBreakpointDialog.this.methodField.setEnabled(true);
        }
    }
}

