/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.util.StringTokenizer;
import org.aspectj.debugger.gui.DeclarationComparator;
import org.aspectj.tools.ide.Declaration;

class MethodComparator
implements DeclarationComparator {
    MethodComparator() {
    }

    public boolean compare(Declaration d1, String s) {
        String method1 = MethodComparator.getMethodPrototype(d1);
        String method2 = s;
        return !method1.equals("") && !method2.equals("") && method1.equals(method2);
    }

    public static String getMethodPrototype(Declaration dec) {
        if (dec == null || !dec.getKind().equals("method") && !dec.getKind().equals("constructor")) {
            return "";
        }
        String fullSig = dec.getFullSignature();
        String sig = dec.getSignature();
        String methodName = sig.substring(0, sig.indexOf("("));
        if (methodName.equals("new")) {
            methodName = dec.getDeclaringType();
        }
        String name = dec.getDeclaringType() + "." + methodName;
        String args = fullSig.substring(fullSig.indexOf("(") + 1, fullSig.indexOf(")"));
        String str = name + "(";
        StringTokenizer tok = new StringTokenizer(args, ",");
        if (!tok.hasMoreTokens()) {
            str = str + ")";
        }
        while (tok.hasMoreTokens()) {
            String arg = tok.nextToken().trim();
            String type = arg.substring(0, arg.indexOf(" "));
            str = str + arg.substring(0, arg.indexOf(" ")) + (tok.hasMoreTokens() ? "," : ")");
        }
        return str;
    }
}

