/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.util.List;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.AbstractSourcePane;
import org.aspectj.debugger.gui.AdviceNode;
import org.aspectj.debugger.gui.Advisedable;
import org.aspectj.debugger.gui.Breakable;
import org.aspectj.debugger.gui.MethodHelper;
import org.aspectj.debugger.gui.Sourceable;

abstract class MethodNode
extends AJTreeNode
implements Sourceable,
Breakable,
Advisedable {
    protected MethodHelper helper;

    protected MethodNode(MethodHelper helper) {
        super(AJIcons.METHOD_ICON);
        this.helper = helper;
        this.setUserObject(helper.getDisplayName());
        this.setAlwaysExpand(true);
    }

    public String getRealName() {
        return this.helper.getRealName();
    }

    public String getToolTipText() {
        return this.showClass() + this.helper.getToolTipText();
    }

    private String showClass() {
        if (this.getParent() instanceof AdviceNode) {
            return this.helper.getClassName() + ".";
        }
        return "";
    }

    public void showOnSource(AbstractSourcePane sourcePane) {
        sourcePane.showSourceForFileAndLine(this.helper.getRelativePath(), this.helper.getLine());
    }

    public String getBreakpoint() {
        return this.helper.getBreakpoint();
    }

    public abstract List getAdviceStrings();

    public int getType() {
        return this.helper.getType();
    }

    public static int getType(boolean isCtr, boolean isStatic, boolean isPublic, boolean isPrivate, boolean isProtected) {
        if (isStatic) {
            if (isPublic) {
                return AJIcons.METHOD_STATIC_PUBLIC_ICON;
            }
            if (isProtected) {
                return AJIcons.METHOD_STATIC_PROTECTED_ICON;
            }
            if (isPrivate) {
                return AJIcons.METHOD_STATIC_PRIVATE_ICON;
            }
            return AJIcons.METHOD_STATIC_PACKAGE_ICON;
        }
        if (isCtr) {
            if (isPublic) {
                return AJIcons.CTR_PUBLIC_ICON;
            }
            if (isProtected) {
                return AJIcons.CTR_PROTECTED_ICON;
            }
            if (isPrivate) {
                return AJIcons.CTR_PRIVATE_ICON;
            }
            return AJIcons.CTR_PACKAGE_ICON;
        }
        if (isPublic) {
            return AJIcons.METHOD_PUBLIC_ICON;
        }
        if (isProtected) {
            return AJIcons.METHOD_PROTECTED_ICON;
        }
        if (isPrivate) {
            return AJIcons.METHOD_PRIVATE_ICON;
        }
        return AJIcons.METHOD_PACKAGE_ICON;
    }
}

