/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.Iterator;
import java.util.List;
import org.aspectj.debugger.gui.ClassNode;
import org.aspectj.debugger.gui.SourceNameFactory;

public class NonAJCClassNode
extends ClassNode {
    public NonAJCClassNode(ReferenceType refType) {
        super(refType);
    }

    public void addMethods() {
        List<Method> methods = this.refType().allMethods();
        if (methods == null) {
            return;
        }
        Iterator<Method> iter = methods.iterator();
        while (iter.hasNext()) {
            Method method = iter.next();
            if (method == null) continue;
            this.addMethod(method);
        }
    }

    public String getRelativePath() {
        return SourceNameFactory.sourceName(this.refType());
    }

    public int getLine() {
        int line = 0;
        try {
            return this.refType().allLineLocations().get(0).lineNumber();
        }
        catch (Exception exception) {
            return line;
        }
    }

    protected String kind() {
        return this.refType() instanceof InterfaceType ? "interface" : "class";
    }

    protected String name() {
        return this.refType().name();
    }

    protected String packageName() {
        return "";
    }
}

